/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.SortableList;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

abstract class SortableCategoryList
extends SortableList {
    private static final Logger s_log = Logger.getLogger(SortableCategoryList.class);
    public static final String CHILDREN = "ch";
    private final CategoryRequestLocal m_parent;

    public SortableCategoryList(CategoryRequestLocal parent) {
        super(new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter(CHILDREN)), !"sortKey".equals(ContentSection.getConfig().getCategoryTreeOrder()));
        this.m_parent = parent;
        this.setIdAttr("categorized_objects_list");
    }

    protected final Category getCategory(PageState state) {
        return this.m_parent.getCategory(state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void respond(PageState ps) throws ServletException {
        String event = ps.getControlEventName();
        if ("next".equals(event) || "prev".equals(event)) {
            try {
                ACSObject child = (ACSObject)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.ACSObject", (Object)new BigDecimal(ps.getControlEventValue())));
                Category parent = this.m_parent.getCategory(ps);
                if (!CMS.getContext().getSecurityManager().canAccess("category_admin")) return;
                if ("next".equals(event)) {
                    parent.swapWithNext(child);
                } else {
                    parent.swapWithPrevious(child);
                }
                parent.save();
                return;
            }
            catch (DataObjectNotFoundException e) {
                s_log.error((Object)("Trying to create categories with state = " + ps), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        } else {
            super.respond(ps);
        }
    }
}

