/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.cse;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.ui.admin.Admin;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ContentSoonExpiredPane
extends SimpleContainer {
    private static final Logger log = Logger.getLogger(ContentSoonExpiredPane.class);
    private DataTable dataTable;

    public ContentSoonExpiredPane() {
        this.add((Component)this.getDataTable());
    }

    public final void generateXML(PageState state, Element parent) {
        if (!this.isVisible(state)) {
            return;
        }
        SecurityManager sm = CMS.getContext().getSecurityManager();
        User user = Web.getContext().getUser();
        DataTable dt = this.getDataTable();
        DataQuery dq = dt.getDataQuery(state);
        dq.addFilter(ContentSoonExpiredPane.getViewFilter(dq, user));
        dt.generateXML(state, parent);
    }

    private static Filter getViewFilter(DataQuery query, User user) {
        PrivilegeDescriptor privilege = new PrivilegeDescriptor("cms_read_item");
        FilterFactory ff = query.getFilterFactory();
        OID partyOID = user.getOID();
        return PermissionService.getFilterQuery((FilterFactory)ff, (String)"objectId", (PrivilegeDescriptor)privilege, (OID)partyOID);
    }

    protected DataTable getDataTable() {
        if (this.dataTable == null) {
            this.dataTable = new DataTable((DataQueryBuilder)new ContentSoonExpiredQueryBuilder());
            this.dataTable.addColumn(GlobalizationUtil.globalize("cms.ui.cse.authorName").localize().toString(), "authorName", true);
            this.dataTable.addColumn(GlobalizationUtil.globalize("cms.ui.cse.itemName").localize().toString(), "objectId", true, (TableCellRenderer)new ItemTitleCellRender());
            this.dataTable.addColumn(GlobalizationUtil.globalize("cms.ui.cse.view").localize().toString(), "objectId", false, (TableCellRenderer)new ItemViewLinkCellRender());
            this.dataTable.addColumn(GlobalizationUtil.globalize("cms.ui.cse.edit").localize().toString(), "objectId", false, (TableCellRenderer)new ItemEditLinkCellRender());
            this.dataTable.addColumn(GlobalizationUtil.globalize("cms.ui.cse.endDateTime").localize().toString(), "endDateTime", true);
        }
        return this.dataTable;
    }

    private static boolean hasSiteWideAdmin(User user) {
        Application adminApp = Admin.getInstance();
        if (adminApp == null) {
            return false;
        }
        PermissionDescriptor admin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)adminApp, (Party)user);
        return PermissionService.checkPermission((PermissionDescriptor)admin);
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)ContentSoonExpiredPane.gz(key).localize();
    }

    private static ContentItem getItemFromIdString(String idString) {
        return new ContentItem(new OID(ContentItem.class.getName(), Integer.parseInt(idString)));
    }

    private static BigDecimal getItemDraft(String idString) {
        ContentItem item = ContentSoonExpiredPane.getItemFromIdString(idString);
        return item.getDraftVersion().getID();
    }

    private class ItemViewLinkCellRender
    implements TableCellRenderer {
        private ThreadLocal threadLocal;

        public ItemViewLinkCellRender() {
            this.threadLocal = new ThreadLocal(){

                protected Object initialValue() {
                    return new Link((Component)new Label(), "");
                }
            };
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            BigDecimal id = (BigDecimal)key;
            Link l = (Link)this.threadLocal.get();
            ContentItem item = ContentSoonExpiredPane.getItemFromIdString(id.toString());
            String url = ".jsp";
            while (item.getParent() != null) {
                if (!(item.getParent() instanceof ContentItem)) continue;
                if ("/".equals((item = (ContentItem)item.getParent()).getName())) break;
                url = "/" + item.getName() + url;
            }
            ContentSection section = CMS.getContext().getContentSection();
            l.setTarget("/" + section.getName() + url);
            ((Label)l.getChild()).setLabel(GlobalizationUtil.globalize("cms.ui.cse.viewLink"));
            return l;
        }
    }

    private class ItemEditLinkCellRender
    implements TableCellRenderer {
        private ThreadLocal threadLocal;

        public ItemEditLinkCellRender() {
            this.threadLocal = new ThreadLocal(){

                protected Object initialValue() {
                    return new Link((Component)new Label(), "");
                }
            };
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            boolean canEdit = false;
            BigDecimal id = (BigDecimal)key;
            User user = Web.getContext().getUser();
            ContentItem ci = ContentSoonExpiredPane.getItemFromIdString(id.toString());
            Iterator permissions = PermissionService.getImpliedPrivileges((OID)ci.getOID(), (OID)user.getOID());
            while (permissions.hasNext()) {
                PrivilegeDescriptor permission = (PrivilegeDescriptor)permissions.next();
                if (!permission.equals((Object)PrivilegeDescriptor.ADMIN) && !permission.equals((Object)PrivilegeDescriptor.EDIT)) continue;
                canEdit = true;
                break;
            }
            if (!canEdit) {
                return new Label("");
            }
            Link l = (Link)this.threadLocal.get();
            l.setTarget(ContentItemPage.getRelativeItemURL(ContentSoonExpiredPane.getItemDraft(id.toString()), ContentItemPage.AUTHORING_TAB));
            ((Label)l.getChild()).setLabel(GlobalizationUtil.globalize("cms.ui.cse.editLink"));
            return l;
        }
    }

    private class ItemTitleCellRender
    implements TableCellRenderer {
        private ThreadLocal threadLocal;

        public ItemTitleCellRender() {
            this.threadLocal = new ThreadLocal(){

                protected Object initialValue() {
                    return new Label("");
                }
            };
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            BigDecimal id = (BigDecimal)key;
            Label l = (Label)this.threadLocal.get();
            l.setLabel(ContentSoonExpiredPane.getItemFromIdString(id.toString()).getDisplayName());
            return l;
        }
    }

    private class ContentSoonExpiredQueryBuilder
    implements DataQueryBuilder {
        private ContentSoonExpiredQueryBuilder() {
        }

        public String getKeyColumn() {
            return "objectId";
        }

        public DataQuery makeDataQuery(DataTable t, PageState s) {
            Session ses = SessionManager.getSession();
            DataQuery query = ses.retrieveQuery("com.arsdigita.cms.getContentItemExpiredBeforeInSection");
            int months = ContentSection.getConfig().getSoonExpiredMonths();
            int days = ContentSection.getConfig().getSoonExpiredDays();
            Calendar now = Calendar.getInstance();
            now.add(6, days);
            now.add(2, months);
            query.setParameter("endDateTime", (Object)now.getTime());
            ContentSection section = CMS.getContext().getContentSection();
            query.setParameter("sectionId", (Object)section.getID());
            return query;
        }

        public void lock() {
        }

        public boolean isLocked() {
            return false;
        }
    }
}

