/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ui.folder.FolderRequestLocal;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;

final class ChildUniqueValidationListener
implements ParameterListener {
    private final FolderRequestLocal m_parent;

    public ChildUniqueValidationListener(FolderRequestLocal parent) {
        this.m_parent = parent;
    }

    public final void validate(ParameterEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        String name = (String)e.getParameterData().getValue();
        if (name != null) {
            this.validateNameUniqueness(this.m_parent.getFolder(state), name);
        }
    }

    private void validateNameUniqueness(Folder parent, String name) throws FormProcessException {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.validateUniqueItemName");
        query.setParameter("parentId", (Object)parent.getID());
        query.setParameter("name", (Object)name);
        if (query.next()) {
            long count = ((BigDecimal)query.get("size")).longValue();
            query.close();
            if (count > 0L) {
                throw new FormProcessException("An item with this name already exists");
            }
        } else {
            throw new IllegalStateException();
        }
    }
}

