/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Image;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableHeader;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.LanguageInvariantContentItem;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.folder.FolderManipulator;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.FormatStandards;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class FolderBrowser
extends Table {
    private static final Logger s_log = Logger.getLogger(FolderBrowser.class);
    private static GlobalizedMessage[] s_headers = new GlobalizedMessage[]{FolderBrowser.globalize("cms.ui.folder.name"), FolderBrowser.globalize("cms.ui.folder.languages"), FolderBrowser.globalize("cms.ui.folder.title"), FolderBrowser.globalize("cms.ui.folder.type"), FolderBrowser.globalize("cms.ui.folder.creation_date"), FolderBrowser.globalize("cms.ui.folder.last_modified"), FolderBrowser.globalize("cms.ui.folder.action"), FolderBrowser.globalize("cms.ui.folder.index")};
    private static GlobalizedMessage[] s_noIndexHeaders = new GlobalizedMessage[]{FolderBrowser.globalize("cms.ui.folder.name"), FolderBrowser.globalize("cms.ui.folder.languages"), FolderBrowser.globalize("cms.ui.folder.title"), FolderBrowser.globalize("cms.ui.folder.type"), FolderBrowser.globalize("cms.ui.folder.creation_date"), FolderBrowser.globalize("cms.ui.folder.last_modified"), FolderBrowser.globalize("cms.ui.folder.action")};
    private static final String SORT_ACTION_UP = "sortActionUp";
    private static final String SORT_ACTION_DOWN = "sortActionDown";
    private FolderSelectionModel m_currentFolder;
    private TableActionListener m_folderChanger;
    private TableActionListener m_deleter;
    private TableActionListener m_indexChanger;
    private TableColumn m_nameColumn;
    private TableColumn m_deleteColumn;
    private TableColumn m_indexColumn;
    private static final String SORT_KEY_NAME = "name";
    private static final String SORT_KEY_TITLE = "title";
    private static final String SORT_KEY_LAST_MODIFIED_DATE = "lastModified";
    private static final String SORT_KEY_CREATION_DATE = "creationDate";
    private StringParameter m_sortType = new StringParameter("sortType");
    private StringParameter m_sortDirection = new StringParameter("sortDirn");
    private StringParameter m_aToZfilter = null;
    private StringParameter m_filter = null;
    private FolderManipulator.FilterForm m_filterForm;
    private long m_folderSize;

    public FolderBrowser(FolderSelectionModel currentFolder) {
        this.m_sortType.setDefaultValue((Object)SORT_KEY_NAME);
        this.m_sortDirection.setDefaultValue((Object)SORT_ACTION_UP);
        this.setModelBuilder((TableModelBuilder)new FolderTableModelBuilder(currentFolder));
        this.setColumnModel((TableColumnModel)new DefaultTableColumnModel((Object[])(FolderBrowser.hideIndexColumn() ? s_noIndexHeaders : s_headers)));
        this.setHeader(new TableHeader(this.getColumnModel()));
        ((FolderTableModelBuilder)this.getModelBuilder()).setFolderBrowser(this);
        this.m_currentFolder = currentFolder;
        this.setClassAttr("dataTable");
        this.getHeader().setDefaultRenderer((TableCellRenderer)new com.arsdigita.cms.ui.util.DefaultTableCellRenderer());
        this.m_nameColumn = this.getColumn(0);
        this.m_nameColumn.setCellRenderer((TableCellRenderer)new NameCellRenderer());
        this.m_nameColumn.setHeaderRenderer((TableCellRenderer)new HeaderCellRenderer(SORT_KEY_NAME));
        this.getColumn(1).setCellRenderer((TableCellRenderer)new LanguagesCellRenderer());
        this.getColumn(2).setHeaderRenderer((TableCellRenderer)new HeaderCellRenderer(SORT_KEY_TITLE));
        this.getColumn(4).setHeaderRenderer((TableCellRenderer)new HeaderCellRenderer(SORT_KEY_CREATION_DATE));
        this.getColumn(5).setHeaderRenderer((TableCellRenderer)new HeaderCellRenderer(SORT_KEY_LAST_MODIFIED_DATE));
        this.m_deleteColumn = this.getColumn(6);
        this.m_deleteColumn.setCellRenderer((TableCellRenderer)new ActionCellRenderer());
        this.m_deleteColumn.setAlign("center");
        if (!FolderBrowser.hideIndexColumn()) {
            this.m_indexColumn = this.getColumn(7);
            this.m_indexColumn.setCellRenderer((TableCellRenderer)new IndexToggleRenderer());
            this.m_indexColumn.setAlign("center");
            this.m_indexChanger = new IndexChanger(this.m_currentFolder);
            this.addTableActionListener(this.m_indexChanger);
        }
        this.m_folderChanger = new FolderChanger();
        this.addTableActionListener(this.m_folderChanger);
        this.m_deleter = new ItemDeleter();
        this.addTableActionListener(this.m_deleter);
        this.setEmptyView((Component)new Label(FolderBrowser.globalize("cms.ui.folder.no_items")));
        Assert.exists((Object)this.m_currentFolder.getStateParameter());
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, this.m_currentFolder.getStateParameter());
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_sortType);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_sortDirection);
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                if (state.isVisibleOnPage((Component)FolderBrowser.this)) {
                    FolderBrowser.this.showHideFolderActions(state);
                }
            }
        });
    }

    private void showHideFolderActions(PageState state) {
        SecurityManager sm = Utilities.getSecurityManager(state);
        Folder folder = (Folder)this.m_currentFolder.getSelectedObject(state);
        Assert.exists((Object)folder);
        boolean canDelete = sm.canAccess(state.getRequest(), "delete_item", (ContentItem)folder);
        this.m_deleteColumn.setVisible(state, canDelete);
    }

    public void respond(PageState state) throws ServletException {
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        if (SORT_ACTION_UP.equals(key)) {
            state.setValue((ParameterModel)this.m_sortType, (Object)value);
            state.setValue((ParameterModel)this.m_sortDirection, (Object)SORT_ACTION_UP);
        } else if (SORT_ACTION_DOWN.equals(key)) {
            state.setValue((ParameterModel)this.m_sortType, (Object)value);
            state.setValue((ParameterModel)this.m_sortDirection, (Object)SORT_ACTION_DOWN);
        } else {
            super.respond(state);
        }
    }

    public FolderSelectionModel getFolderSelectionModel() {
        return this.m_currentFolder;
    }

    protected void setFilterForm(FolderManipulator.FilterForm filterForm) {
        this.m_filterForm = filterForm;
    }

    protected void setAtoZfilterParameter(StringParameter aToZfilter) {
        this.m_aToZfilter = aToZfilter;
    }

    protected void setFilterParameter(StringParameter filter) {
        this.m_filter = filter;
    }

    protected long getFolderSize() {
        return this.m_folderSize;
    }

    private static GlobalizedMessage globalize(String key) {
        return FolderManipulator.globalize(key);
    }

    private static boolean hideIndexColumn() {
        return ContentSection.getConfig().getHideFolderIndexCheckbox();
    }

    private class IndexChanger
    extends TableActionAdapter {
        private FolderSelectionModel m_fol;

        public IndexChanger(FolderSelectionModel fol) {
            this.m_fol = fol;
        }

        public void cellSelected(TableActionEvent e) {
            PageState state = e.getPageState();
            BigDecimal rowkey = new BigDecimal((String)e.getRowKey());
            if (rowkey == null) {
                return;
            }
            try {
                ContentBundle contentItem = new ContentBundle(rowkey);
                Folder folder = (Folder)this.m_fol.getSelectedObject(state);
                ContentBundle currentIndexItem = folder.getIndexItem();
                if (currentIndexItem == null || currentIndexItem.getID().compareTo(contentItem.getID()) != 0) {
                    folder.setIndexItem(contentItem);
                } else {
                    folder.removeIndexItem();
                }
                folder.save();
            }
            catch (DataObjectNotFoundException donfe) {
                // empty catch block
            }
        }
    }

    private class FolderChanger
    extends TableActionAdapter {
        private FolderChanger() {
        }

        public void cellSelected(TableActionEvent e) {
            PageState s = e.getPageState();
            int col = e.getColumn();
            if (FolderBrowser.this.m_nameColumn != FolderBrowser.this.getColumn(col)) {
                return;
            }
            String key = (String)e.getRowKey();
            if (key.startsWith("-")) {
                FolderBrowser.this.clearSelection(s);
                FolderBrowser.this.getFolderSelectionModel().setSelectedKey(s, key.substring(1));
            }
        }
    }

    private static class FolderTableModel
    implements TableModel {
        private static final int NAME = 0;
        private static final int LANGUAGES = 1;
        private static final int TITLE = 2;
        private static final int TYPE = 3;
        private static final int CREATION_DATE = 4;
        private static final int LAST_MODIFIED = 5;
        private static final int DELETABLE = 6;
        private static final int IS_INDEX = 7;
        private PageState m_state;
        private FolderBrowser m_table;
        private Folder.ItemCollection m_itemColl;
        private Folder m_fol;
        private BigDecimal m_folIndexID;

        public FolderTableModel(FolderBrowser table, PageState state, Folder.ItemCollection itemColl) {
            this.m_state = state;
            this.m_table = table;
            this.m_itemColl = itemColl;
            this.m_fol = (Folder)table.getFolderSelectionModel().getSelectedObject(state);
            if (!FolderBrowser.hideIndexColumn()) {
                ContentBundle indexItem = this.m_fol.getIndexItem();
                this.m_folIndexID = indexItem == null ? null : indexItem.getID();
            }
        }

        public int getColumnCount() {
            return FolderBrowser.hideIndexColumn() ? 7 : 8;
        }

        public boolean nextRow() {
            return this.m_itemColl.next();
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_itemColl;
                }
                case 1: {
                    return this.m_itemColl;
                }
                case 2: {
                    return this.m_itemColl.getDisplayName();
                }
                case 3: {
                    return this.m_itemColl.getTypeLabel();
                }
                case 4: {
                    Date creationDate = this.m_itemColl.getCreationDate();
                    if (creationDate == null) {
                        return "--";
                    }
                    return FormatStandards.formatDate((Date)creationDate);
                }
                case 5: {
                    Date lastModified = this.m_itemColl.getLastModifiedDate();
                    if (lastModified == null) {
                        return "--";
                    }
                    return FormatStandards.formatDate((Date)lastModified);
                }
                case 6: {
                    return this.isDeletable();
                }
                case 7: {
                    if (FolderBrowser.hideIndexColumn()) {
                        throw new IndexOutOfBoundsException("Column index " + columnIndex + " not in table model.");
                    }
                    if (this.m_itemColl.isFolder()) {
                        return null;
                    }
                    if (this.m_folIndexID == null) {
                        return false;
                    }
                    return this.m_folIndexID.compareTo(this.m_itemColl.getBundleID()) == 0;
                }
            }
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " not in table model.");
        }

        public boolean isDeletable() {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Checking to see if " + this + " is deletable"));
            }
            if (this.m_itemColl.isFolder()) {
                if (!this.m_itemColl.hasChildren()) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)"The item is an empty folder; it may be deleted");
                    }
                    return true;
                }
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"The folder is not empty; it cannot be deleted");
                }
                return false;
            }
            if (this.m_itemColl.getContentItem().hasLiveInstance()) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"This item has a live instance; it cannot be deleted");
                }
                return false;
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"The item is not a folder and doesn't have a live instance; it may be deleted");
            }
            return true;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_itemColl.isFolder() ? this.m_itemColl.getID().negate() : this.m_itemColl.getBundleID();
        }
    }

    private class ItemDeleter
    extends TableActionAdapter {
        private ItemDeleter() {
        }

        public void cellSelected(TableActionEvent e) {
            int col = e.getColumn();
            if (FolderBrowser.this.m_deleteColumn != FolderBrowser.this.getColumn(col)) {
                return;
            }
            PageState s = e.getPageState();
            BigDecimal id = new BigDecimal(e.getRowKey().toString());
            OID oid = new OID("com.arsdigita.cms.ContentItem", (Object)id.abs());
            DomainObject item = DomainObjectFactory.newInstance((OID)oid);
            if (item != null) {
                if (item instanceof ContentBundle) {
                    ContentBundle bundle = (ContentBundle)item;
                    ItemCollection instances = bundle.getInstances();
                    while (instances.next()) {
                        instances.getContentItem().delete();
                    }
                }
                item.delete();
            }
            ((Table)e.getSource()).clearSelection(s);
        }
    }

    private final class IndexToggleRenderer
    implements TableCellRenderer {
        private IndexToggleRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (value == null) {
                return new Label(GlobalizationUtil.globalize("cms.ui.folder.na"));
            }
            ControlLink link = new ControlLink("");
            if (((Boolean)value).booleanValue()) {
                link.setClassAttr("checkBoxChecked");
            } else {
                link.setClassAttr("checkBoxUnchecked");
            }
            return link;
        }
    }

    private static class ActionCellRenderer
    implements TableCellRenderer {
        private static final Label s_noAction;
        private static final ControlLink s_link;
        private static final Logger logger;

        private ActionCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (((Boolean)value).booleanValue()) {
                return s_link;
            }
            return s_noAction;
        }

        static {
            logger = Logger.getLogger(ActionCellRenderer.class);
            logger.debug((Object)"Static initializer is starting...");
            s_noAction = new Label("&nbsp;", false);
            s_noAction.lock();
            s_link = new ControlLink((Component)new Label(FolderBrowser.globalize("cms.ui.folder.delete")));
            s_link.setConfirmation(FolderBrowser.globalize("cms.ui.folder.delete_confirmation"));
            logger.debug((Object)"Static initializer finished.");
        }
    }

    private class LanguagesCellRenderer
    extends DefaultTableCellRenderer {
        public LanguagesCellRenderer() {
            super(true);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ContentPage cp;
            Folder.ItemCollection coll = (Folder.ItemCollection)((Object)value);
            String name = coll.getName();
            if (coll.isFolder()) {
                return new Label();
            }
            try {
                cp = new ContentPage(coll.getID());
            }
            catch (DataObjectNotFoundException ex) {
                return new Label();
            }
            ContentBundle bundle = cp.getContentBundle();
            ContentSection section = CMS.getContext().getContentSection();
            if (!(bundle == null || cp instanceof LanguageInvariantContentItem && ((LanguageInvariantContentItem)((Object)cp)).isLanguageInvariant())) {
                Iterator<String> languages = bundle.getLanguages().iterator();
                StringBuilder temp = new StringBuilder(20);
                SimpleContainer container = new SimpleContainer();
                while (languages.hasNext()) {
                    String lang = languages.next();
                    ContentItem ci = bundle.getInstance(lang, false);
                    StringBuilder fontWeight = new StringBuilder(2);
                    StringBuilder classes = new StringBuilder(20);
                    if (ci.isLive()) {
                        fontWeight.append("b");
                        classes.append("live ");
                    }
                    if (bundle.getPrimaryInstance().equals(ci)) {
                        fontWeight.append("i");
                        classes.append("primaryInstance");
                    }
                    Label langLabel = new Label(lang);
                    langLabel.setFontWeight(fontWeight.toString().trim());
                    langLabel.setClassAttr(classes.toString().trim());
                    if (section == null) {
                        container.add((Component)langLabel);
                    } else {
                        ItemResolver resolver = section.getItemResolver();
                        container.add((Component)new Link((Component)langLabel, resolver.generateItemURL(state, ci.getID(), name, section, coll.getVersion())));
                    }
                    if (!languages.hasNext()) continue;
                    container.add((Component)new Label("&nbsp;", false));
                }
                return container;
            }
            return new Label();
        }
    }

    private class NameCellRenderer
    extends DefaultTableCellRenderer {
        public NameCellRenderer() {
            super(true);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Folder.ItemCollection coll = (Folder.ItemCollection)((Object)value);
            String name = coll.getName();
            if (coll.isFolder()) {
                return super.getComponent(table, state, (Object)name, isSelected, key, row, column);
            }
            ContentSection section = CMS.getContext().getContentSection();
            BigDecimal id = coll.getID();
            if (section == null) {
                return new Label(name);
            }
            ItemResolver resolver = section.getItemResolver();
            return new Link(name, resolver.generateItemURL(state, id, name, section, coll.getVersion()));
        }
    }

    private class HeaderCellRenderer
    extends com.arsdigita.cms.ui.util.DefaultTableCellRenderer {
        private String m_key;

        public HeaderCellRenderer(String key) {
            super(true);
            this.m_key = key;
        }

        @Override
        public Component getComponent(final Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            String headerName = (String)((GlobalizedMessage)value).localize();
            String sortKey = (String)state.getValue((ParameterModel)FolderBrowser.this.m_sortType);
            final boolean isCurrentKey = sortKey.equals(this.m_key);
            final String currentSortDirection = (String)state.getValue((ParameterModel)FolderBrowser.this.m_sortDirection);
            String imageURLStub = FolderBrowser.SORT_ACTION_UP.equals(currentSortDirection) ? "gray-triangle-up.gif" : "gray-triangle-down.gif";
            ControlLink cl = new ControlLink(headerName){

                public void setControlEvent(PageState ps) {
                    String sortDirectionAction = FolderBrowser.SORT_ACTION_UP.equals(currentSortDirection) && isCurrentKey ? FolderBrowser.SORT_ACTION_DOWN : FolderBrowser.SORT_ACTION_UP;
                    ps.setControlEvent((Component)table, sortDirectionAction, HeaderCellRenderer.this.m_key);
                }
            };
            Label l = new Label();
            l.setLabel(headerName);
            l.setClassAttr("folderBrowserLink");
            l.setOutputEscaping(false);
            l.setFontWeight("b");
            SimpleContainer container = new SimpleContainer();
            container.add((Component)l);
            if (isCurrentKey) {
                Image image = new Image("/assets/" + imageURLStub);
                image.setBorder("0");
                container.add((Component)image);
            }
            cl.setChild((Component)container);
            return cl;
        }
    }

    private class FolderTableModelBuilder
    extends AbstractTableModelBuilder
    implements PaginationModelBuilder,
    FolderManipulator.FilterFormModelBuilder {
        private FolderSelectionModel m_folder;
        private RequestLocal m_size;
        private RequestLocal m_itemColl;
        private FolderBrowser m_fb;

        public FolderTableModelBuilder(FolderSelectionModel sel) {
            this(sel, null);
        }

        public FolderTableModelBuilder(FolderSelectionModel sel, FolderBrowser fb) {
            this.m_folder = sel;
            this.m_size = new RequestLocal();
            this.m_itemColl = new RequestLocal();
            this.m_fb = fb;
        }

        public TableModel makeModel(Table t, PageState s) {
            FolderSelectionModel sel = ((FolderBrowser)t).getFolderSelectionModel();
            Folder f = (Folder)sel.getSelectedObject(s);
            if (f == null) {
                return Table.EMPTY_MODEL;
            }
            t.getRowSelectionModel().clearSelection(s);
            s_log.debug((Object)String.format("filter = '%s'", s.getValue((ParameterModel)FolderBrowser.this.m_filter)));
            Folder.ItemCollection itemColl = (Folder.ItemCollection)((Object)this.m_itemColl.get(s));
            s_log.debug((Object)String.format("itemColl.size = %d", itemColl.size()));
            FolderBrowser.this.m_folderSize = itemColl.size();
            if (s.getValue((ParameterModel)FolderBrowser.this.m_aToZfilter) != null) {
                itemColl.addFilter(String.format("lower(name) like lower('%s%%') or lower(displayName) like lower('%s%%')", s.getValue((ParameterModel)FolderBrowser.this.m_aToZfilter), s.getValue((ParameterModel)FolderBrowser.this.m_aToZfilter)));
            }
            if (s.getValue((ParameterModel)FolderBrowser.this.m_filter) != null) {
                itemColl.addFilter(String.format("lower(name) like lower('%%%s%%') or lower(displayName) like lower('%%%s%%')", s.getValue((ParameterModel)FolderBrowser.this.m_filter), s.getValue((ParameterModel)FolderBrowser.this.m_filter)));
            }
            return new FolderTableModel((FolderBrowser)t, s, itemColl);
        }

        @Override
        public long getFolderSize(PageState state) {
            Folder f = (Folder)this.m_folder.getSelectedObject(state);
            Folder.ItemCollection itemColl = f.getPrimaryInstances();
            if (itemColl == null) {
                return 0L;
            }
            return itemColl.size();
        }

        public int getTotalSize(Paginator paginator, PageState state) {
            Integer size = (Integer)this.m_size.get(state);
            if (size == null) {
                Folder f = (Folder)this.m_folder.getSelectedObject(state);
                Folder.ItemCollection itemColl = f.getPrimaryInstances();
                if (itemColl == null) {
                    return 0;
                }
                if (state.getValue((ParameterModel)FolderBrowser.this.m_aToZfilter) != null) {
                    itemColl.addFilter(String.format("lower(name) like lower('%s%%') or lower(displayName) like lower('%s%%')", state.getValue((ParameterModel)FolderBrowser.this.m_aToZfilter), state.getValue((ParameterModel)FolderBrowser.this.m_aToZfilter)));
                }
                if (state.getValue((ParameterModel)FolderBrowser.this.m_filter) != null) {
                    itemColl.addFilter(String.format("lower(name) like lower('%%%s%%') or lower(displayName) like lower('%%%s%%')", state.getValue((ParameterModel)FolderBrowser.this.m_filter), state.getValue((ParameterModel)FolderBrowser.this.m_filter)));
                }
                PermissionService.filterQuery((DataQuery)itemColl, (String)"id", (PrivilegeDescriptor)PrivilegeDescriptor.READ, (OID)Kernel.getContext().getParty().getOID());
                size = new Integer((int)itemColl.size());
                itemColl.setRange(new Integer(paginator.getFirst(state)), new Integer(paginator.getLast(state) + 1));
                String sortKey = (String)state.getValue((ParameterModel)FolderBrowser.this.m_sortType);
                String direction = "asc";
                if (FolderBrowser.SORT_ACTION_DOWN.equals((String)state.getValue((ParameterModel)FolderBrowser.this.m_sortDirection))) {
                    direction = "desc";
                }
                if (sortKey.equals(FolderBrowser.SORT_KEY_TITLE)) {
                    itemColl.setOrder("lower(item.displayName) " + direction);
                } else if (sortKey.equals(FolderBrowser.SORT_KEY_NAME)) {
                    itemColl.setOrder("lower(item.name) " + direction);
                } else if (sortKey.equals(FolderBrowser.SORT_KEY_LAST_MODIFIED_DATE)) {
                    itemColl.setOrder("item.auditing.lastModifiedDate " + direction);
                } else if (sortKey.equals(FolderBrowser.SORT_KEY_CREATION_DATE)) {
                    itemColl.setOrder("item.auditing.creationDate " + direction);
                }
                this.m_size.set(state, (Object)size);
                this.m_itemColl.set(state, (Object)itemColl);
            }
            return size;
        }

        public void setFolderBrowser(FolderBrowser fb) {
            this.m_fb = fb;
        }

        public boolean isVisible(PageState state) {
            return this.m_fb != null ? this.m_fb.isVisible(state) : true;
        }
    }
}

