/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ui.folder.FolderBaseForm;
import com.arsdigita.cms.ui.folder.FolderRequestLocal;
import org.apache.log4j.Logger;

class FolderEditForm
extends FolderBaseForm {
    private static Logger s_log = Logger.getLogger(FolderEditForm.class);
    private final FolderRequestLocal m_folder;

    public FolderEditForm(FolderRequestLocal folder) {
        super("folder-edit");
        this.m_folder = folder;
        this.addInitListener(new InitListener());
        this.addProcessListener(new ProcessListener());
    }

    private static FolderRequestLocal parent(final FolderRequestLocal folder) {
        FolderRequestLocal parent = new FolderRequestLocal(null){

            @Override
            protected final Object initialValue(PageState state) {
                return (Folder)folder.getFolder(state).getParent();
            }
        };
        return parent;
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            Folder folder = FolderEditForm.this.m_folder.getFolder(state);
            folder.setLabel((String)FolderEditForm.this.m_title.getValue(state));
            folder.setName((String)FolderEditForm.this.m_fragment.getValue(state));
            folder.save();
            Folder live = (Folder)folder.getLiveVersion();
            if (live != null) {
                live.setLabel((String)FolderEditForm.this.m_title.getValue(state));
                live.setName((String)FolderEditForm.this.m_fragment.getValue(state));
                live.save();
            }
        }
    }

    private class InitListener
    implements FormInitListener {
        private InitListener() {
        }

        public final void init(FormSectionEvent e) {
            PageState state = e.getPageState();
            Folder folder = FolderEditForm.this.m_folder.getFolder(state);
            FolderEditForm.this.m_title.setValue(state, (Object)folder.getLabel());
            FolderEditForm.this.m_fragment.setValue(state, (Object)folder.getName());
        }
    }
}

