/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.AccessDeniedException;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ContentSectionPage;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.NewItemForm;
import com.arsdigita.cms.ui.folder.FolderCreator;
import com.arsdigita.cms.ui.folder.FolderEditor;
import com.arsdigita.cms.ui.folder.FolderManipulator;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.ui.permissions.CMSPermissionsPane;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class FolderItemPane
extends SegmentedPanel
implements FormProcessListener,
ChangeListener,
FormSubmissionListener,
Resettable,
ActionListener {
    private static final String CONTENT_TYPE_ID = "ct";
    private static final String CMS_PRIVILEGES = "com.arsdigita.cms.getPrivileges";
    private static final String PRIVILEGE = "privilege";
    private static final String PRIVILEGE_NAME = "prettyName";
    public static int LIST_SIZE = 20;
    private NewItemForm m_newItem;
    private SingleSelectionModel m_typeSel;
    private FolderSelectionModel m_folderSel;
    private CreationSelector m_selector;
    private FolderManipulator m_folderManip;
    private FolderCreator m_folderCreator;
    private ActionLink m_createFolderAction;
    private ActionLink m_togglePrivateAction;
    private SegmentedPanel.Segment m_browseSeg;
    private SegmentedPanel.Segment m_newItemSeg;
    private SegmentedPanel.Segment m_newFolderSeg;
    private SegmentedPanel.Segment m_editFolderSeg;
    private SegmentedPanel.Segment m_permissionsSeg;
    private CMSPermissionsPane m_permPane;
    private ActionLink m_editFolderAction;
    private FolderEditor m_folderEditor;
    private Label m_contentLabel;
    private Label m_itemPath;
    private Label m_chooseLabel;

    public FolderItemPane() {
        this(new FolderSelectionModel("folder"));
    }

    public FolderItemPane(FolderSelectionModel folderSel) {
        this.setIdAttr("flat-item-list");
        this.m_folderSel = folderSel;
        this.m_newItemSeg = this.addSegment();
        this.m_newItemSeg.setIdAttr("folder-new-item");
        this.m_newFolderSeg = this.addSegment();
        this.m_newFolderSeg.setIdAttr("folder-new-folder");
        this.m_editFolderSeg = this.addSegment();
        this.m_editFolderSeg.setIdAttr("folder-edit-folder");
        this.m_browseSeg = this.addSegment();
        this.m_browseSeg.setIdAttr("folder-browse");
        ActionGroup browseActions = new ActionGroup();
        this.m_browseSeg.add((Component)browseActions);
        this.m_contentLabel = new Label(FolderItemPane.globalize("cms.ui.contents_of"), false);
        this.m_browseSeg.addHeader((Component)this.m_contentLabel);
        this.m_chooseLabel = new Label(FolderItemPane.globalize("cms.ui.choose_target_folder"), false);
        this.m_browseSeg.addHeader((Component)this.m_chooseLabel);
        this.m_itemPath = new Label(new PrintListener(){

            public final void prepare(PrintEvent e) {
                Folder f = (Folder)FolderItemPane.this.m_folderSel.getSelectedObject(e.getPageState());
                ((Label)e.getTarget()).setLabel(f.getDisplayName());
            }
        });
        this.m_browseSeg.addHeader((Component)this.m_itemPath);
        this.m_folderManip = new FolderManipulator(this.m_folderSel);
        this.m_folderManip.getItemView().addProcessListener((FormProcessListener)this);
        this.m_folderManip.getTargetSelector().addProcessListener((FormProcessListener)this);
        this.m_folderManip.getTargetSelector().addSubmissionListener((FormSubmissionListener)this);
        browseActions.setSubject((Component)this.m_folderManip);
        this.m_createFolderAction = new ActionLink((Component)new Label(FolderItemPane.globalize("cms.ui.new_folder")));
        this.m_createFolderAction.addActionListener((ActionListener)this);
        browseActions.addAction((Component)this.m_createFolderAction);
        this.m_editFolderAction = new ActionLink((Component)new Label(FolderItemPane.globalize("cms.ui.edit_folder")));
        this.m_editFolderAction.addActionListener((ActionListener)this);
        browseActions.addAction((Component)this.m_editFolderAction);
        this.m_newItem = new SectionNewItemForm("newItem");
        this.m_newItem.addProcessListener(this);
        browseActions.addAction((Component)this.m_newItem);
        this.m_permissionsSeg = this.addSegment();
        this.m_permissionsSeg.setIdAttr("folder-permissions");
        ActionGroup permActions = new ActionGroup();
        this.m_permissionsSeg.add((Component)permActions);
        this.m_permissionsSeg.addHeader((Component)new Label(GlobalizationUtil.globalize("cms.ui.permissions")));
        ArrayList<PrivilegeDescriptor> privs = new ArrayList<PrivilegeDescriptor>();
        HashMap<String, String> privNameMap = new HashMap<String, String>();
        DataQuery query = SessionManager.getSession().retrieveQuery(CMS_PRIVILEGES);
        query.addFilter("scope != 'section'");
        query.addOrder("sortOrder");
        while (query.next()) {
            String privilege = (String)query.get(PRIVILEGE);
            String privilegeName = (String)query.get(PRIVILEGE_NAME);
            privs.add(PrivilegeDescriptor.get((String)privilege));
            privNameMap.put(privilege, privilegeName);
        }
        query.close();
        this.m_permPane = new CMSPermissionsPane(privs.toArray(new PrivilegeDescriptor[privs.size()]), privNameMap, this.m_folderSel);
        permActions.setSubject((Component)this.m_permPane);
        this.m_togglePrivateAction = new ActionLink((Component)new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Label target = (Label)e.getTarget();
                Folder currentFolder = (Folder)FolderItemPane.this.m_folderSel.getSelectedObject(state);
                DataObject context = PermissionService.getContext((ACSObject)currentFolder);
                if (context == null) {
                    target.setLabel((String)GlobalizationUtil.globalize("cms.ui.restore_default_permissions").localize());
                } else {
                    target.setLabel((String)GlobalizationUtil.globalize("cms.ui.use_custom_permissions").localize());
                }
            }
        }));
        this.m_togglePrivateAction.addActionListener((ActionListener)this);
        permActions.addAction((Component)this.m_togglePrivateAction);
        this.m_newItemSeg.addHeader((Component)new Label(FolderItemPane.globalize("cms.ui.new_item")));
        this.m_typeSel = new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter(CONTENT_TYPE_ID));
        this.m_typeSel.addChangeListener((ChangeListener)this);
        this.m_selector = new CreationSelector(this.m_typeSel, this.m_folderSel);
        this.m_newItemSeg.add((Component)this.m_selector);
        this.m_newItemSeg.add((Component)new Label("<br/>", false));
        this.m_newFolderSeg.addHeader((Component)new Label(FolderItemPane.globalize("cms.ui.new_folder")));
        Form folderCreate = new Form("fcreat");
        this.m_folderCreator = new FolderCreator("fcreat", this.m_folderSel);
        this.m_folderCreator.addSubmissionListener(this);
        this.m_folderCreator.addProcessListener(this);
        folderCreate.add((Component)this.m_folderCreator);
        this.m_newFolderSeg.add((Component)folderCreate);
        this.m_newFolderSeg.add((Component)new Label("<br/>", false));
        this.m_editFolderSeg.addHeader((Component)new Label(FolderItemPane.globalize("cms.ui.edit_folder")));
        this.m_folderEditor = new FolderEditor("fedit", this.m_folderSel);
        this.m_folderEditor.addSubmissionListener(this);
        this.m_folderEditor.addProcessListener(this);
        Form folderEditorForm = new Form("fedit_form");
        folderEditorForm.add((Component)this.m_folderEditor);
        this.m_editFolderSeg.add((Component)folderEditorForm);
        this.m_editFolderSeg.add((Component)new Label("<br/>", false));
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_chooseLabel, false);
        p.setVisibleDefault((Component)this.m_newItemSeg, false);
        p.setVisibleDefault((Component)this.m_newFolderSeg, false);
        p.setVisibleDefault((Component)this.m_editFolderSeg, false);
        p.addComponentStateParam((Component)this, this.m_typeSel.getStateParameter());
        p.addComponentStateParam((Component)this, this.m_folderSel.getStateParameter());
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!event.getPageState().isVisibleOnPage((Component)FolderItemPane.this)) {
                    return;
                }
                FolderItemPane.this.showHideSegments(event.getPageState());
            }
        });
    }

    private void showHideSegments(PageState state) {
        SecurityManager sm = Utilities.getSecurityManager(state);
        Folder folder = (Folder)this.m_folderSel.getSelectedObject(state);
        Assert.exists((Object)folder);
        boolean newItem = sm.canAccess(state.getRequest(), "new_item", (ContentItem)folder);
        if (!newItem) {
            this.browseMode(state);
        }
        this.m_createFolderAction.setVisible(state, newItem);
        this.m_newItem.setVisible(state, newItem);
        boolean editItem = sm.canAccess(state.getRequest(), "edit_item", (ContentItem)folder);
        this.m_editFolderAction.setVisible(state, editItem);
        User user = KernelHelper.getCurrentUser((HttpServletRequest)state.getRequest());
        PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)folder, (Party)user);
        if (PermissionService.checkPermission((PermissionDescriptor)perm)) {
            this.m_permissionsSeg.setVisible(state, true);
        } else {
            this.m_permissionsSeg.setVisible(state, false);
        }
    }

    private void browseMode(PageState s) {
        this.m_browseSeg.setVisible(s, true);
        this.m_permissionsSeg.setVisible(s, true);
        this.m_chooseLabel.setVisible(s, false);
        this.m_contentLabel.setVisible(s, true);
        this.m_itemPath.setVisible(s, true);
        this.m_newItemSeg.setVisible(s, false);
        this.m_newFolderSeg.setVisible(s, false);
        this.m_editFolderSeg.setVisible(s, false);
        this.m_typeSel.clearSelection(s);
    }

    private void newItemMode(PageState s) {
        this.m_permissionsSeg.setVisible(s, false);
        this.m_newItemSeg.setVisible(s, true);
    }

    private void newFolderMode(PageState s) {
        this.m_permissionsSeg.setVisible(s, false);
        this.m_newFolderSeg.setVisible(s, true);
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        if (e.getSource() == this.m_folderCreator && this.m_folderCreator.isCancelled(s)) {
            this.browseMode(s);
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.cancelled").localize());
        }
        if (e.getSource() == this.m_folderEditor && this.m_folderEditor.isCancelled(s)) {
            this.browseMode(s);
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.cancelled").localize());
        }
        if (e.getSource() == this.m_folderManip.getTargetSelector() && !this.m_folderManip.getTargetSelector().isVisible(s)) {
            this.browseMode(s);
        }
    }

    public void process(FormSectionEvent e) {
        PageState s = e.getPageState();
        Object source = e.getSource();
        if (source == this.m_newItem) {
            BigDecimal typeID = this.m_newItem.getTypeID(s);
            this.m_typeSel.setSelectedKey(s, (Object)typeID);
            this.newItemMode(s);
        } else if (source == this.m_folderCreator || source == this.m_folderEditor) {
            this.browseMode(s);
        } else if (source == this.m_folderManip.getItemView()) {
            this.m_permissionsSeg.setVisible(s, false);
            this.m_chooseLabel.setVisible(s, true);
            this.m_contentLabel.setVisible(s, false);
            this.m_itemPath.setVisible(s, false);
        } else if (source == this.m_folderManip.getTargetSelector()) {
            this.browseMode(s);
        }
    }

    public void stateChanged(ChangeEvent e) {
        PageState s = e.getPageState();
        if (e.getSource() == this.m_typeSel && !this.m_typeSel.isSelected(s)) {
            this.browseMode(s);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        Object source = e.getSource();
        if (source == this.m_createFolderAction) {
            this.newFolderMode(s);
        } else if (source == this.m_editFolderAction) {
            this.m_permissionsSeg.setVisible(s, false);
            this.m_editFolderSeg.setVisible(s, true);
        } else if (source == this.m_togglePrivateAction) {
            this.togglePermissions(s);
        }
    }

    private void togglePermissions(PageState state) {
        Folder currentFolder = (Folder)this.m_folderSel.getSelectedObject(state);
        if (!Utilities.getSecurityManager(state).canAccess(state.getRequest(), "staff_admin")) {
            throw new AccessDeniedException();
        }
        DataObject context = PermissionService.getContext((ACSObject)currentFolder);
        if (context != null) {
            PermissionService.clonePermissions((ACSObject)currentFolder);
            Folder liveFolder = (Folder)currentFolder.getLiveVersion();
            if (liveFolder != null) {
                PermissionService.clonePermissions((ACSObject)liveFolder);
            }
        } else {
            ACSObject parent = currentFolder.getParent();
            if (parent != null) {
                PermissionService.setContext((ACSObject)currentFolder, (ACSObject)parent);
            } else {
                ContentSection section = currentFolder.getContentSection();
                if (section != null) {
                    PermissionService.setContext((ACSObject)currentFolder, (ACSObject)section);
                } else {
                    throw new IllegalStateException("Cannot set the context for a folder with no parent and no Content Section");
                }
            }
            Folder liveVersion = (Folder)currentFolder.getLiveVersion();
            if (liveVersion != null) {
                ACSObject liveParent = liveVersion.getParent();
                if (liveParent != null) {
                    PermissionService.setContext((ACSObject)liveVersion, (ACSObject)liveParent);
                } else {
                    ContentSection liveSection = liveVersion.getContentSection();
                    if (liveSection != null) {
                        PermissionService.setContext((ACSObject)liveVersion, (ACSObject)liveSection);
                    } else {
                        throw new IllegalStateException("Cannot set the context for a folder with no parent and no Content Section");
                    }
                }
            }
            ObjectPermissionCollection perms = PermissionService.getGrantedPermissions((OID)currentFolder.getOID());
            while (perms.next()) {
                if (perms.isInherited() || perms.getPrivilege().equals((Object)PrivilegeDescriptor.ADMIN)) continue;
                PermissionDescriptor desc = new PermissionDescriptor(perms.getPrivilege(), currentFolder.getOID(), perms.getGranteeOID());
                PermissionService.revokePermission((PermissionDescriptor)desc);
            }
            if (liveVersion != null) {
                ObjectPermissionCollection livePerms = PermissionService.getGrantedPermissions((OID)liveVersion.getOID());
                while (livePerms.next()) {
                    if (livePerms.isInherited()) continue;
                    PermissionDescriptor desc2 = new PermissionDescriptor(livePerms.getPrivilege(), liveVersion.getOID(), livePerms.getGranteeOID());
                    PermissionService.revokePermission((PermissionDescriptor)desc2);
                }
            }
        }
        this.m_permPane.reset(state);
    }

    public void reset(PageState s) {
        this.browseMode(s);
        this.m_folderSel.clearSelection(s);
        this.m_folderManip.reset(s);
    }

    public final FolderManipulator getManipulator() {
        return this.m_folderManip;
    }

    public final CMSPermissionsPane getPermissionsPane() {
        return this.m_permPane;
    }

    public void setPermissionLinkVis(PageState state) {
        if (!Utilities.getSecurityManager(state).canAccess(state.getRequest(), "staff_admin")) {
            this.m_togglePrivateAction.setVisible(state, false);
        }
    }

    private static GlobalizedMessage globalize(String key) {
        return ContentSectionPage.globalize(key);
    }

    private static class SectionNewItemForm
    extends NewItemForm {
        public SectionNewItemForm(String name) {
            super(name);
        }

        @Override
        public ContentSection getContentSection(PageState s) {
            return CMS.getContext().getContentSection();
        }
    }
}

