/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.tree.TreeCellRenderer;
import com.arsdigita.cms.CMSConfig;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.folder.FolderBrowser;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.ui.folder.FolderTree;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class FolderManipulator
extends SimpleContainer
implements FormProcessListener,
FormValidationListener,
FormSubmissionListener,
Resettable {
    private static Logger s_log = Logger.getLogger(FolderManipulator.class);
    public static final String RESOURCE_BUNDLE = "com.arsdigita.cms.ui.folder.CMSFolderResources";
    private static final String MOVE = "Move";
    private static final String COPY = "Copy";
    private static final BigDecimal[] EMPTY_ARRAY = new BigDecimal[0];
    private ArrayParameter m_sources;
    private StringParameter m_action;
    private FolderSelectionModel m_srcFolderSel;
    private ItemView m_itemView;
    private TargetSelector m_targetSelector;
    private FilterForm m_filterForm;
    private StringParameter m_aToZfilter = new StringParameter("aToZfilter");
    private StringParameter m_filter = new StringParameter("filter");

    public FolderManipulator(FolderSelectionModel folderSel) {
        this.m_sources = new ArrayParameter((ParameterModel)new BigDecimalParameter("srcs"));
        this.m_action = new StringParameter("act");
        this.m_srcFolderSel = folderSel;
        this.m_itemView = new ItemView();
        this.m_itemView.addProcessListener(this);
        this.m_itemView.addValidationListener(this);
        this.add((Component)this.m_itemView);
        this.m_targetSelector = new TargetSelector();
        this.add((Component)this.m_targetSelector);
        this.m_targetSelector.addProcessListener(this);
        this.m_targetSelector.addValidationListener(this);
        this.m_targetSelector.addSubmissionListener(this);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_targetSelector, false);
        p.setVisibleDefault((Component)this.m_filterForm, true);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_sources);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_action);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_aToZfilter);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_filter);
    }

    public final BigDecimal[] getSources(PageState s) {
        BigDecimal[] result = (BigDecimal[])s.getValue((ParameterModel)this.m_sources);
        return result == null ? EMPTY_ARRAY : result;
    }

    public final FolderSelectionModel getSrcFolderSel() {
        return this.m_srcFolderSel;
    }

    public final Folder getTarget(PageState s) {
        return this.m_targetSelector.getTarget(s);
    }

    protected final boolean isMove(PageState s) {
        return MOVE.equals(this.getAction(s));
    }

    protected final boolean isCopy(PageState s) {
        return COPY.equals(this.getAction(s));
    }

    private String getAction(PageState s) {
        return (String)s.getValue((ParameterModel)this.m_action);
    }

    protected void moveItems(Folder target, BigDecimal[] items) {
        s_log.debug((Object)("moving to folder: " + target + " items: " + items));
        for (int i = 0; i < items.length; ++i) {
            try {
                ContentItem item = new ContentItem(items[i]);
                item.setParent((ACSObject)target);
                item.save();
                continue;
            }
            catch (DataObjectNotFoundException e) {
                s_log.warn((Object)"object not found in content move", (Throwable)e);
                throw new IllegalStateException((String)FolderManipulator.globalize("cms.ui.folder.no_such_item").localize());
            }
        }
    }

    protected void copyItems(Folder target, BigDecimal[] items) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying items " + Arrays.asList(items) + " to " + target));
        }
        for (int i = 0; i < items.length; ++i) {
            ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentItem", (Object)items[i]));
            Assert.exists((Object)item, ContentItem.class);
            ACSObject parent = item.getParent();
            if (parent instanceof ContentBundle) {
                item = (ContentBundle)parent;
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Copying item " + item));
            }
            ContentItem newItem = item.copy(target, true);
            Assert.isEqual((Object)target, (Object)newItem.getParent());
        }
    }

    public final Form getItemView() {
        return this.m_itemView;
    }

    public final Form getTargetSelector() {
        return this.m_targetSelector;
    }

    public final FolderBrowser getBrowser() {
        return this.m_itemView.getBrowser();
    }

    public void process(FormSectionEvent e) {
        PageState s = e.getPageState();
        if (e.getSource() == this.m_itemView) {
            this.m_itemView.setVisible(s, false);
            this.m_targetSelector.setVisible(s, true);
            this.m_targetSelector.expose(s);
        } else if (e.getSource() == this.m_targetSelector) {
            this.m_itemView.setVisible(s, true);
            this.m_targetSelector.setVisible(s, false);
            Folder f = this.m_targetSelector.getTarget(s);
            BigDecimal[] items = this.getSources(s);
            if (this.isCopy(s)) {
                this.copyItems(f, items);
            } else if (this.isMove(s)) {
                this.moveItems(f, items);
            }
            this.reset(s);
        }
    }

    public void validate(FormSectionEvent e) {
        PageState s = e.getPageState();
        FormData d = e.getFormData();
        BigDecimal[] sources = this.getSources(s);
        boolean hasSources = sources.length > 0;
        SecurityManager sm = Utilities.getSecurityManager(s);
        if (e.getSource() == this.m_itemView) {
            if (!hasSources) {
                d.addError(FolderManipulator.globalize("cms.ui.folder.must_select_item"));
            }
        } else if (e.getSource() == this.m_targetSelector) {
            User user;
            if (!hasSources) {
                throw new IllegalStateException((String)GlobalizationUtil.globalize("cms.ui.folder.no_source_items_specified").localize());
            }
            Folder target = this.m_targetSelector.getTarget(s);
            if (target == null) {
                d.addError(FolderManipulator.globalize("cms.ui.folder.need_select_target_folder"));
            }
            if (target.equals(this.m_srcFolderSel.getSelectedObject(s))) {
                d.addError(FolderManipulator.globalize("cms.ui.folder.not_within_same_folder"));
            }
            if (!sm.canAccess(user = Web.getContext().getUser(), "new_item", (ContentItem)target)) {
                d.addError(FolderManipulator.globalize("cms.ui.folder.no_permission_for_item"));
            }
            for (int i = 0; i < sources.length; ++i) {
                try {
                    ContentItem item = new ContentItem(sources[i]);
                    String name = item.getName();
                    Folder.ItemCollection items = target.getItems();
                    items.addNameFilter(name);
                    if (items.next()) {
                        d.addError((String)FolderManipulator.globalize("cms.ui.folder.item_already_exists").localize() + name);
                    }
                    items.close();
                    if (item.isLive() && this.isMove(s)) {
                        d.addError(name + (String)FolderManipulator.globalize("cms.ui.folder.item_is_live").localize());
                    }
                    if (sm.canAccess(user, "delete_item", item) || !this.isMove(s)) continue;
                    d.addError((String)FolderManipulator.globalize("cms.ui.folder.no_permission_for_item").localize() + name + ".");
                    continue;
                }
                catch (DataObjectNotFoundException exc) {
                    s_log.warn((Object)"object not found in validation", (Throwable)exc);
                    throw new IllegalStateException((String)FolderManipulator.globalize("cms.ui.folder.no_such_item").localize());
                }
            }
        }
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        if (this.m_targetSelector.isCancelled(s)) {
            this.reset(s);
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.folder.cancelled").localize());
        }
    }

    public void reset(PageState s) {
        this.m_itemView.setVisible(s, true);
        this.m_itemView.reset(s);
        this.m_targetSelector.setVisible(s, false);
        this.m_targetSelector.reset(s);
        s.setValue((ParameterModel)this.m_action, null);
        s.setValue((ParameterModel)this.m_sources, null);
        s.setValue((ParameterModel)this.m_aToZfilter, null);
        s.setValue((ParameterModel)this.m_filter, null);
    }

    public static GlobalizedMessage globalize(String key) {
        return new GlobalizedMessage(key, RESOURCE_BUNDLE);
    }

    private class FolderTreeCellRenderer
    implements TreeCellRenderer {
        private RequestLocal m_invalidFolders = new RequestLocal();

        private FolderTreeCellRenderer() {
        }

        public Component getComponent(Tree tree, PageState state, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, Object key) {
            ArrayList<String> invalidFolders = (ArrayList<String>)this.m_invalidFolders.get(state);
            if (invalidFolders == null) {
                invalidFolders = new ArrayList<String>();
                DataCollection collection = SessionManager.getSession().retrieve("com.arsdigita.cms.ContentItem");
                CompoundFilter filter = collection.getFilterFactory().or();
                BigDecimal[] sources = FolderManipulator.this.getSources(state);
                for (int i = 0; i < sources.length; ++i) {
                    invalidFolders.add(sources[i].toString());
                    CompoundFilter temp = filter.addFilter("id = :id" + i);
                    temp.set("id" + i, (Object)sources[i]);
                }
                collection.addFilter((Filter)filter);
                DataCollection folders = SessionManager.getSession().retrieve("com.arsdigita.cms.Folder");
                folders.addEqualsFilter("isDeleted", (Object)Boolean.FALSE);
                filter = collection.getFilterFactory().or();
                int count = 0;
                while (collection.next()) {
                    filter.addFilter("ancestors like :ancestors" + count + " || '%'");
                    filter.set("ancestors" + count, collection.get("ancestors"));
                    ++count;
                }
                folders.addFilter((Filter)filter);
                while (folders.next()) {
                    invalidFolders.add(folders.get("id").toString());
                }
                invalidFolders.add(FolderManipulator.this.m_srcFolderSel.getSelectedKey(state).toString());
                this.m_invalidFolders.set(state, invalidFolders);
            }
            Label l = new Label(value.toString());
            if (invalidFolders.contains(key.toString())) {
                return l;
            }
            if (isSelected) {
                l.setFontWeight("b");
                return l;
            }
            return new ControlLink((Component)l);
        }
    }

    protected static interface FilterFormModelBuilder {
        public long getFolderSize(PageState var1);
    }

    protected class FilterForm
    extends Form
    implements FormProcessListener,
    FormInitListener,
    FormSubmissionListener {
        private SimpleContainer panel;
        private boolean visible;
        private FilterFormModelBuilder modelBuilder;
        private TextField filterField;

        public FilterForm(FilterFormModelBuilder modelBuilder) {
            super("folderFilterForm");
            s_log.debug((Object)"Creating filter form...");
            this.modelBuilder = modelBuilder;
            this.addProcessListener(this);
            this.addInitListener(this);
            this.addSubmissionListener(this);
            this.panel = new BoxPanel(1);
            ActionLink allLink = new ActionLink((String)FolderManipulator.globalize("cms.ui.folder.filter.all").localize());
            allLink.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    event.getPageState().setValue((ParameterModel)FolderManipulator.this.m_aToZfilter, (Object)"");
                    event.getPageState().setValue((ParameterModel)FolderManipulator.this.m_filter, (Object)"");
                }
            });
            this.panel.add((Component)allLink);
            for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                final char lowerCaseChar = Character.toLowerCase(c);
                ActionLink link = new ActionLink(Character.toString(c));
                link.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        event.getPageState().setValue((ParameterModel)FolderManipulator.this.m_aToZfilter, (Object)Character.toString(lowerCaseChar));
                    }
                });
                this.panel.add((Component)link);
            }
            this.panel.add((Component)new Label((String)FolderManipulator.globalize("cms.ui.folder.filter").localize()));
            this.filterField = new TextField((ParameterModel)FolderManipulator.this.m_filter);
            this.panel.add((Component)this.filterField);
            this.panel.add((Component)new Submit("filterFolderSubmit", (String)FolderManipulator.globalize("cms.ui.folder.filter_do").localize()));
            this.add((Component)this.panel);
        }

        public TextField getFilterField() {
            return this.filterField;
        }

        public void process(FormSectionEvent fse) throws FormProcessException {
        }

        public void init(FormSectionEvent fse) throws FormProcessException {
        }

        public void submitted(FormSectionEvent fse) throws FormProcessException {
        }

        public boolean isVisible(PageState state) {
            return super.isVisible(state) && this.modelBuilder.getFolderSize(state) >= (long)CMSConfig.getInstance().getFolderAtoZShowLimit().intValue();
        }
    }

    private class ItemView
    extends Form
    implements Resettable {
        private FolderBrowser m_browser;
        private Paginator m_paginator;
        private OptionGroup m_checkboxGroup;
        private SingleSelect m_actionSel;
        private Submit m_submit;

        public ItemView() {
            super("itemView", (Container)new SimpleContainer());
            this.setMethod("get");
            ActionGroup group = new ActionGroup();
            this.add((Component)group);
            GridPanel panel = new GridPanel(1);
            group.setSubject((Component)panel);
            this.m_browser = new FolderBrowser(FolderManipulator.this.m_srcFolderSel);
            this.m_browser.setAtoZfilterParameter(FolderManipulator.this.m_aToZfilter);
            this.m_browser.setFilterParameter(FolderManipulator.this.m_filter);
            this.m_browser.setFilterForm(FolderManipulator.this.m_filterForm);
            this.m_paginator = new Paginator((PaginationModelBuilder)this.m_browser.getModelBuilder(), ContentSection.getConfig().getFolderBrowseListSize().intValue());
            panel.add((Component)this.m_paginator);
            panel.add((Component)this.m_browser);
            s_log.debug((Object)"Adding filter form...");
            FolderManipulator.this.m_filterForm = new FilterForm((FilterFormModelBuilder)this.m_browser.getModelBuilder());
            FolderManipulator.this.add((Component)FolderManipulator.this.m_filterForm);
            this.m_checkboxGroup = new CheckboxGroup(FolderManipulator.this.m_sources);
            panel.add((Component)this.m_checkboxGroup);
            panel.add((Component)new FormErrorDisplay((Form)this));
            SimpleContainer c = new SimpleContainer();
            group.addAction((Component)c);
            c.add((Component)new Label(FolderManipulator.globalize("cms.ui.folder.edit_selection")));
            this.m_actionSel = new SingleSelect((ParameterModel)FolderManipulator.this.m_action);
            this.m_actionSel.addOption(new Option(FolderManipulator.COPY, (Component)new Label(FolderManipulator.globalize("cms.ui.folder.copy"))));
            this.m_actionSel.addOption(new Option(FolderManipulator.MOVE, (Component)new Label(FolderManipulator.globalize("cms.ui.folder.move"))));
            c.add((Component)this.m_actionSel);
            this.m_submit = new Submit("Go", FolderManipulator.globalize("cms.ui.folder.go"));
            c.add((Component)this.m_submit);
            TableColumn tc = new TableColumn();
            tc.setCellRenderer((TableCellRenderer)new CheckboxRenderer());
            this.m_browser.getColumnModel().add(0, tc);
        }

        public final FolderBrowser getBrowser() {
            return this.m_browser;
        }

        public void reset(PageState s) {
            this.m_checkboxGroup.setValue(s, null);
            this.m_actionSel.setValue(s, null);
            this.m_paginator.reset(s);
            s.setValue((ParameterModel)FolderManipulator.this.m_aToZfilter, null);
            s.setValue((ParameterModel)FolderManipulator.this.m_filter, null);
            FolderManipulator.this.m_filterForm.getFilterField().setValue(s, null);
        }

        private class CheckboxRenderer
        implements TableCellRenderer {
            private CheckboxRenderer() {
            }

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                BigDecimal n = (BigDecimal)key;
                Option result = new Option(FolderManipulator.this.m_sources.marshalElement((Object)n.abs()), "");
                result.setGroup(ItemView.this.m_checkboxGroup);
                return result;
            }
        }
    }

    private class TargetSelector
    extends Form
    implements Resettable {
        private FolderSelectionModel m_targetSel;
        private FolderTree m_folderTree;
        private Submit m_cancel;

        public TargetSelector() {
            super("targetSel", (Container)new BoxPanel());
            this.setMethod("get");
            this.m_targetSel = new FolderSelectionModel("target");
            this.m_folderTree = new FolderTree(this.m_targetSel);
            this.m_folderTree.setCellRenderer(new FolderTreeCellRenderer());
            Label l = new Label(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    Label t = (Label)e.getTarget();
                    int n = FolderManipulator.this.getSources(s).length;
                    Folder f = (Folder)FolderManipulator.this.m_srcFolderSel.getSelectedObject(s);
                    String msg = n + "&nbsp;" + (String)FolderManipulator.globalize("cms.ui.folder.items").localize() + "&nbsp;" + (String)FolderManipulator.globalize("cms.ui.folder.from").localize() + "&nbsp;/" + f.getPathNoJsp() + "&nbsp;" + (String)FolderManipulator.globalize("cms.ui.folder.to").localize();
                    if (FolderManipulator.this.isMove(s)) {
                        t.setLabel((String)FolderManipulator.globalize("cms.ui.folder.move").localize() + "&nbsp;" + msg);
                    } else if (FolderManipulator.this.isCopy(s)) {
                        t.setLabel((String)FolderManipulator.globalize("cms.ui.folder.copy").localize() + "&nbsp;" + msg);
                    }
                }
            });
            l.setOutputEscaping(false);
            this.add((Component)l);
            this.add((Component)this.m_folderTree);
            this.add((Component)new FormErrorDisplay((Form)this));
            SaveCancelSection scs = new SaveCancelSection();
            this.m_cancel = scs.getCancelButton();
            this.add((Component)scs);
        }

        public void register(Page p) {
            super.register(p);
            p.addComponentStateParam((Component)this, this.m_targetSel.getStateParameter());
        }

        public void expose(PageState s) {
            Folder f = (Folder)FolderManipulator.this.m_srcFolderSel.getSelectedObject(s);
            this.m_targetSel.clearSelection(s);
            if (f != null) {
                ItemCollection i = f.getPathInfo(true);
                while (i.next()) {
                    this.m_folderTree.expand(i.getID().toString(), s);
                }
                i.close();
            }
        }

        public void reset(PageState s) {
            this.m_folderTree.clearSelection(s);
            s.setValue(this.m_folderTree.getSelectionModel().getStateParameter(), null);
        }

        public Folder getTarget(PageState s) {
            return (Folder)this.m_targetSel.getSelectedObject(s);
        }

        public boolean isCancelled(PageState s) {
            return this.m_cancel.isSelected(s);
        }
    }
}

