/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.NumberInRangeValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinitionCollection;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.FormSecurityListener;
import com.arsdigita.cms.ui.lifecycle.LifecycleDefinitionRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;

class AddPhaseForm
extends CMSForm {
    private static final String PHASE_ID = "id";
    private static final String LABEL = "label";
    private static final String DESCRIPTION = "description";
    private static final String DELAY_DAYS = "delay_days";
    private static final String DELAY_HOURS = "delay_hours";
    private static final String DELAY_MINUTES = "delay_minutes";
    private static final String DURATION_DAYS = "duration_days";
    private static final String DURATION_HOURS = "duration_hours";
    private static final String DURATION_MINUTES = "duration_minutes";
    private static final String SUBMIT = "submit";
    private static final String CANCEL = "cancel";
    private final LifecycleDefinitionRequestLocal m_cycle;
    private Hidden m_id;
    private TextField m_label;
    private TextArea m_description;
    private TextField m_delay_days;
    private TextField m_delay_hours;
    private TextField m_delay_minutes;
    private TextField m_duration_days;
    private TextField m_duration_hours;
    private TextField m_duration_minutes;
    private Submit m_submit;
    private Submit m_cancel;

    public AddPhaseForm(LifecycleDefinitionRequestLocal cycle) {
        super("LifecyclePhaseDefinition");
        this.m_cycle = cycle;
        this.m_id = new Hidden((ParameterModel)new BigDecimalParameter(PHASE_ID));
        this.add((Component)this.m_id);
        this.m_id.addValidationListener((ParameterListener)new NotNullValidationListener());
        Label heading = new Label(AddPhaseForm.gz("cms.ui.lifecycle.phase_add"));
        heading.setFontWeight("b");
        this.add((Component)heading, 64);
        this.add((Component)new FormErrorDisplay((Form)this), 64);
        this.add((Component)new Label(AddPhaseForm.gz("cms.ui.name")));
        this.m_label = new TextField((ParameterModel)new TrimmedStringParameter(LABEL));
        this.m_label.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.m_label.setSize(40);
        this.m_label.setMaxLength(1000);
        this.add((Component)this.m_label);
        this.add((Component)new Label(AddPhaseForm.gz("cms.ui.description")));
        this.m_description = new TextArea((ParameterModel)new TrimmedStringParameter(DESCRIPTION));
        this.m_description.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        this.m_description.setCols(40);
        this.m_description.setRows(5);
        this.m_description.setWrap(2);
        this.add((Component)this.m_description);
        this.add((Component)new Label(AddPhaseForm.gz("cms.ui.lifecycle.phase_start_delay")));
        this.m_delay_days = new TextField((ParameterModel)new IntegerParameter(DELAY_DAYS));
        this.m_delay_hours = new TextField((ParameterModel)new IntegerParameter(DELAY_HOURS));
        this.m_delay_minutes = new TextField((ParameterModel)new IntegerParameter(DELAY_MINUTES));
        this.m_delay_days.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 21900L));
        this.m_delay_hours.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 168L));
        this.m_delay_minutes.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 1440L));
        this.m_delay_days.setSize(7);
        this.m_delay_hours.setSize(7);
        this.m_delay_minutes.setSize(7);
        this.m_delay_days.setClassAttr("DaysField");
        this.m_delay_hours.setClassAttr("HoursField");
        this.m_delay_minutes.setClassAttr("MinutesField");
        SimpleContainer de = new SimpleContainer();
        de.add((Component)new Label(AddPhaseForm.gz("cms.ui.lifecycle.phase_days")));
        de.add((Component)this.m_delay_days);
        de.add((Component)new Label(AddPhaseForm.gz("cms.ui.lifecycle.phase_hours")));
        de.add((Component)this.m_delay_hours);
        de.add((Component)new Label(AddPhaseForm.gz("cms.ui.lifecycle.phase_mins")));
        de.add((Component)this.m_delay_minutes);
        this.add((Component)de);
        this.add((Component)new Label(AddPhaseForm.gz("cms.ui.lifecycle.phase_duration")));
        this.m_duration_days = new TextField((ParameterModel)new IntegerParameter(DURATION_DAYS));
        this.m_duration_hours = new TextField((ParameterModel)new IntegerParameter(DURATION_HOURS));
        this.m_duration_minutes = new TextField((ParameterModel)new IntegerParameter(DURATION_MINUTES));
        this.m_duration_days.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 21900L));
        this.m_duration_hours.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 168L));
        this.m_duration_minutes.addValidationListener((ParameterListener)new NumberInRangeValidationListener(0L, 1440L));
        this.m_duration_days.setSize(7);
        this.m_duration_hours.setSize(7);
        this.m_duration_minutes.setSize(7);
        this.m_duration_days.setClassAttr("DaysField");
        this.m_duration_hours.setClassAttr("HoursField");
        this.m_duration_minutes.setClassAttr("MinutesField");
        SimpleContainer du = new SimpleContainer();
        du.add((Component)new Label(AddPhaseForm.gz("cms.ui.lifecycle.phase_days")));
        du.add((Component)this.m_duration_days);
        du.add((Component)new Label(AddPhaseForm.gz("cms.ui.lifecycle.phase_hours")));
        du.add((Component)this.m_duration_hours);
        du.add((Component)new Label(AddPhaseForm.gz("cms.ui.lifecycle.phase_mins")));
        du.add((Component)this.m_duration_minutes);
        this.add((Component)du);
        SimpleContainer s = new SimpleContainer();
        this.m_submit = new Submit(SUBMIT);
        this.m_submit.setButtonLabel("Add Phase");
        s.add((Component)this.m_submit);
        this.m_cancel = new Submit(CANCEL);
        this.m_cancel.setButtonLabel("Cancel");
        s.add((Component)this.m_cancel);
        this.add((Component)s, 66);
        this.addInitListener(new FormInitListener(){

            public final void init(FormSectionEvent event) throws FormProcessException {
                AddPhaseForm.this.initializePhase(event.getPageState());
            }
        });
        this.addSubmissionListener(new FormSecurityListener("lifecycle_admin"));
        this.addValidationListener(new FormValidationListener(){

            public final void validate(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                AddPhaseForm.this.validateDuration(state);
                AddPhaseForm.this.validateUniqueName(state);
            }
        });
        this.addProcessListener(new FormProcessListener(){

            public final void process(FormSectionEvent event) throws FormProcessException {
                AddPhaseForm.this.addPhase(event.getPageState());
            }
        });
    }

    @Override
    public boolean isCancelled(PageState state) {
        return this.m_cancel.isSelected(state);
    }

    protected void initializePhase(PageState state) throws FormProcessException {
        if (this.m_id.getValue(state) == null) {
            try {
                this.m_id.setValue(state, (Object)Sequences.getNextValue());
            }
            catch (SQLException e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
        }
    }

    protected void addPhase(PageState state) throws FormProcessException {
        BigDecimal id = (BigDecimal)this.m_id.getValue(state);
        String label = (String)this.m_label.getValue(state);
        String description = (String)this.m_description.getValue(state);
        Integer delDays = (Integer)this.m_delay_days.getValue(state);
        Integer delHours = (Integer)this.m_delay_hours.getValue(state);
        Integer delMinutes = (Integer)this.m_delay_minutes.getValue(state);
        Integer durDays = (Integer)this.m_duration_days.getValue(state);
        Integer durHours = (Integer)this.m_duration_hours.getValue(state);
        Integer durMinutes = (Integer)this.m_duration_minutes.getValue(state);
        PhaseDefinition phaseDef = null;
        try {
            phaseDef = new PhaseDefinition(id);
        }
        catch (DataObjectNotFoundException e) {
            LifecycleDefinition cycleDef = this.m_cycle.getLifecycleDefinition(state);
            phaseDef = cycleDef.addPhaseDefinition();
        }
        phaseDef.setLabel(label);
        phaseDef.setDescription(description);
        phaseDef.setDefaultDelay(delDays, delHours, delMinutes);
        phaseDef.setDefaultDuration(durDays, durHours, durMinutes);
        phaseDef.save();
    }

    protected void validateUniqueName(PageState state) throws FormProcessException {
        String label = (String)this.m_label.getValue(state);
        LifecycleDefinition cycleDef = this.m_cycle.getLifecycleDefinition(state);
        PhaseDefinitionCollection phaseDefs = cycleDef.getPhaseDefinitions();
        while (phaseDefs.next()) {
            PhaseDefinition phaseDef = phaseDefs.getPhaseDefinition();
            if (!phaseDef.getLabel().equalsIgnoreCase(label)) continue;
            phaseDefs.close();
            throw new FormProcessException("A phase with that name already exists for this lifecycle: " + label);
        }
    }

    protected void validateDuration(PageState state) throws FormProcessException {
        int minutes;
        int hours;
        Integer durDays = (Integer)this.m_duration_days.getValue(state);
        Integer durHours = (Integer)this.m_duration_hours.getValue(state);
        Integer durMinutes = (Integer)this.m_duration_minutes.getValue(state);
        if (durDays == null && durHours == null && durMinutes == null) {
            return;
        }
        int days = durDays != null ? durDays : 0;
        if (days + (hours = durHours != null ? durHours : 0) + (minutes = durMinutes != null ? durMinutes : 0) == 0) {
            throw new FormProcessException("The phase duration must be greater than 0");
        }
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)AddPhaseForm.gz(key).localize();
    }
}

