/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.FormSecurityListener;
import com.arsdigita.cms.ui.lifecycle.PhaseRequestLocal;
import com.arsdigita.domain.DataObjectNotFoundException;
import java.math.BigDecimal;

class DeletePhaseForm
extends CMSForm
implements FormProcessListener,
FormInitListener {
    private final PhaseRequestLocal m_phase;
    private Hidden m_id;
    private Submit m_deleteWidget;
    private Submit m_cancelWidget;

    public DeletePhaseForm(PhaseRequestLocal phase) {
        super("PhaseDefinitionDelete");
        this.m_phase = phase;
        this.m_id = new Hidden((ParameterModel)new BigDecimalParameter("id"));
        this.add((Component)this.m_id);
        this.m_id.addValidationListener((ParameterListener)new NotNullValidationListener());
        BoxPanel buttons = new BoxPanel(1);
        this.m_deleteWidget = new Submit("delete");
        this.m_deleteWidget.setButtonLabel("Delete");
        this.m_deleteWidget.setClassAttr("deletePhase");
        buttons.add((Component)this.m_deleteWidget);
        this.m_cancelWidget = new Submit("cancel");
        this.m_cancelWidget.setButtonLabel("Cancel");
        this.m_cancelWidget.setClassAttr("canceldeletePhase");
        buttons.add((Component)this.m_cancelWidget);
        this.add((Component)buttons, 66);
        this.addInitListener(this);
        this.addSubmissionListener(new FormSecurityListener("lifecycle_admin"));
        this.addProcessListener(this);
    }

    @Override
    public boolean isCancelled(PageState s) {
        return this.m_cancelWidget.isSelected(s);
    }

    public final void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        BigDecimal key = (BigDecimal)data.get((Object)this.m_id.getName());
        try {
            PhaseDefinition phaseDefinition = new PhaseDefinition(key);
            phaseDefinition.delete();
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
    }

    public final void init(FormSectionEvent e) {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        BigDecimal id = this.m_phase.getPhase(state).getID();
        data.put((Object)this.m_id.getName(), (Object)id);
    }
}

