/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.CMSConfig;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.ui.lifecycle.ItemLifecycleItemPane;
import com.arsdigita.cms.ui.lifecycle.ItemLifecycleSelectForm;
import com.arsdigita.cms.ui.lifecycle.LifecycleRequestLocal;
import com.arsdigita.cms.ui.lifecycle.PublishLock;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;

public class ItemLifecycleAdminPane
extends BaseItemPane {
    private static final Logger s_log = Logger.getLogger(ItemLifecycleAdminPane.class);
    private final ContentItemRequestLocal m_item;
    private final LifecycleRequestLocal m_lifecycle;
    private final LayoutPanel m_introPane;
    private final LayoutPanel m_detailPane;
    private final LayoutPanel m_selectPane;
    private final LayoutPanel m_lockedPane;
    private final LayoutPanel m_errorPane;

    public ItemLifecycleAdminPane(final ContentItemRequestLocal item) {
        this.m_item = item;
        this.m_lifecycle = new ItemLifecycleRequestLocal();
        this.m_introPane = new LayoutPanel();
        this.add((Component)this.m_introPane);
        Label message = new Label(ItemLifecycleAdminPane.gz("cms.ui.item.lifecycle.intro"));
        this.m_introPane.setBody((Component)message);
        this.m_detailPane = new LayoutPanel();
        this.add((Component)this.m_detailPane);
        ItemLifecycleItemPane itemPane = new ItemLifecycleItemPane(this.m_item, this.m_lifecycle);
        this.m_detailPane.setBody((Component)itemPane);
        this.m_selectPane = new LayoutPanel();
        this.add((Component)this.m_selectPane);
        ItemLifecycleSelectForm selectForm = new ItemLifecycleSelectForm(this.m_item);
        this.m_selectPane.setBody((Component)selectForm);
        this.m_lockedPane = new LayoutPanel();
        this.add((Component)this.m_lockedPane);
        Label lockedMsg = new Label(ItemLifecycleAdminPane.gz("cms.ui.item.lifecycle.publish_locked"));
        this.m_lockedPane.setBody((Component)lockedMsg);
        ControlLink lockedUpdateLink = new ControlLink((Component)new Label(ItemLifecycleAdminPane.gz("cms.ui.item.lifecycle.publish_locked.update")));
        lockedUpdateLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                throw new RedirectSignal(URL.getDispatcherPath() + ContentItemPage.getItemURL(item.getContentItem(event.getPageState()), ContentItemPage.PUBLISHING_TAB), true);
            }
        });
        this.m_lockedPane.setBottom((Component)lockedUpdateLink);
        this.m_errorPane = new LayoutPanel();
        this.add((Component)this.m_errorPane);
        Label errorMsg = new Label(ItemLifecycleAdminPane.gz("cms.ui.lifecycle.publish.error"));
        this.m_errorPane.setBody((Component)errorMsg);
        this.connect((FormSection)selectForm, (Component)this.m_detailPane);
    }

    public final void register(Page page) {
        super.register(page);
        page.addActionListener((ActionListener)new VisibilityListener());
    }

    private boolean hasPermission(PageState state) {
        ContentItem item = this.m_item.getContentItem(state);
        return CMS.getContext().getSecurityManager().canAccess(state.getRequest(), "schedule_publication", item);
    }

    private class VisibilityListener
    implements ActionListener {
        private VisibilityListener() {
        }

        public final void actionPerformed(ActionEvent e) {
            s_log.debug((Object)"Determining which pane to show");
            PageState state = e.getPageState();
            if (CMSConfig.getInstance().getThreadedPublishing().booleanValue() && PublishLock.getInstance().isLocked(ItemLifecycleAdminPane.this.m_item.getContentItem(state))) {
                if (PublishLock.getInstance().hasError(ItemLifecycleAdminPane.this.m_item.getContentItem(state))) {
                    ItemLifecycleAdminPane.this.push(state, (Component)ItemLifecycleAdminPane.this.m_errorPane);
                } else {
                    ItemLifecycleAdminPane.this.push(state, (Component)ItemLifecycleAdminPane.this.m_lockedPane);
                    state.getResponse().addIntHeader("Refresh", 5);
                }
            } else if (state.isVisibleOnPage((Component)ItemLifecycleAdminPane.this)) {
                if (ItemLifecycleAdminPane.this.m_lifecycle.getLifecycle(state) == null) {
                    if (ItemLifecycleAdminPane.this.hasPermission(state)) {
                        ItemLifecycleAdminPane.this.push(state, (Component)ItemLifecycleAdminPane.this.m_selectPane);
                    } else {
                        ItemLifecycleAdminPane.this.push(state, (Component)ItemLifecycleAdminPane.this.m_introPane);
                    }
                } else {
                    ItemLifecycleAdminPane.this.push(state, (Component)ItemLifecycleAdminPane.this.m_detailPane);
                }
            }
        }
    }

    private class ItemLifecycleRequestLocal
    extends LifecycleRequestLocal {
        private ItemLifecycleRequestLocal() {
        }

        protected final Object initialValue(PageState state) {
            ContentItem item = ItemLifecycleAdminPane.this.m_item.getContentItem(state);
            Lifecycle lifecycle = item.getLifecycle();
            s_log.debug((Object)("Returning lifecycle " + (Object)((Object)lifecycle)));
            return lifecycle;
        }
    }
}

