/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.CMSConfig;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.Workspace;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.ui.lifecycle.ItemLifecycleSelectForm;
import com.arsdigita.cms.ui.lifecycle.ItemPhaseTableModelBuilder;
import com.arsdigita.cms.ui.lifecycle.LifecycleRequestLocal;
import com.arsdigita.cms.ui.lifecycle.PublishLock;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.PropertyList;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.TaskException;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.xml.Element;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class ItemLifecycleItemPane
extends BaseItemPane {
    private static final Logger s_log = Logger.getLogger(ItemLifecycleItemPane.class);
    private final ContentItemRequestLocal m_item;
    private final LifecycleRequestLocal m_lifecycle;
    private final SimpleContainer m_detailPane;

    public ItemLifecycleItemPane(ContentItemRequestLocal item, LifecycleRequestLocal cycle) {
        this.m_item = item;
        this.m_lifecycle = cycle;
        this.m_detailPane = new SimpleContainer();
        this.add((Component)this.m_detailPane);
        this.setDefault((Component)this.m_detailPane);
        this.m_detailPane.add((Component)new SummarySection());
        Label lastPublishedLabel = new Label();
        lastPublishedLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState state = event.getPageState();
                ContentItem item = ItemLifecycleItemPane.this.m_item.getContentItem(state).getLiveVersion();
                Label label = (Label)event.getTarget();
                String dateStr = item == null || item.getLastModifiedDate() == null ? "" : DateFormat.getDateTimeInstance(1, 3, GlobalizationHelper.getNegotiatedLocale()).format(item.getLastModifiedDate());
                String msg = String.format("%s %s", new GlobalizedMessage("cms.ui.lifecycle.details.last_published", "com.arsdigita.cms.CMSResources").localize(), dateStr);
                label.setLabel(msg);
            }
        });
        this.m_detailPane.add((Component)lastPublishedLabel);
        this.m_detailPane.add((Component)new PhaseSection());
    }

    private static void republish(ContentItem item, boolean reset) {
        item.republish(reset);
        Workflow workflow = Workflow.getObjectWorkflow((ACSObject)item);
        try {
            ItemLifecycleSelectForm.finish(workflow, item, Web.getContext().getUser());
        }
        catch (TaskException te) {
            throw new UncheckedWrapperException((Throwable)te);
        }
    }

    private class ActionForm
    extends Form
    implements FormProcessListener,
    FormInitListener {
        private static final String LIFECYCLE_ACTION = "itemLifecycleItemPaneActionSelect";
        private static final String REPUBLISH = "republish";
        private static final String UNPUBLISH = "unpublish";
        private static final String REPUBLISH_AND_RESET = "republishAndReset";
        private final Submit submit;
        private final Label notAuthorized;

        public ActionForm() {
            super("itemLifecycleItemPaneActionForm");
            BoxPanel actionPanel = new BoxPanel(1);
            SingleSelect actionSelect = new SingleSelect(LIFECYCLE_ACTION);
            actionSelect.addOption(new Option(REPUBLISH, (String)ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.republish").localize()));
            if (!ContentSection.getConfig().hideResetLifecycleLink()) {
                actionSelect.addOption(new Option(REPUBLISH_AND_RESET, (String)ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.republish_and_reset").localize()));
            }
            actionSelect.addOption(new Option(UNPUBLISH, (String)ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.unpublish").localize()));
            this.submit = new Submit(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.do"));
            this.notAuthorized = new Label(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.do.not_authorized"));
            actionPanel.add((Component)actionSelect);
            actionPanel.add((Component)this.submit);
            actionPanel.add((Component)this.notAuthorized);
            this.add((Component)actionPanel);
            this.addInitListener(this);
            this.addProcessListener(this);
        }

        public void init(FormSectionEvent fse) throws FormProcessException {
            PageState state = fse.getPageState();
            ContentItem item = ItemLifecycleItemPane.this.m_item.getContentItem(state);
            SecurityManager sm = Utilities.getSecurityManager(state);
            if (sm.canAccess(state.getRequest(), "publish", item)) {
                this.submit.setVisible(state, true);
                this.notAuthorized.setVisible(state, false);
            } else {
                this.submit.setVisible(state, false);
                this.notAuthorized.setVisible(state, true);
            }
        }

        public void process(FormSectionEvent fse) throws FormProcessException {
            PageState state = fse.getPageState();
            FormData data = fse.getFormData();
            String selected = (String)data.get((Object)LIFECYCLE_ACTION);
            final ContentItem item = ItemLifecycleItemPane.this.m_item.getContentItem(state);
            if (REPUBLISH.equals(selected)) {
                if (CMSConfig.getInstance().getThreadedPublishing().booleanValue()) {
                    RepublishRunner runner = new RepublishRunner(item);
                    Thread thread = new Thread(runner);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable ex) {
                            PublishLock.getInstance().setError(item);
                            s_log.error((Object)String.format("An error occurred while publishing the item '%s': ", item.getOID().toString()), ex);
                            if (CMSConfig.getInstance().getPublicationFailureSender() == null && CMSConfig.getInstance().getPublicationFailureReceiver() == null) {
                                return;
                            }
                            PartyCollection receiverParties = Party.retrieveAllParties();
                            Party receiver = null;
                            receiverParties.addEqualsFilter("primaryEmail", (Object)CMSConfig.getInstance().getPublicationFailureReceiver());
                            if (receiverParties.next()) {
                                receiver = receiverParties.getParty();
                            }
                            receiverParties.close();
                            PartyCollection senderParties = Party.retrieveAllParties();
                            Party sender = null;
                            senderParties.addEqualsFilter("primaryEmail", (Object)CMSConfig.getInstance().getPublicationFailureReceiver());
                            if (senderParties.next()) {
                                sender = senderParties.getParty();
                            }
                            senderParties.close();
                            if (sender != null && receiver != null) {
                                StringWriter traceWriter = new StringWriter();
                                PrintWriter printWriter = new PrintWriter(traceWriter);
                                ex.printStackTrace(printWriter);
                                Notification notification = new Notification(sender, receiver, String.format("Failed to publish item '%s'", item.getOID().toString()), String.format("Publishing item '%s' failed with error message: %s.\n\nStacktrace:\n%s", item.getOID().toString(), ex.getMessage(), ((Object)traceWriter).toString()));
                                notification.save();
                            }
                        }
                    });
                    thread.start();
                    throw new RedirectSignal(URL.getDispatcherPath() + ContentItemPage.getItemURL(item, ContentItemPage.PUBLISHING_TAB), true);
                }
                ItemLifecycleItemPane.republish(item, false);
                if (ContentSection.getConfig().getUseStreamlinedCreation()) {
                    throw new RedirectSignal(URL.there((HttpServletRequest)state.getRequest(), (String)Workspace.getURL()), true);
                }
            } else if (REPUBLISH_AND_RESET.equals(selected)) {
                if (CMSConfig.getInstance().getThreadedPublishing().booleanValue()) {
                    RepublishAndResetRunner runner = new RepublishAndResetRunner(item);
                    Thread thread = new Thread(runner);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable ex) {
                            PublishLock.getInstance().setError(item);
                            s_log.error((Object)String.format("An error occurred while publishing the item '%s': ", item.getOID().toString()), ex);
                            if (CMSConfig.getInstance().getPublicationFailureSender() == null && CMSConfig.getInstance().getPublicationFailureReceiver() == null) {
                                return;
                            }
                            PartyCollection receiverParties = Party.retrieveAllParties();
                            Party receiver = null;
                            receiverParties.addEqualsFilter("primaryEmail", (Object)CMSConfig.getInstance().getPublicationFailureReceiver());
                            if (receiverParties.next()) {
                                receiver = receiverParties.getParty();
                            }
                            receiverParties.close();
                            PartyCollection senderParties = Party.retrieveAllParties();
                            Party sender = null;
                            senderParties.addEqualsFilter("primaryEmail", (Object)CMSConfig.getInstance().getPublicationFailureReceiver());
                            if (senderParties.next()) {
                                sender = senderParties.getParty();
                            }
                            senderParties.close();
                            if (sender != null && receiver != null) {
                                StringWriter traceWriter = new StringWriter();
                                PrintWriter printWriter = new PrintWriter(traceWriter);
                                ex.printStackTrace(printWriter);
                                Notification notification = new Notification(sender, receiver, String.format("Failed to publish item '%s'", item.getOID().toString()), String.format("Publishing item '%s' failed with error message: %s.\n\nStacktrace:\n%s", item.getOID().toString(), ex.getMessage(), ((Object)traceWriter).toString()));
                                notification.save();
                            }
                        }
                    });
                    thread.start();
                    throw new RedirectSignal(URL.getDispatcherPath() + ContentItemPage.getItemURL(item, ContentItemPage.PUBLISHING_TAB), true);
                }
                ItemLifecycleItemPane.republish(item, true);
                if (ContentSection.getConfig().getUseStreamlinedCreation()) {
                    throw new RedirectSignal(URL.there((HttpServletRequest)state.getRequest(), (String)Workspace.getURL()), true);
                }
            } else if (UNPUBLISH.equals(selected)) {
                item.unpublish();
            } else {
                throw new IllegalArgumentException("Illegal selection");
            }
        }

        private class RepublishAndResetRunner
        implements Runnable {
            private final String itemOid;

            private RepublishAndResetRunner(ContentItem item) {
                this.itemOid = item.getOID().toString();
            }

            private void doRepublishAndReset() {
                ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)OID.valueOf((String)this.itemOid));
                ItemLifecycleItemPane.republish(item, true);
            }

            @Override
            public void run() {
                ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)OID.valueOf((String)this.itemOid));
                PublishLock.getInstance().lock(item);
                this.doRepublishAndReset();
                PublishLock.getInstance().unlock(item);
            }
        }

        private class RepublishRunner
        implements Runnable {
            private final String itemOid;

            private RepublishRunner(ContentItem item) {
                this.itemOid = item.getOID().toString();
            }

            private void doRepublish() {
                ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)OID.valueOf((String)this.itemOid));
                ItemLifecycleItemPane.republish(item, false);
            }

            @Override
            public void run() {
                ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)OID.valueOf((String)this.itemOid));
                PublishLock.getInstance().lock(item);
                this.doRepublish();
                PublishLock.getInstance().unlock(item);
            }
        }
    }

    private class PhaseTable
    extends Table {
        PhaseTable() {
            super((TableModelBuilder)new ItemPhaseTableModelBuilder(ItemLifecycleItemPane.this.m_lifecycle), (Object[])new String[]{ItemLifecycleItemPane.lz("cms.ui.name"), ItemLifecycleItemPane.lz("cms.ui.description"), ItemLifecycleItemPane.lz("cms.ui.item.lifecycle.start_date"), ItemLifecycleItemPane.lz("cms.ui.item.lifecycle.end_date")});
        }
    }

    private class PhaseSection
    extends Section {
        PhaseSection() {
            super(ItemLifecycleItemPane.gz("cms.ui.lifecycle.phases"));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new PhaseTable());
        }
    }

    private class RepublishAndResetLink
    extends PublishLink {
        RepublishAndResetLink() {
            super((Component)new Label(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.republish_and_reset")));
            this.addActionListener(new Listener());
        }

        private class Republisher
        implements Runnable {
            private final String itemOid;

            private Republisher(ContentItem item) {
                this.itemOid = item.getOID().toString();
            }

            @Override
            public void run() {
                ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)OID.valueOf((String)this.itemOid));
                PublishLock.getInstance().lock(item);
                ItemLifecycleItemPane.republish(item, true);
                PublishLock.getInstance().unlock(item);
            }
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                final ContentItem item = ItemLifecycleItemPane.this.m_item.getContentItem(state);
                if (CMSConfig.getInstance().getThreadedPublishing().booleanValue()) {
                    Republisher republisher = new Republisher(item);
                    Thread thread = new Thread(republisher);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable ex) {
                            PublishLock.getInstance().setError(item);
                            s_log.error((Object)String.format("An error occurred while publishing the item '%s': ", item.getOID().toString()), ex);
                            if (CMSConfig.getInstance().getPublicationFailureSender() == null && CMSConfig.getInstance().getPublicationFailureReceiver() == null) {
                                return;
                            }
                            PartyCollection receiverParties = Party.retrieveAllParties();
                            Party receiver = null;
                            receiverParties.addEqualsFilter("primaryEmail", (Object)CMSConfig.getInstance().getPublicationFailureReceiver());
                            if (receiverParties.next()) {
                                receiver = receiverParties.getParty();
                            }
                            receiverParties.close();
                            PartyCollection senderParties = Party.retrieveAllParties();
                            Party sender = null;
                            senderParties.addEqualsFilter("primaryEmail", (Object)CMSConfig.getInstance().getPublicationFailureReceiver());
                            if (senderParties.next()) {
                                sender = senderParties.getParty();
                            }
                            senderParties.close();
                            if (sender != null && receiver != null) {
                                StringWriter traceWriter = new StringWriter();
                                PrintWriter printWriter = new PrintWriter(traceWriter);
                                ex.printStackTrace(printWriter);
                                Notification notification = new Notification(sender, receiver, String.format("Failed to publish item '%s'", item.getOID().toString()), String.format("Publishing item '%s' failed with error message: %s.\n\nStacktrace:\n%s", item.getOID().toString(), ex.getMessage(), ((Object)traceWriter).toString()));
                                notification.save();
                            }
                        }
                    });
                    thread.start();
                    throw new RedirectSignal(URL.getDispatcherPath() + ContentItemPage.getItemURL(item, ContentItemPage.PUBLISHING_TAB), true);
                }
                ItemLifecycleItemPane.republish(item, true);
                if (ContentSection.getConfig().getUseStreamlinedCreation()) {
                    throw new RedirectSignal(URL.there((HttpServletRequest)state.getRequest(), (String)Workspace.getURL()), true);
                }
            }
        }
    }

    private class RepublishLink
    extends PublishLink {
        RepublishLink() {
            super((Component)new Label(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.republish")));
            this.addActionListener(new Listener());
        }

        private class Republisher
        implements Runnable {
            private final String itemOid;

            private Republisher(ContentItem item) {
                this.itemOid = item.getOID().toString();
            }

            @Override
            public void run() {
                ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)OID.valueOf((String)this.itemOid));
                PublishLock.getInstance().lock(item);
                ItemLifecycleItemPane.republish(item, false);
                PublishLock.getInstance().unlock(item);
            }
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                final ContentItem item = ItemLifecycleItemPane.this.m_item.getContentItem(state);
                if (CMSConfig.getInstance().getThreadedPublishing().booleanValue()) {
                    Republisher republisher = new Republisher(item);
                    Thread thread = new Thread(republisher);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable ex) {
                            PublishLock.getInstance().setError(item);
                            s_log.error((Object)String.format("An error occurred while publishing the item '%s': ", item.getOID().toString()), ex);
                            if (CMSConfig.getInstance().getPublicationFailureSender() == null && CMSConfig.getInstance().getPublicationFailureReceiver() == null) {
                                return;
                            }
                            PartyCollection receiverParties = Party.retrieveAllParties();
                            Party receiver = null;
                            receiverParties.addEqualsFilter("primaryEmail", (Object)CMSConfig.getInstance().getPublicationFailureReceiver());
                            if (receiverParties.next()) {
                                receiver = receiverParties.getParty();
                            }
                            receiverParties.close();
                            PartyCollection senderParties = Party.retrieveAllParties();
                            Party sender = null;
                            senderParties.addEqualsFilter("primaryEmail", (Object)CMSConfig.getInstance().getPublicationFailureReceiver());
                            if (senderParties.next()) {
                                sender = senderParties.getParty();
                            }
                            senderParties.close();
                            if (sender != null && receiver != null) {
                                StringWriter traceWriter = new StringWriter();
                                PrintWriter printWriter = new PrintWriter(traceWriter);
                                ex.printStackTrace(printWriter);
                                Notification notification = new Notification(sender, receiver, String.format("Failed to publish item '%s'", item.getOID().toString()), String.format("Publishing item '%s' failed with error message: %s.\n\nStacktrace:\n%s", item.getOID().toString(), ex.getMessage(), ((Object)traceWriter).toString()));
                                notification.save();
                            }
                        }
                    });
                    thread.start();
                    throw new RedirectSignal(URL.getDispatcherPath() + ContentItemPage.getItemURL(item, ContentItemPage.PUBLISHING_TAB), true);
                }
                ItemLifecycleItemPane.republish(item, false);
                if (ContentSection.getConfig().getUseStreamlinedCreation()) {
                    throw new RedirectSignal(URL.there((HttpServletRequest)state.getRequest(), (String)Workspace.getURL()), true);
                }
            }
        }
    }

    private class UnpublishLink
    extends PublishLink {
        UnpublishLink() {
            super((Component)new Label(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.unpublish")));
            this.addActionListener(new Listener());
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                ContentItem item = ItemLifecycleItemPane.this.m_item.getContentItem(state);
                item.unpublish();
                String target = URL.getDispatcherPath() + ContentItemPage.getItemURL(item, ContentItemPage.AUTHORING_TAB);
                throw new RedirectSignal(target, true);
            }
        }
    }

    private class PublishLink
    extends ActionLink {
        private RequestLocal m_canPublish;

        PublishLink(Component c) {
            super(c);
            this.m_canPublish = new RequestLocal();
        }

        public void generateXML(PageState ps, Element parent) {
            ContentItem item;
            Boolean canPublish = (Boolean)this.m_canPublish.get(ps);
            if (null == canPublish) {
                SecurityManager sm = Utilities.getSecurityManager(ps);
                ContentItem item2 = ItemLifecycleItemPane.this.m_item.getContentItem(ps);
                canPublish = sm.canAccess(ps.getRequest(), "publish", item2) ? Boolean.TRUE : Boolean.FALSE;
                this.m_canPublish.set(ps, (Object)canPublish);
            }
            if (canPublish.booleanValue()) {
                if (s_log.isDebugEnabled()) {
                    item = ItemLifecycleItemPane.this.m_item.getContentItem(ps);
                    s_log.debug((Object)("User can publish " + item.getOID()));
                }
                super.generateXML(ps, parent);
            } else if (s_log.isDebugEnabled()) {
                item = ItemLifecycleItemPane.this.m_item.getContentItem(ps);
                s_log.debug((Object)("User cannot publish " + item.getOID()));
            }
        }
    }

    private class SummarySection
    extends Section {
        public SummarySection() {
            this.setHeading((Component)new Label(ItemLifecycleItemPane.gz("cms.ui.lifecycle.details")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            if (CMS.getConfig().getUseOldStyleItemLifecycleItemPane().booleanValue()) {
                group.setSubject((Component)new Properties());
                group.addAction((Component)new UnpublishLink());
                group.addAction((Component)new RepublishLink());
                if (!ContentSection.getConfig().hideResetLifecycleLink()) {
                    group.addAction((Component)new RepublishAndResetLink());
                }
            } else {
                group.addAction((Component)new ActionForm());
            }
        }

        private class Properties
        extends PropertyList {
            private Properties() {
            }

            protected final List properties(PageState state) {
                List props = super.properties(state);
                Lifecycle cycle = ItemLifecycleItemPane.this.m_lifecycle.getLifecycle(state);
                DateFormat format = DateFormat.getDateTimeInstance(0, ContentSection.getConfig().getHideTimezone() ? 3 : 0);
                props.add(new PropertyList.Property(ItemLifecycleItemPane.gz("cms.ui.name"), cycle.getLabel()));
                props.add(new PropertyList.Property(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.start_date"), format.format(cycle.getStartDate())));
                Date endDate = cycle.getEndDate();
                if (endDate == null) {
                    props.add(new PropertyList.Property(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.end_date"), ItemLifecycleItemPane.lz("cms.ui.none")));
                } else {
                    props.add(new PropertyList.Property(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.end_date"), format.format(endDate)));
                }
                return props;
            }
        }
    }
}

