/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import java.util.Calendar;

public class PublishLock {
    public static final String LOCK_OBJECT_TYPE = "com.arsdigita.cms.PublishLock";
    public static final String ID = "id";
    public static final String LOCKED_OID = "lockedOid";
    public static final String TIMESTAMP = "timestamp";
    public static final String ACTION = "action";
    public static final String ERROR = "error";
    private static PublishLock instance = new PublishLock();

    private PublishLock() {
    }

    protected static synchronized PublishLock getInstance() {
        return instance;
    }

    protected synchronized void lock(ContentItem item) {
        this.lock(item, "publish");
    }

    protected synchronized void lock(ContentItem item, String action) {
        SessionManager.getSession().getTransactionContext().beginTxn();
        DataObject lock = SessionManager.getSession().create(LOCK_OBJECT_TYPE);
        lock.set(ID, (Object)item.getID());
        lock.set(LOCKED_OID, (Object)item.getOID().toString());
        lock.set(TIMESTAMP, (Object)Calendar.getInstance().getTime());
        lock.set(ACTION, (Object)action);
        lock.save();
        SessionManager.getSession().getTransactionContext().commitTxn();
    }

    protected synchronized void unlock(ContentItem item) {
        SessionManager.getSession().getTransactionContext().beginTxn();
        DataCollection collection = SessionManager.getSession().retrieve(LOCK_OBJECT_TYPE);
        collection.addFilter(String.format("%s = '%s'", LOCKED_OID, item.getOID().toString()));
        if (!collection.isEmpty()) {
            collection.next();
            DataObject lock = collection.getDataObject();
            if (!ERROR.equals(lock.get(ACTION))) {
                lock.delete();
            }
        }
        collection.close();
        SessionManager.getSession().getTransactionContext().commitTxn();
    }

    protected synchronized boolean isLocked(ContentItem item) {
        DataCollection collection = SessionManager.getSession().retrieve(LOCK_OBJECT_TYPE);
        collection.addFilter(String.format("%s = '%s'", LOCKED_OID, item.getOID().toString()));
        if (collection.isEmpty()) {
            collection.close();
            return false;
        }
        collection.close();
        return true;
    }

    protected synchronized void setError(ContentItem item) {
        SessionManager.getSession().getTransactionContext().beginTxn();
        DataCollection collection = SessionManager.getSession().retrieve(LOCK_OBJECT_TYPE);
        collection.addFilter(String.format("%s = '%s'", LOCKED_OID, item.getOID().toString()));
        if (!collection.isEmpty()) {
            collection.next();
            DataObject lock = collection.getDataObject();
            lock.set(ACTION, (Object)ERROR);
            lock.save();
        }
        collection.close();
        SessionManager.getSession().getTransactionContext().commitTxn();
    }

    protected synchronized boolean hasError(ContentItem item) {
        DataCollection collection = SessionManager.getSession().retrieve(LOCK_OBJECT_TYPE);
        collection.addFilter(String.format("%s = '%s'", LOCKED_OID, item.getOID().toString()));
        if (collection.isEmpty()) {
            collection.close();
            return false;
        }
        collection.next();
        DataObject lock = collection.getDataObject();
        if (ERROR.equals(lock.get(ACTION).toString())) {
            collection.close();
            return true;
        }
        collection.close();
        return false;
    }
}

