/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.permissions;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ui.permissions.CMSPermissionsConstants;
import com.arsdigita.cms.ui.permissions.CMSPermissionsPane;
import com.arsdigita.cms.ui.permissions.CMSUserObjectStruct;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TooManyListenersException;

class CMSPermissionsGrant
implements CMSPermissionsConstants {
    private static final String PARTIES_CBG = "parties_cbg";
    private static final String PRIVILEGES_CBG = "privs_cbg";
    private static final String USER_ID = "userID";
    private static final String SCREEN_NAME = "screenName";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private SegmentedPanel m_grantPanel;
    private CMSPermissionsPane m_parent;
    private CheckboxGroup m_parties;
    private CheckboxGroup m_privileges;
    private Form m_form;
    private Submit m_save;

    public CMSPermissionsGrant(CMSPermissionsPane parent) {
        this.m_parent = parent;
        this.makeForm();
        this.m_grantPanel = new SegmentedPanel();
        this.m_grantPanel.addSegment((Component)new Label(PAGE_GRANT_TITLE), (Component)this.m_form);
    }

    private void makeForm() {
        this.m_form = new Form("GrantPrivileges", (Container)new BoxPanel());
        this.m_form.setMethod("post");
        this.m_form.addSubmissionListener((FormSubmissionListener)new GrantFormSubmissionListener());
        this.m_form.add((Component)new Label(PAGE_GRANT_LEFT));
        this.m_parties = new CheckboxGroup(PARTIES_CBG);
        try {
            this.m_parties.addPrintListener((PrintListener)new UserSearchPrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("TooManyListeners: " + e.getMessage(), (Throwable)e);
        }
        this.m_form.add((Component)this.m_parties);
        this.m_form.add((Component)new Label(PAGE_GRANT_RIGHT));
        this.m_privileges = new CheckboxGroup(PRIVILEGES_CBG);
        try {
            this.m_privileges.addPrintListener((PrintListener)new PrivilegePrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("TooManyListeners: " + e.getMessage(), (Throwable)e);
        }
        this.m_form.add((Component)this.m_privileges);
        this.m_save = new Submit("save", SAVE_BUTTON);
        this.m_form.add((Component)this.m_save);
    }

    public SegmentedPanel getPanel() {
        return this.m_grantPanel;
    }

    private class PrivilegePrintListener
    implements PrintListener {
        private PrivilegePrintListener() {
        }

        public void prepare(PrintEvent e) {
            PageState state = e.getPageState();
            CheckboxGroup cbg = (CheckboxGroup)e.getTarget();
            Object[] pa = (Object[])state.getValue((ParameterModel)new ArrayParameter("privs_set"));
            for (int i = 0; i < pa.length; ++i) {
                cbg.addOption(new Option((String)pa[i], CMSPermissionsGrant.this.m_parent.getPrivilegeName((String)pa[i])));
            }
        }
    }

    private class UserSearchPrintListener
    implements PrintListener {
        private UserSearchPrintListener() {
        }

        public void prepare(PrintEvent e) {
            PageState state = e.getPageState();
            CheckboxGroup cbg = (CheckboxGroup)e.getTarget();
            String search = (String)state.getValue((ParameterModel)new StringParameter("query"));
            search = StringUtils.stripWhiteSpace((String)search);
            PartyCollection parties = Party.retrieveAllParties();
            parties.filter(search);
            parties.addOrder("lower(displayName) asc");
            while (parties.next()) {
                String userID = parties.getID().toString();
                String userName = parties.getDisplayName();
                cbg.addOption(new Option(userID, userName));
            }
            parties.close();
        }
    }

    private class GrantFormSubmissionListener
    implements FormSubmissionListener {
        private GrantFormSubmissionListener() {
        }

        public void submitted(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            FormData data = e.getFormData();
            String[] gids = (String[])data.get((Object)CMSPermissionsGrant.PARTIES_CBG);
            String[] privs = (String[])data.get((Object)CMSPermissionsGrant.PRIVILEGES_CBG);
            if (privs != null && gids != null) {
                BigDecimal oID = CMSPermissionsGrant.this.m_parent.getObject(state).getID();
                BigDecimal gID = null;
                CMSUserObjectStruct uos = null;
                PermissionDescriptor pmd = null;
                for (int j = 0; j < gids.length; ++j) {
                    gID = new BigDecimal(gids[j]);
                    uos = new CMSUserObjectStruct(gID, oID);
                    for (int k = 0; k < privs.length; ++k) {
                        ACSObject acsObj = uos.getObject();
                        pmd = new PermissionDescriptor(PrivilegeDescriptor.get((String)privs[k]), acsObj, uos.getParty());
                        PermissionService.grantPermission((PermissionDescriptor)pmd);
                    }
                }
            }
            CMSPermissionsGrant.this.m_parent.showAdmin(state);
        }
    }
}

