/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.permissions;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.permissions.CMSPermissionsConstants;
import com.arsdigita.cms.ui.permissions.CMSPermissionsGrant;
import com.arsdigita.cms.ui.permissions.CMSPermissionsHeader;
import com.arsdigita.cms.ui.permissions.CMSPermissionsTables;
import com.arsdigita.cms.ui.permissions.CMSUserObjectStruct;
import com.arsdigita.cms.ui.permissions.CMSUserSearchForm;
import com.arsdigita.cms.ui.permissions.ObjectAdminListing;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CMSPermissionsPane
extends SimpleContainer
implements Resettable,
ActionListener,
RequestListener,
CMSPermissionsConstants {
    private ParameterModel m_searchString = new StringParameter("query");
    private ParameterModel m_privArray = new ArrayParameter("privs_set");
    private PrivilegeDescriptor[] m_privileges;
    private Map m_privNameMap;
    private CMSPermissionsTables m_allPermissions;
    private CMSPermissionsHeader m_PermissionsHeader;
    private SimpleContainer m_DirectPermissions;
    private Form m_UserSearchForm;
    private SimpleContainer m_InheritedPermissions;
    private SimpleComponent m_ContextPanel;
    private SimpleContainer m_PermissionsGrantPanel;
    private SimpleContainer m_NoResultsPanel;
    private ObjectAdminListing m_adminListing;
    private ACSObjectSelectionModel m_selModel;
    private RequestLocal m_UserObjectInfo;

    public CMSPermissionsPane(ACSObjectSelectionModel model) {
        this(DEFAULT_PRIVILEGES, new HashMap(), model);
        this.m_privNameMap.put("read", "Read");
        this.m_privNameMap.put("write", "Write");
        this.m_privNameMap.put("create", "Create");
        this.m_privNameMap.put("delete", "Delete");
        this.m_privNameMap.put("admin", "Admin");
    }

    public CMSPermissionsPane(PrivilegeDescriptor[] privs, Map privNameMap, final ACSObjectSelectionModel model) {
        this.m_UserObjectInfo = new RequestLocal(){

            protected Object initialValue(PageState s) {
                return new CMSUserObjectStruct(s, model);
            }
        };
        this.m_privileges = privs;
        this.m_selModel = model;
        this.m_privNameMap = privNameMap;
    }

    public void register(Page p) {
        super.register(p);
        this.add((Component)this.getContextPanel());
        this.add((Component)this.getDirectPermissionsPanel());
        this.add((Component)this.getUserSearchForm());
        this.add((Component)this.getInheritedPermissionsPanel());
        this.add((Component)this.getPermissionGrantPanel());
        this.add((Component)this.getNoSearchResultPanel());
        this.add((Component)this.getAdminListingPanel());
        p.setVisibleDefault((Component)this.getDirectPermissionsPanel(), true);
        p.setVisibleDefault((Component)this.getUserSearchForm(), true);
        p.setVisibleDefault((Component)this.getInheritedPermissionsPanel(), true);
        p.setVisibleDefault((Component)this.getContextPanel(), true);
        p.setVisibleDefault((Component)this.getPermissionGrantPanel(), false);
        p.setVisibleDefault((Component)this.getNoSearchResultPanel(), false);
        p.setVisibleDefault((Component)this.getAdminListingPanel(), false);
        p.addGlobalStateParam(this.m_searchString);
        p.addGlobalStateParam(this.m_privArray);
    }

    public void reset(PageState ps) {
        this.showAdmin(ps);
    }

    public Party getRequestingUser(PageState s) {
        return ((CMSUserObjectStruct)this.m_UserObjectInfo.get(s)).getParty();
    }

    public ACSObject getObject(PageState s) {
        return ((CMSUserObjectStruct)this.m_UserObjectInfo.get(s)).getObject();
    }

    public Label getTitle() {
        return ((CMSPermissionsHeader)this.getPermissionsHeader()).getTitle();
    }

    public String[] getPrivileges() {
        String[] p = new String[this.m_privileges.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = this.m_privileges[i].getName();
        }
        return p;
    }

    private CMSPermissionsTables getPermissionsTables() {
        if (this.m_allPermissions == null) {
            this.m_allPermissions = new CMSPermissionsTables(this.m_privileges, this);
        }
        return this.m_allPermissions;
    }

    public SimpleContainer getDirectPermissionsPanel() {
        this.m_DirectPermissions = this.getPermissionsTables().getPermissions(0);
        return this.m_DirectPermissions;
    }

    public SimpleContainer getInheritedPermissionsPanel() {
        this.m_InheritedPermissions = this.getPermissionsTables().getPermissions(1);
        return this.m_InheritedPermissions;
    }

    public SimpleContainer getAdminListingPanel() {
        if (this.m_adminListing == null) {
            this.m_adminListing = new ObjectAdminListing(this.m_selModel);
        }
        return this.m_adminListing;
    }

    public SegmentedPanel getUniversalPermissionsPanel() {
        throw new UnsupportedOperationException();
    }

    public Form getUserSearchForm() {
        if (this.m_UserSearchForm == null) {
            this.m_UserSearchForm = new CMSUserSearchForm(this);
        }
        return this.m_UserSearchForm;
    }

    public SimpleContainer getPermissionGrantPanel() {
        if (this.m_PermissionsGrantPanel == null) {
            CMSPermissionsGrant permGrant = new CMSPermissionsGrant(this);
            this.m_PermissionsGrantPanel = permGrant.getPanel();
        }
        return this.m_PermissionsGrantPanel;
    }

    public SimpleContainer getPermissionsHeader() {
        if (this.m_PermissionsHeader == null) {
            this.m_PermissionsHeader = new CMSPermissionsHeader(this);
        }
        return this.m_PermissionsHeader;
    }

    public SimpleContainer getNoSearchResultPanel() {
        if (this.m_NoResultsPanel == null) {
            Label errorMsg = new Label(NO_RESULTS.localize() + "");
            errorMsg.setClassAttr("errorBullet");
            BoxPanel bp = new BoxPanel();
            bp.add((Component)errorMsg);
            bp.add((Component)new CMSUserSearchForm(this));
            this.m_NoResultsPanel = new SegmentedPanel().addSegment((Component)new Label(" "), (Component)bp);
        }
        return this.m_NoResultsPanel;
    }

    public SimpleComponent getContextPanel() {
        if (this.m_ContextPanel == null) {
            this.m_ContextPanel = this.getPermissionsTables().makeContextPanel();
        }
        return this.m_ContextPanel;
    }

    ParameterModel getSearchString() {
        return this.m_searchString;
    }

    ParameterModel getPrivilegeParam() {
        return this.m_privArray;
    }

    ACSObjectSelectionModel getSelectionModel() {
        return this.m_selModel;
    }

    public void showNoResults(PageState s) {
        this.getDirectPermissionsPanel().setVisible(s, false);
        this.getInheritedPermissionsPanel().setVisible(s, false);
        this.getContextPanel().setVisible(s, false);
        this.getUserSearchForm().setVisible(s, false);
        this.getPermissionGrantPanel().setVisible(s, false);
        this.getNoSearchResultPanel().setVisible(s, true);
    }

    public void showGrant(PageState s) {
        this.getDirectPermissionsPanel().setVisible(s, false);
        this.getInheritedPermissionsPanel().setVisible(s, false);
        this.getContextPanel().setVisible(s, false);
        this.getUserSearchForm().setVisible(s, false);
        this.getNoSearchResultPanel().setVisible(s, false);
        this.getPermissionGrantPanel().setVisible(s, true);
    }

    public void showAdmin(PageState s) {
        ACSObject object = this.getObject(s);
        if (object != null) {
            boolean canAccess = Utilities.getSecurityManager(s).canAccess(s.getRequest(), "staff_admin");
            if (!canAccess) {
                this.getAdminListingPanel().setVisible(s, false);
            } else {
                this.getAdminListingPanel().setVisible(s, true);
            }
            if (!canAccess) {
                User user = KernelHelper.getCurrentUser();
                PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, object, (Party)user);
                canAccess = PermissionService.checkPermission((PermissionDescriptor)perm);
            }
            if (canAccess) {
                DataObject context = PermissionService.getContext((ACSObject)object);
                if (context == null) {
                    this.showCustom(s, true);
                } else {
                    this.showCustom(s, false);
                }
                this.getContextPanel().setVisible(s, true);
            } else {
                this.getDirectPermissionsPanel().setVisible(s, false);
                this.getInheritedPermissionsPanel().setVisible(s, false);
                this.getUserSearchForm().setVisible(s, false);
                this.getContextPanel().setVisible(s, false);
            }
        } else {
            throw new IllegalStateException((String)GlobalizationUtil.globalize("cms.ui.permissions.current_object_is_null").localize());
        }
        this.getPermissionGrantPanel().setVisible(s, false);
    }

    public void actionPerformed(ActionEvent e) {
        PermissionDescriptor admin;
        PageState s = e.getPageState();
        if (this.isVisible(s) && !PermissionService.checkPermission((PermissionDescriptor)(admin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, this.getObject(s), this.getRequestingUser(s))))) {
            try {
                DispatcherHelper.sendRedirect((HttpServletRequest)s.getRequest(), (HttpServletResponse)s.getResponse(), (String)"/permissions/denied");
            }
            catch (IOException iox) {
                throw new UncheckedWrapperException("IO Error: " + iox.getMessage(), (Throwable)iox);
            }
        }
    }

    public void showCustom(PageState state, boolean custom) {
        if (custom) {
            this.getDirectPermissionsPanel().setVisible(state, true);
            this.getInheritedPermissionsPanel().setVisible(state, false);
            this.getUserSearchForm().setVisible(state, true);
            this.getAdminListingPanel().setVisible(state, true);
        } else {
            this.getDirectPermissionsPanel().setVisible(state, false);
            this.getInheritedPermissionsPanel().setVisible(state, true);
            this.getUserSearchForm().setVisible(state, false);
            this.getAdminListingPanel().setVisible(state, false);
        }
    }

    public String getPrivilegeName(String privilege) {
        return (String)this.m_privNameMap.get(privilege);
    }

    public void pageRequested(RequestEvent e) {
    }
}

