/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.permissions;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ui.permissions.CMSPermissionsConstants;
import com.arsdigita.cms.ui.permissions.CMSPermissionsPane;
import com.arsdigita.cms.ui.permissions.CMSUserObjectStruct;
import com.arsdigita.cms.ui.permissions.PermissionStatus;
import com.arsdigita.cms.ui.permissions.UserPrivilegeKey;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class CMSPermissionsTables
implements CMSPermissionsConstants {
    private static Logger s_log = Logger.getLogger(CMSPermissionsTables.class);
    private CMSPermissionsPane m_parent;
    private PrivilegeDescriptor[] m_privileges;
    private GridPanel[] m_permPanel = new GridPanel[2];
    private int[] m_tableColumns = new int[2];
    private ActionLink m_contextLink;
    private Label m_contextLabel;

    CMSPermissionsTables(CMSPermissionsPane parent) {
        this(DEFAULT_PRIVILEGES, parent);
    }

    CMSPermissionsTables(PrivilegeDescriptor[] privs, CMSPermissionsPane parent) {
        this.m_parent = parent;
        this.m_privileges = privs;
        this.m_tableColumns[0] = this.m_privileges.length + 2;
        this.m_tableColumns[1] = this.m_privileges.length + 1;
        this.m_permPanel[0] = new GridPanel(1);
        Table table = new Table((TableModelBuilder)new PermissionsTableModelBuilder(0), (Object[])this.getHeaders(0));
        table.setClassAttr("dataTable");
        this.setCellRenderers(table, 0);
        table.addTableActionListener((TableActionListener)new DirectPermissionsTableActionListener());
        this.m_permPanel[0].add((Component)new Label(GlobalizationUtil.globalize("cms.ui.permissions.these_are_the_custom_permissions_that_have_been_granted_on_this_object")));
        this.m_permPanel[0].add((Component)table);
        this.m_permPanel[1] = new GridPanel(1);
        table = new Table((TableModelBuilder)new PermissionsTableModelBuilder(1), (Object[])this.getHeaders(1));
        table.setClassAttr("dataTable");
        this.setCellRenderers(table, 1);
        this.m_permPanel[1].add((Component)new Label(GlobalizationUtil.globalize("cms.ui.permissions.these_are_the_current_permissions_for_this_folder")));
        this.m_permPanel[1].add((Component)table);
    }

    GridPanel getPermissions(int type) {
        return this.m_permPanel[type];
    }

    String[] getPrivileges() {
        String[] privs = new String[this.m_privileges.length];
        for (int i = 0; i < this.m_privileges.length; ++i) {
            privs[i] = this.m_privileges[i].getName();
        }
        return privs;
    }

    SimpleComponent makeContextPanel() {
        SimpleContainer contextPanel = new SimpleContainer();
        Label contextLabel = new Label();
        contextLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label l = (Label)e.getTarget();
                ACSObject context = CMSPermissionsTables.this.getContext(s);
                if (context != null) {
                    l.setLabel(CMSPermissionsConstants.PERM_TABLE_INDIRECT_CONTEXT.localize(s.getRequest()) + "");
                    CMSPermissionsTables.this.m_contextLabel.setVisible(s, true);
                } else {
                    l.setLabel(CMSPermissionsConstants.PERM_TABLE_NO_PARENT_CONTEXT.localize(s.getRequest()) + "");
                    CMSPermissionsTables.this.m_contextLabel.setVisible(s, false);
                }
            }
        });
        this.m_contextLabel = new Label();
        this.m_contextLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label l = (Label)e.getTarget();
                ACSObject context = CMSPermissionsTables.this.getContext(s);
                if (context != null) {
                    l.setLabel(context.getDisplayName());
                }
            }
        });
        this.m_contextLabel.setFontWeight("b");
        contextPanel.add((Component)contextLabel);
        contextPanel.add((Component)this.m_contextLabel);
        return contextPanel;
    }

    ACSObject getContext(PageState s) {
        ACSObject obj = this.m_parent.getObject(s);
        DataObject dobj = PermissionService.getContext((ACSObject)obj);
        if (dobj != null) {
            OID oid = dobj.getOID();
            ACSObject context = CMSUserObjectStruct.loadObject(oid);
            return context;
        }
        return null;
    }

    private String[] getHeaders(int type) {
        String[] headers = new String[this.m_tableColumns[type]];
        headers[0] = PERM_TABLE_GRANTEE.localize() + "";
        for (int j = 0; j < this.m_privileges.length; ++j) {
            headers[j + 1] = this.m_parent.getPrivilegeName(this.m_privileges[j].getDisplayName());
        }
        if (type == 0) {
            headers[this.m_privileges.length + 1] = PERM_TABLE_ACTIONS.localize() + "";
        }
        return headers;
    }

    private void setCellRenderers(Table t, int type) {
        if (type == 0) {
            int j;
            for (j = 1; j < t.getColumnModel().size() - 1; ++j) {
                t.getColumn(j).setCellRenderer((TableCellRenderer)new PermissionToggleRenderer());
            }
            t.getColumn(j).setCellRenderer((TableCellRenderer)new LinkRenderer());
        } else {
            for (int j = 1; j < t.getColumnModel().size(); ++j) {
                t.getColumn(j).setCellRenderer((TableCellRenderer)new PermissionStatusRenderer());
            }
        }
    }

    private final class LinkRenderer
    implements TableCellRenderer {
        private LinkRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ControlLink cl = new ControlLink((String)value);
            cl.setConfirmation(CMSPermissionsConstants.REMOVE_ALL_CONFIRM.localize().toString());
            return cl;
        }
    }

    private final class PermissionStatusRenderer
    implements TableCellRenderer {
        private PermissionStatusRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Label link = new Label();
            if (((Boolean)value).booleanValue()) {
                link.setClassAttr("checkBoxGreyChecked");
            } else {
                link.setClassAttr("checkBoxGreyUnchecked");
            }
            return link;
        }
    }

    private final class PermissionToggleRenderer
    implements TableCellRenderer {
        private PermissionToggleRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ControlLink link = new ControlLink("");
            if (((Boolean)value).booleanValue()) {
                link.setClassAttr("checkBoxChecked");
            } else {
                link.setClassAttr("checkBoxUnchecked");
            }
            return link;
        }
    }

    private final class InheritedPermissionsTableModel
    extends DirectPermissionsTableModel {
        public InheritedPermissionsTableModel(ObjectPermissionCollection perm, BigDecimal id) {
            this.m_objectID = id;
            this.m_perm = perm;
            while ((this.m_more = this.m_perm.next()) && !this.m_perm.isInherited()) {
            }
        }

        @Override
        public int getColumnCount() {
            return CMSPermissionsTables.this.m_tableColumns[1];
        }

        @Override
        public Object getElementAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_currentGrantee;
            }
            if (this.userHasPermission(columnIndex - 1)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Object getKeyAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_currentGrantee;
            }
            return null;
        }

        @Override
        public boolean nextRow() {
            if (this.getGranteeInfo()) {
                return true;
            }
            this.m_perm.close();
            return false;
        }

        private boolean getGranteeInfo() {
            if (!this.m_more) {
                return false;
            }
            this.m_currentGrantee = this.m_perm.getGranteeName();
            this.m_currentGranteeID = this.m_perm.getGranteeID();
            this.m_userPrivs.clear();
            while (this.m_more && this.m_perm.getGranteeName().compareTo(this.m_currentGrantee) == 0) {
                this.addPrivilege(this.m_perm.getPrivilege());
                this.m_more = this.m_perm.next();
            }
            if (this.m_userPrivs.size() > 0) {
                return true;
            }
            return this.getGranteeInfo();
        }
    }

    private class DirectPermissionsTableModel
    implements TableModel {
        ObjectPermissionCollection m_perm;
        String m_currentGrantee;
        BigDecimal m_currentGranteeID;
        BigDecimal m_objectID;
        boolean m_more;
        ArrayList m_userPrivs = new ArrayList();

        public DirectPermissionsTableModel() {
        }

        public DirectPermissionsTableModel(ObjectPermissionCollection perm, BigDecimal id) {
            this.m_objectID = id;
            this.m_perm = perm;
            this.m_more = this.m_perm.next();
        }

        public int getColumnCount() {
            return CMSPermissionsTables.this.m_tableColumns[0];
        }

        public Object getElementAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_currentGrantee;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return "Remove All";
            }
            if (this.userHasPermission(columnIndex - 1)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object getKeyAt(int columnIndex) {
            if (columnIndex == 0) {
                return this.m_currentGrantee;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return this.makeRemoveAllKey();
            }
            return new UserPrivilegeKey(this.m_objectID, this.m_currentGranteeID, CMSPermissionsTables.this.m_privileges[columnIndex - 1].getName(), this.userHasPermission(columnIndex - 1)).toString();
        }

        public boolean nextRow() {
            if (this.getGranteeInfo()) {
                return true;
            }
            this.m_perm.close();
            return false;
        }

        boolean userHasPermission(int idx) {
            return this.m_userPrivs.contains(CMSPermissionsTables.this.m_privileges[idx]);
        }

        private String makeRemoveAllKey() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_currentGranteeID.toString());
            for (int i = 0; i < CMSPermissionsTables.this.m_privileges.length; ++i) {
                if (!this.userHasPermission(i)) continue;
                sb.append("." + CMSPermissionsTables.this.m_privileges[i].getName());
            }
            return sb.toString();
        }

        private boolean getGranteeInfo() {
            if (!this.m_more || this.m_perm.isInherited()) {
                return false;
            }
            this.m_currentGrantee = this.m_perm.getGranteeName();
            this.m_currentGranteeID = this.m_perm.getGranteeID();
            this.m_userPrivs.clear();
            while (this.m_more && this.m_perm.getGranteeName().compareTo(this.m_currentGrantee) == 0) {
                this.addPrivilege(this.m_perm.getPrivilege());
                this.m_more = this.m_perm.next();
            }
            if (this.m_userPrivs.size() > 0) {
                return true;
            }
            return this.getGranteeInfo();
        }

        void addPrivilege(PrivilegeDescriptor priv) {
            for (int i = 0; i < CMSPermissionsTables.this.m_privileges.length; ++i) {
                if (!CMSPermissionsTables.this.m_privileges[i].equals((Object)priv)) continue;
                this.m_userPrivs.add(priv);
                break;
            }
        }
    }

    private final class PermissionsTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        int m_type;

        PermissionsTableModelBuilder(int type) {
            this.m_type = type;
        }

        public TableModel makeModel(Table t, PageState s) {
            BigDecimal id = CMSPermissionsTables.this.m_parent.getObject(s).getID();
            ObjectPermissionCollection m_perm = PermissionService.getGrantedPermissions((OID)new OID("com.arsdigita.kernel.ACSObject", (Object)id));
            if (this.m_type == 0) {
                return new DirectPermissionsTableModel(m_perm, id);
            }
            if (this.m_type == 1) {
                return new InheritedPermissionsTableModel(m_perm, id);
            }
            return null;
        }
    }

    private class DirectPermissionsTableActionListener
    implements TableActionListener {
        private DirectPermissionsTableActionListener() {
        }

        public void cellSelected(TableActionEvent e) {
            PageState state = e.getPageState();
            int col = e.getColumn();
            String rowkey = (String)e.getRowKey();
            if (rowkey == null) {
                return;
            }
            Table table = (Table)e.getSource();
            int no_cols = table.getColumnModel().size();
            int lastCol = no_cols - 1;
            if (col > 0 && col < lastCol) {
                PermissionStatus pmds = UserPrivilegeKey.undescribe(rowkey);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Do perm toggle on " + pmds.getObject().getOID() + " for " + pmds.getParty().getOID() + " of " + pmds.getPrivilegeDescriptor()));
                }
                if (pmds.isGranted()) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)"Do revoke perm");
                    }
                    PermissionService.revokePermission((PermissionDescriptor)pmds.getPermissionDescriptor());
                    if (PermissionService.checkPermission((PermissionDescriptor)pmds.getPermissionDescriptor())) {
                        s_log.warn((Object)"Warning: Permission revoked,  but Party still has Permission through inheritance");
                    }
                } else {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)"Do grant perm");
                        if (PermissionService.checkPermission((PermissionDescriptor)pmds.getPermissionDescriptor())) {
                            s_log.debug((Object)"Permission is already implied by an existing perm");
                        }
                    }
                    PermissionService.grantPermission((PermissionDescriptor)pmds.getPermissionDescriptor());
                }
            } else if (col == lastCol) {
                String[] tokens = StringUtils.split((String)rowkey, (char)'.');
                BigDecimal pID = new BigDecimal(tokens[0]);
                ACSObject obj = CMSPermissionsTables.this.m_parent.getObject(state);
                Party party = CMSUserObjectStruct.loadParty(pID);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Revoke all on " + obj.getOID() + " for " + obj.getOID()));
                }
                PermissionDescriptor pmd = null;
                for (int j = 1; j < tokens.length; ++j) {
                    pmd = new PermissionDescriptor(PrivilegeDescriptor.get((String)tokens[j]), obj, party);
                    PermissionService.revokePermission((PermissionDescriptor)pmd);
                }
            }
        }

        public void headSelected(TableActionEvent e) {
            throw new UnsupportedOperationException();
        }
    }
}

