/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.permissions;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ui.permissions.CMSPermissionsConstants;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class CMSUserObjectStruct
implements CMSPermissionsConstants {
    private static final Logger s_log = Logger.getLogger(CMSUserObjectStruct.class);
    private Party m_party;
    private ACSObject m_object;

    CMSUserObjectStruct(PageState s, ACSObjectSelectionModel model) {
        this(CMSUserObjectStruct.getParty(s), CMSUserObjectStruct.getObject(s, model));
    }

    CMSUserObjectStruct(BigDecimal partyID, BigDecimal objectID) {
        this(CMSUserObjectStruct.loadParty(partyID), CMSUserObjectStruct.loadObject(objectID));
    }

    CMSUserObjectStruct(Party p, ACSObject o) {
        this.m_party = p;
        this.m_object = o;
    }

    Party getParty() {
        return this.m_party;
    }

    ACSObject getObject() {
        return this.m_object;
    }

    static ACSObject loadObject(BigDecimal id) {
        ACSObject obj = null;
        try {
            obj = (ACSObject)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.ACSObject", (Object)id));
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.ui.permissions.could_not_find_this_object").localize(), (Throwable)e);
        }
        return obj;
    }

    static ACSObject loadObject(OID oid) {
        ACSObject obj = null;
        try {
            obj = (ACSObject)DomainObjectFactory.newInstance((OID)oid);
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.ui.permissions.could_not_find_this_object").localize() + oid, (Throwable)e);
        }
        return obj;
    }

    static Party loadParty(BigDecimal id) {
        User party = null;
        try {
            party = User.retrieve((BigDecimal)id);
        }
        catch (DataObjectNotFoundException e1) {
            try {
                party = new Group(id);
            }
            catch (DataObjectNotFoundException e2) {
                throw new UncheckedWrapperException("No User in Database with the id " + id, (Throwable)e2);
            }
        }
        return party;
    }

    public static Party getParty(PageState s) {
        return Kernel.getContext().getParty();
    }

    public static ACSObject getObject(PageState s, ACSObjectSelectionModel model) {
        return (ACSObject)model.getSelectedObject(s);
    }
}

