/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.permissions;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.permissions.ObjectAddSearchAdmin;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;

public class ObjectAdminListing
extends SimpleContainer {
    private Table m_admin;
    private ActionLink m_addUser;
    private ACSObjectSelectionModel m_object;
    private ObjectAddSearchAdmin m_search;

    public ObjectAdminListing(ACSObjectSelectionModel model) {
        super("cms:roleAdmin", "http://www.arsdigita.com/cms/1.0");
        this.m_object = model;
        this.m_admin = new Table(this.getTableModelBuilder(model), (Object[])new String[]{"Member", "Action"});
        this.m_admin.setDefaultCellRenderer((TableCellRenderer)new ObjectAdminTableRenderer());
        this.m_admin.setEmptyView((Component)new Label("There are no administrators for this object"));
        this.m_admin.setClassAttr("dataTable");
        this.m_admin.addTableActionListener((TableActionListener)new ObjectAdminActionListener());
        this.m_addUser = new ActionLink((String)GlobalizationUtil.globalize("cms.ui.permissions.add_administrator").localize());
        this.m_addUser.setClassAttr("actionLink");
        this.m_search = this.getObjectAddSearchAdmin(model);
        this.m_addUser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectAdminListing.this.m_search.setVisible(e.getPageState(), true);
                ObjectAdminListing.this.m_addUser.setVisible(e.getPageState(), false);
            }
        });
        this.m_search.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectAdminListing.this.m_search.setVisible(e.getPageState(), false);
                ObjectAdminListing.this.m_addUser.setVisible(e.getPageState(), true);
            }
        });
        this.add((Component)this.m_admin);
        this.add((Component)this.m_addUser);
        this.add((Component)this.m_search);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_search, false);
    }

    protected ObjectAddSearchAdmin getObjectAddSearchAdmin(ACSObjectSelectionModel model) {
        return new ObjectAddSearchAdmin(model);
    }

    protected TableModelBuilder getTableModelBuilder(ACSObjectSelectionModel model) {
        return new ObjectTableModelBuilder(model);
    }

    private class ObjectAdminTableRenderer
    implements TableCellRenderer {
        private ObjectAdminTableRenderer() {
        }

        public Component getComponent(Table list, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Party party = (Party)value;
            if (column == 0) {
                Label l = new Label(party.getDisplayName());
                return l;
            }
            if (column == 1) {
                Label l = new Label("remove");
                return new ControlLink((Component)l);
            }
            throw new IllegalArgumentException("Column index " + column + " out of bounds 0..1");
        }
    }

    public class ObjectAdminTableModel
    implements TableModel {
        private DataQuery m_parties;

        public ObjectAdminTableModel(DataQuery parties) {
            this.m_parties = parties;
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean nextRow() {
            return this.m_parties.next();
        }

        public Object getElementAt(int column) {
            return DomainObjectFactory.newInstance((DataObject)((DataObject)this.m_parties.get("party")));
        }

        public Object getKeyAt(int column) {
            return this.m_parties.get("party.id").toString();
        }
    }

    private class ObjectTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private ACSObjectSelectionModel m_model;

        ObjectTableModelBuilder(ACSObjectSelectionModel model) {
            this.m_model = model;
        }

        public TableModel makeModel(Table l, PageState state) {
            ACSObject object = (ACSObject)this.m_model.getSelectedObject(state);
            DataQuery parties = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.objectAdminListing");
            parties.setParameter("objectID", (Object)object.getID());
            return new ObjectAdminTableModel(parties);
        }
    }

    private class ObjectAdminActionListener
    implements TableActionListener {
        private ObjectAdminActionListener() {
        }

        public void cellSelected(TableActionEvent e) {
            if (e.getColumn() == 1) {
                PageState state = e.getPageState();
                SecurityManager sm = Utilities.getSecurityManager(state);
                boolean isAdmin = sm.canAccess(state.getRequest(), "staff_admin");
                if (!isAdmin) {
                    throw new AccessDeniedException((String)GlobalizationUtil.globalize("cms.ui.permissions.not_an_object_adminstrator").localize());
                }
                Party party = null;
                try {
                    String id = (String)e.getRowKey();
                    party = (Party)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.Party", (Object)new BigDecimal(id)));
                }
                catch (DataObjectNotFoundException ex) {
                    throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.ui.permissions.cannot_retrieve_party").localize(), (Throwable)ex);
                }
                ACSObject object = (ACSObject)ObjectAdminListing.this.m_object.getSelectedObject(state);
                PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, object, party);
                PermissionService.revokePermission((PermissionDescriptor)perm);
            }
        }

        public void headSelected(TableActionEvent e) {
        }
    }
}

