/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.portlet;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.portlet.ContentDirectoryPortlet;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ContentDirectoryPortletRenderer
extends AbstractPortletRenderer {
    private static Logger s_log = Logger.getLogger((String)ContentDirectoryPortletRenderer.class.getName());
    private ContentDirectoryPortlet m_portlet;

    public ContentDirectoryPortletRenderer(ContentDirectoryPortlet portlet) {
        this.m_portlet = portlet;
    }

    public void generateBodyXML(PageState state, Element parent) {
        HashMap<BigDecimal, Element> cats = new HashMap<BigDecimal, Element>();
        Element element = parent.newChildElement("portlet:contentDirectory", "http://www.arsdigita.com/portlet/1.0");
        element.addAttribute("id", this.getIdAttr());
        DataQuery categories = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.portlet.getContentDirectory");
        while (categories.next()) {
            BigDecimal categoryID = (BigDecimal)categories.get("categoryID");
            BigDecimal parentID = (BigDecimal)categories.get("parentID");
            String name = (String)categories.get("name");
            String description = (String)categories.get("description");
            String path = (String)categories.get("path");
            int depth = 0;
            int offset = path.indexOf(47);
            while (offset != -1) {
                ++depth;
                offset = path.indexOf(47, offset + 1);
            }
            if ((depth -= 2) != 1 && depth != 2) continue;
            if (depth == 1) {
                Element categoryElement = element.newChildElement("portlet:contentDirectoryEntry", "http://www.arsdigita.com/portlet/1.0");
                categoryElement.addAttribute("categoryID", categoryID.toString());
                categoryElement.addAttribute("name", name);
                categoryElement.addAttribute("description", description);
                cats.put(categoryID, categoryElement);
                continue;
            }
            if (depth != 2) continue;
            Element parentElement = (Element)cats.get(parentID);
            if (parentElement != null) {
                Element categoryElement = parentElement.newChildElement("portlet:contentDirectorySubentry", "http://www.arsdigita.com/portlet/1.0");
                categoryElement.addAttribute("categoryID", categoryID.toString());
                categoryElement.addAttribute("name", name);
                categoryElement.addAttribute("description", description);
                cats.put(categoryID, categoryElement);
                continue;
            }
            s_log.warn((Object)("Cannot find parent category element " + parentID + " for " + categoryID));
        }
        categories.close();
    }
}

