/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.portlet;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.portal.PortletConfigFormSection;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.MultilingualItemResolver;
import com.arsdigita.cms.portlet.ContentItemPortlet;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.portal.Portlet;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ContentItemPortletEditor
extends PortletConfigFormSection {
    private static final Logger s_log = Logger.getLogger(ContentItemPortletEditor.class);
    private TextField m_url;
    private RequestLocal m_contentItem = new RequestLocal(){

        protected Object initialValue(PageState ps) {
            ContentItem item;
            StringTokenizer tok;
            java.net.URL url;
            java.net.URL contextURL;
            String userURL = (String)ContentItemPortletEditor.this.m_url.getValue(ps);
            try {
                contextURL = new java.net.URL(Web.getRequest().getRequestURL().toString());
            }
            catch (MalformedURLException ex) {
                throw new UncheckedWrapperException((Throwable)ex);
            }
            try {
                url = new java.net.URL(contextURL, userURL);
            }
            catch (MalformedURLException ex) {
                s_log.info((Object)("Malformed URL " + userURL));
                return null;
            }
            String dp = URL.getDispatcherPath();
            String path = url.getPath();
            if (path.startsWith(dp)) {
                path = path.substring(dp.length());
            }
            if (!(tok = new StringTokenizer(path, "/")).hasMoreTokens()) {
                s_log.info((Object)("Couldn't find a content section for " + path + " in " + userURL));
                return null;
            }
            String sectionPath = '/' + tok.nextToken() + '/';
            String context = "live";
            if (tok.hasMoreTokens() && "preview".equals(tok.nextToken())) {
                context = "preview";
            }
            ContentSectionCollection sections = ContentSection.getAllSections();
            sections.addEqualsFilter("primaryURL", sectionPath);
            if (!sections.next()) {
                s_log.info((Object)("Content section " + sectionPath + " in " + userURL + " doesn't exist."));
                return null;
            }
            ContentSection section = sections.getContentSection();
            sections.close();
            ItemResolver resolver = section.getItemResolver();
            path = path.substring(sectionPath.length());
            if (path.endsWith(".jsp")) {
                path = path.substring(0, path.length() - 4);
            }
            if ((item = resolver.getItem(section, path, context)) == null) {
                s_log.debug((Object)("Couldn't resolve item " + path));
                return null;
            }
            return item.getDraftVersion();
        }
    };

    public ContentItemPortletEditor(ResourceType resType, RequestLocal parentAppRL) {
        super(resType, parentAppRL);
    }

    public ContentItemPortletEditor(RequestLocal application) {
        super(application);
    }

    public void addWidgets() {
        super.addWidgets();
        this.m_url = new TextField((ParameterModel)new StringParameter("url"));
        this.m_url.setSize(50);
        this.m_url.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_url.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 250));
        this.add((Component)new Label("Item URL:", "b"), 4);
        this.add((Component)this.m_url);
    }

    public void initWidgets(PageState state, Portlet portlet) throws FormProcessException {
        super.initWidgets(state, portlet);
        if (portlet != null) {
            ContentItemPortlet myportlet = (ContentItemPortlet)portlet;
            MultilingualItemResolver resolver = new MultilingualItemResolver();
            ContentItem item = myportlet.getContentItem();
            if (item != null) {
                String context;
                if (item.isLive()) {
                    item = item.getPublicVersion();
                    context = "live";
                } else {
                    context = "preview";
                }
                this.m_url.setValue(state, (Object)resolver.generateItemURL(state, item, item.getContentSection(), context));
            } else {
                this.m_url.setValue(state, (Object)"");
            }
        }
    }

    public void validateWidgets(PageState state, Portlet portlet) throws FormProcessException {
        super.validateWidgets(state, portlet);
        Object item = this.m_contentItem.get(state);
        if (item == null) {
            throw new FormProcessException("cannot find content item");
        }
    }

    public void processWidgets(PageState state, Portlet portlet) throws FormProcessException {
        super.processWidgets(state, portlet);
        ContentItem item = (ContentItem)this.m_contentItem.get(state);
        ContentItemPortlet myportlet = (ContentItemPortlet)portlet;
        myportlet.setContentItem(item);
    }
}

