/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.portlet;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentItemXMLRenderer;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.cms.portlet.ContentItemPortlet;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class ContentItemPortletRenderer
extends AbstractPortletRenderer {
    private static Logger s_log = Logger.getLogger(ContentItemPortletRenderer.class);
    private ContentItemPortlet m_portlet;

    public ContentItemPortletRenderer(ContentItemPortlet portlet) {
        this.m_portlet = portlet;
    }

    public void generateBodyXML(PageState state, Element parent) {
        PermissionDescriptor publish;
        PermissionDescriptor read;
        Element content = parent.newChildElement("portlet:contentItem", "http://www.uk.arsdigita.com/portlet/1.0");
        ContentItem item = this.m_portlet.getContentItem();
        Party currentParty = Kernel.getContext().getParty();
        if (currentParty == null) {
            currentParty = Kernel.getPublicUser();
        }
        if (!PermissionService.checkPermission((PermissionDescriptor)(read = new PermissionDescriptor(PrivilegeDescriptor.get((String)"cms_read_item"), (ACSObject)item, currentParty)))) {
            if (Web.getUserContext().isLoggedIn()) {
                throw new AccessDeniedException("User does cannot read content item " + item.getName());
            }
            throw new LoginSignal(Web.getRequest());
        }
        PermissionDescriptor edit = new PermissionDescriptor(PrivilegeDescriptor.get((String)"cms_edit_item"), (ACSObject)item, currentParty);
        if (PermissionService.checkPermission((PermissionDescriptor)edit)) {
            content.addAttribute("canEdit", "true");
        }
        if (PermissionService.checkPermission((PermissionDescriptor)(publish = new PermissionDescriptor(PrivilegeDescriptor.get((String)"cms_publish"), (ACSObject)item, currentParty)))) {
            content.addAttribute("canPublish", "true");
        }
        if (null == item) {
            s_log.warn((Object)("No content item for content item portlet " + this.m_portlet.getOID()));
            return;
        }
        if (!item.isLive()) {
            s_log.info((Object)("No live version for content item portlet " + this.m_portlet.getOID()));
            return;
        }
        this.renderItem(item.getPublicVersion(), content);
    }

    protected void renderItem(ContentItem item, Element content) {
        Element contentItem = content.newChildElement("cms:item", "http://www.arsdigita.com/cms/1.0");
        ContentItemXMLRenderer renderer = new ContentItemXMLRenderer(contentItem);
        renderer.setWrapAttributes(true);
        renderer.setWrapRoot(false);
        renderer.setWrapObjects(false);
        renderer.walk((DomainObject)item, SimpleXMLGenerator.ADAPTER_CONTEXT);
    }

    public String getCacheKey(PageState state) {
        ContentItem item = this.m_portlet.getContentItem();
        if (null == item) {
            return "";
        }
        if (item.isLive()) {
            return item.getPublicVersion().getOID().toString();
        }
        return "";
    }

    public boolean isDirty(PageState state) {
        return false;
    }
}

