/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.portlet;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Workspace;
import com.arsdigita.cms.portlet.TaskPortlet;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.kernel.User;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.xml.Element;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TaskPortletRenderer
extends AbstractPortletRenderer {
    private static final Logger s_log = Logger.getLogger(TaskPortletRenderer.class);
    private TaskPortlet m_portlet;

    public TaskPortletRenderer(TaskPortlet portlet) {
        this.m_portlet = portlet;
    }

    protected void generateBodyXML(PageState pageState, Element parentElement) {
        String contentCenter = Workspace.getURL();
        Link link = new Link("Content Center", contentCenter);
        SimpleContainer container = new SimpleContainer();
        container.add((Component)new Label("Go to "));
        container.add((Component)link);
        container.generateXML(pageState, parentElement);
        GridPanel taskDisplay = new GridPanel(3);
        int i = 0;
        User currentUser = Web.getContext().getUser();
        Date currentDate = new Date();
        int numTasks = this.m_portlet.getMaxNumTasks();
        if (currentUser == null) {
            taskDisplay.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.portlet.tasks.no_user_logged_in")));
            taskDisplay.generateXML(pageState, parentElement);
            return;
        }
        List alist = Engine.getInstance((String)"cms").getEnabledTasks(currentUser);
        Iterator it = alist.iterator();
        if (!it.hasNext()) {
            taskDisplay.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.portlet.tasks.no_assigned_tasks")));
            return;
        }
        while (it.hasNext()) {
            CMSTask currentTask = (CMSTask)((Object)it.next());
            ContentItem item = currentTask.getItem();
            ContentSection section = currentTask.getContentSection();
            ++i;
            String itemURL = ContentItemPage.getItemURL(section.getPath() + "/", item.getID(), ContentItemPage.AUTHORING_TAB);
            URL fullURL = URL.there((HttpServletRequest)pageState.getRequest(), (String)itemURL, null);
            taskDisplay.add((Component)new Link(item.getDisplayName(), fullURL));
            taskDisplay.add((Component)new Label(currentTask.getDisplayName()));
            Label dueday = new Label(currentTask.getDueDate().toString());
            dueday.setIdAttr("duedate");
            Date dday = currentTask.getDueDate();
            if (currentDate.before(dday)) {
                dueday.setClassAttr("overdue");
            } else {
                dueday.setClassAttr("ok");
            }
            taskDisplay.add((Component)dueday);
            if (i != numTasks) continue;
            break;
        }
        taskDisplay.generateXML(pageState, parentElement);
    }

    public boolean isDirty() {
        return true;
    }
}

