/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.report;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.Folder;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ContentSectionSummaryReportTableModelBuilder
extends AbstractTableModelBuilder {
    public TableModel makeModel(Table t, PageState s) {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.cms.getContentSectionSummary");
        query.setParameter("sectionId", (Object)CMS.getContext().getContentSection().getID());
        return new CSSRModel((DataCollection)new DataQueryDataCollectionAdapter(query, "folder"));
    }

    private static class ContentTypeStatistics {
        private final String m_contentType;
        private final long m_draftCount;
        private final long m_liveCount;

        public ContentTypeStatistics(String contentType, long draftCount, long liveCount) {
            this.m_contentType = contentType;
            this.m_draftCount = draftCount;
            this.m_liveCount = liveCount;
        }

        public String getContentType() {
            return this.m_contentType;
        }

        public long getDraftCount() {
            return this.m_draftCount;
        }

        public long getLiveCount() {
            return this.m_liveCount;
        }
    }

    private class CSSRModel
    implements TableModel {
        private final DataCollection m_folders;
        private String m_folderName;
        private BigDecimal m_subfolderCount;
        private ContentTypeStatistics m_currentStatsRow;
        private Iterator<ContentTypeStatistics> m_contentTypeStatIter;

        CSSRModel(DataCollection folders) {
            this.m_folders = folders;
        }

        public final int getColumnCount() {
            return 5;
        }

        public final boolean nextRow() {
            if (this.m_contentTypeStatIter == null && this.m_folders.next()) {
                this.m_folderName = (String)this.m_folders.get("folder");
                this.m_subfolderCount = (BigDecimal)this.m_folders.get("subfolderCount");
                Folder draftFolder = new Folder((BigDecimal)this.m_folders.get("folderId"));
                this.m_contentTypeStatIter = this.retrieveContentTypeStats(draftFolder);
                if (this.m_contentTypeStatIter.hasNext()) {
                    this.m_currentStatsRow = this.m_contentTypeStatIter.next();
                } else {
                    this.m_contentTypeStatIter = null;
                    this.m_currentStatsRow = null;
                }
                return true;
            }
            if (this.m_contentTypeStatIter != null) {
                if (!this.m_contentTypeStatIter.hasNext()) {
                    this.m_contentTypeStatIter = null;
                    return this.nextRow();
                }
                this.m_currentStatsRow = this.m_contentTypeStatIter.next();
                return true;
            }
            this.m_folders.close();
            return false;
        }

        public final Object getKeyAt(int column) {
            return -1;
        }

        public final Object getElementAt(int column) {
            switch (column) {
                case 0: {
                    return this.m_folderName;
                }
                case 1: {
                    return this.m_subfolderCount.toString();
                }
                case 2: {
                    return this.m_currentStatsRow != null ? this.m_currentStatsRow.getContentType() : "N/A";
                }
                case 3: {
                    return this.m_currentStatsRow != null ? Long.valueOf(this.m_currentStatsRow.getDraftCount()) : "N/A";
                }
                case 4: {
                    return this.m_currentStatsRow != null ? Long.valueOf(this.m_currentStatsRow.getLiveCount()) : "N/A";
                }
            }
            throw new IllegalArgumentException("Illegal column index " + column);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator<ContentTypeStatistics> retrieveContentTypeStats(Folder draftFolder) {
            Session session = SessionManager.getSession();
            DataQuery query = session.retrieveQuery("com.arsdigita.cms.getContentTypeCountPerFolder");
            query.setParameter("folderId", (Object)draftFolder.getID());
            DataQueryDataCollectionAdapter types = new DataQueryDataCollectionAdapter(query, "types");
            HashMap<String, Long> draftContentTypeCounts = new HashMap<String, Long>();
            try {
                while (types.next()) {
                    draftContentTypeCounts.put((String)types.get("contentType"), (Long)types.get("typeCount"));
                }
            }
            finally {
                types.close();
            }
            ArrayList<ContentTypeStatistics> result = new ArrayList<ContentTypeStatistics>();
            Folder liveFolder = (Folder)draftFolder.getLiveVersion();
            if (liveFolder != null) {
                query = session.retrieveQuery("com.arsdigita.cms.getContentTypeCountPerFolder");
                query.setParameter("folderId", (Object)liveFolder.getID());
                types = new DataQueryDataCollectionAdapter(query, "types");
                try {
                    while (types.next()) {
                        String contentType = (String)types.get("contentType");
                        long draftCount = draftContentTypeCounts.get(contentType) != null ? (Long)draftContentTypeCounts.get(contentType) : 0L;
                        long liveCount = (Long)types.get("typeCount");
                        result.add(new ContentTypeStatistics(contentType, draftCount, liveCount));
                        draftContentTypeCounts.remove(contentType);
                    }
                }
                finally {
                    types.close();
                }
            }
            for (Map.Entry draftCount : draftContentTypeCounts.entrySet()) {
                result.add(new ContentTypeStatistics((String)draftCount.getKey(), (Long)draftCount.getValue(), 0L));
            }
            return result.iterator();
        }
    }
}

