/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.report;

import com.arsdigita.bebop.Component;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;

public class Report {
    private final String m_key;
    private final String m_name;
    private final Component m_component;

    public Report(String key, Component component) {
        Assert.exists((Object)key, (String)"Key for report is required");
        Assert.isTrue((key.length() > 0 ? 1 : 0) != 0, (String)"Key for report must not be empty");
        Assert.exists((Object)component, (String)"Component for report is required");
        this.m_key = key;
        this.m_name = Report.gz(this.m_key).localize().toString();
        this.m_component = component;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getName() {
        return this.m_name;
    }

    public Component getComponent() {
        return this.m_component;
    }

    protected static final GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }
}

