/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.revision;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.bebop.util.Color;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.ui.revision.OperationIterator;
import com.arsdigita.cms.ui.revision.TransactionRequestLocal;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.versioning.Difference;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.Versions;
import org.apache.log4j.Logger;

final class DifferencePane
extends BaseItemPane {
    private static final Logger s_log = Logger.getLogger(DifferencePane.class);
    private final ContentItemRequestLocal m_item;
    private final TransactionRequestLocal m_from;
    private final TransactionRequestLocal m_to;

    DifferencePane(ContentItemRequestLocal item, TransactionRequestLocal from, TransactionRequestLocal to, ActionLink returnLink) {
        this.m_item = item;
        this.m_from = from;
        this.m_to = to;
        LayoutPanel panel = new LayoutPanel();
        this.add((Component)panel);
        this.setDefault((Component)panel);
        SimpleContainer container = new SimpleContainer();
        panel.setBody((Component)container);
        ActionGroup returnGroup = new ActionGroup();
        container.add((Component)returnGroup);
        returnGroup.addAction((Component)returnLink, "return");
        Section operations = new Section(DifferencePane.gz("cms.ui.item.revision.operations"));
        container.add((Component)operations);
        operations.setBody((Component)new OperationTable());
    }

    private class ModelBuilder
    extends AbstractTableModelBuilder {
        private ModelBuilder() {
        }

        public final TableModel makeModel(Table table, PageState state) {
            Difference diff = Versions.diff((OID)DifferencePane.this.m_item.getContentItem(state).getOID(), (Transaction)DifferencePane.this.m_from.getTransaction(state), (Transaction)DifferencePane.this.m_to.getTransaction(state));
            return new Model(diff);
        }

        private class Model
        implements TableModel {
            private final OperationIterator m_ops;
            private Object[] m_op;

            Model(Difference difference) {
                this.m_ops = new OperationIterator(difference);
            }

            public final int getColumnCount() {
                return 3;
            }

            public final boolean nextRow() {
                if (this.m_ops.hasNext()) {
                    this.m_op = this.m_ops.next();
                    return true;
                }
                return false;
            }

            public final Object getElementAt(int column) {
                switch (column) {
                    case 0: {
                        return this.m_op[0];
                    }
                    case 1: {
                        return this.m_op[1];
                    }
                    case 2: {
                        return new Object[]{this.m_op[2], this.m_op[3], this.m_op[4], this.m_op[5], this.m_op[6]};
                    }
                }
                throw new IllegalStateException();
            }

            public final Object getKeyAt(int column) {
                return null;
            }
        }
    }

    private class OperationTable
    extends Table {
        private TableColumn m_object;
        private TableColumn m_property;
        private TableColumn m_change;

        public OperationTable() {
            super(null, (TableColumnModel)new DefaultTableColumnModel());
            this.m_object = new TableColumn(0, (Object)DifferencePane.lz("cms.ui.item.revision.operation.object"));
            this.m_property = new TableColumn(1, (Object)DifferencePane.lz("cms.ui.item.revision.operation.property"));
            this.m_change = new TableColumn(2, (Object)DifferencePane.lz("cms.ui.item.revision.operation.change"));
            this.setModelBuilder((TableModelBuilder)new ModelBuilder());
            TableColumnModel columns = this.getColumnModel();
            columns.add(this.m_object);
            columns.add(this.m_property);
            columns.add(this.m_change);
            this.m_object.setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer());
            this.m_property.setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer());
            this.m_change.setCellRenderer((TableCellRenderer)new ChangeCellRenderer());
            this.setEmptyView((Component)new Label(DifferencePane.gz("cms.ui.item.revision.operation.none")));
        }

        private class ChangeCellRenderer
        implements TableCellRenderer {
            private ChangeCellRenderer() {
            }

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                Object[] change = (Object[])value;
                GridPanel result = new GridPanel(1);
                if (((Boolean)change[0]).booleanValue()) {
                    String adds = (String)change[4];
                    String removes = (String)change[3];
                    if (!adds.equals("")) {
                        Label addedLabel = new Label(DifferencePane.lz("cms.ui.item.revision.added") + " " + adds);
                        result.add((Component)addedLabel);
                    }
                    if (!removes.equals("")) {
                        Label removedLabel = new Label(DifferencePane.lz("cms.ui.item.revision.removed") + " " + removes);
                        result.add((Component)removedLabel);
                    }
                } else {
                    String from = (String)change[1];
                    String to = (String)change[2];
                    Label toLabel = new Label(DifferencePane.lz("cms.ui.item.revision.to") + " " + to);
                    result.add((Component)toLabel);
                    Label fromLabel = new Label(DifferencePane.lz("cms.ui.item.revision.from") + " " + from);
                    result.add((Component)fromLabel);
                    fromLabel.setColor(Color.gray);
                }
                return result;
            }
        }
    }
}

