/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.revision;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.ui.revision.DifferencePane;
import com.arsdigita.cms.ui.revision.RevisionTableModelBuilder;
import com.arsdigita.cms.ui.revision.TransactionRequestLocal;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.toolbox.ui.NullComponent;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.Versions;
import java.math.BigInteger;

public final class ItemRevisionAdminPane
extends BaseItemPane {
    private final ContentItemRequestLocal m_item;
    private final RevisionTable m_revisions;
    private final TransactionRequestLocal m_from;
    private final TransactionRequestLocal m_to;
    private final LayoutPanel m_selectPane;
    private final DifferencePane m_diffPane;

    public ItemRevisionAdminPane(ContentItemRequestLocal item) {
        this.m_item = item;
        RadioGroup fromSelect = new RadioGroup("from");
        RadioGroup toSelect = new RadioGroup("to");
        this.m_from = new SelectionRequestLocal(fromSelect);
        this.m_to = new SelectionRequestLocal(toSelect);
        this.m_revisions = new RevisionTable(fromSelect, toSelect);
        RevisionForm form = new RevisionForm(fromSelect, toSelect, this.m_revisions);
        this.m_selectPane = new LayoutPanel();
        this.add((Component)this.m_selectPane);
        this.setDefault((Component)this.m_selectPane);
        this.m_selectPane.setBody((Component)new Section(ItemRevisionAdminPane.gz("cms.ui.item.revisions"), (Component)form));
        ActionLink returnLink = new ActionLink((Component)new Label(ItemRevisionAdminPane.gz("cms.ui.item.revision.return")));
        this.m_diffPane = new DifferencePane(this.m_item, this.m_from, this.m_to, returnLink);
        this.add((Component)this.m_diffPane);
        this.connect((FormSection)form, (Component)this.m_diffPane);
        this.connect(returnLink, (Component)this.m_selectPane);
    }

    private class RevisionTable
    extends Table {
        private TableColumn m_from;
        private TableColumn m_to;
        private TableColumn m_timestamp;
        private TableColumn m_user;
        private TableColumn m_description;
        private TableColumn m_preview;
        private TableColumn m_rollback;

        public RevisionTable(RadioGroup fromSelect, RadioGroup toSelect) {
            super((TableModelBuilder)new RevisionTableModelBuilder(ItemRevisionAdminPane.this.m_item), (TableColumnModel)new DefaultTableColumnModel());
            this.m_from = new TableColumn(0, (Object)ItemRevisionAdminPane.lz("cms.ui.item.revision.from"));
            this.m_to = new TableColumn(1, (Object)ItemRevisionAdminPane.lz("cms.ui.item.revision.to"));
            this.m_timestamp = new TableColumn(2, (Object)ItemRevisionAdminPane.lz("cms.ui.item.revision"));
            this.m_user = new TableColumn(3, (Object)ItemRevisionAdminPane.lz("cms.ui.user"));
            this.m_description = new TableColumn(4, (Object)ItemRevisionAdminPane.lz("cms.ui.description"));
            this.m_preview = new TableColumn(5, (Object)ItemRevisionAdminPane.lz("cms.ui.item.revision.view"));
            this.m_rollback = new TableColumn(6, (Object)ItemRevisionAdminPane.lz("cms.ui.item.revision.rollback"));
            TableColumnModel columns = this.getColumnModel();
            columns.add(this.m_from);
            columns.add(this.m_to);
            columns.add(this.m_timestamp);
            columns.add(this.m_user);
            columns.add(this.m_description);
            columns.add(this.m_preview);
            columns.add(this.m_rollback);
            this.m_from.setCellRenderer((TableCellRenderer)new RadioCellRenderer(fromSelect));
            this.m_to.setCellRenderer((TableCellRenderer)new RadioCellRenderer(toSelect));
            this.m_timestamp.setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(false));
            this.m_user.setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(false));
            this.m_description.setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(false));
            this.m_preview.setCellRenderer((TableCellRenderer)new ViewCellRenderer());
            this.m_rollback.setCellRenderer((TableCellRenderer)new RollbackCellRenderer());
            this.setEmptyView((Component)new Label(ItemRevisionAdminPane.gz("cms.ui.item.revision.none")));
            this.addTableActionListener((TableActionListener)new RollbackActionListener());
        }

        class RollbackCellRenderer
        implements TableCellRenderer {
            RollbackCellRenderer() {
            }

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                if (key instanceof String) {
                    return new NullComponent();
                }
                return new ControlLink((Component)new Label(ItemRevisionAdminPane.gz("cms.ui.item.revision.rollback")));
            }
        }

        class RollbackActionListener
        extends TableActionAdapter {
            RollbackActionListener() {
            }

            public final void cellSelected(TableActionEvent e) {
                PageState state = e.getPageState();
                if (e.getColumn() == 6) {
                    ContentItem item = ItemRevisionAdminPane.this.m_item.getContentItem(state);
                    Versions.rollback((OID)item.getOID(), (BigInteger)new BigInteger(e.getRowKey().toString()));
                    item.applyTag(ItemRevisionAdminPane.lz("cms.ui.item.revision.rolled_back"));
                }
            }
        }

        class ViewCellRenderer
        implements TableCellRenderer {
            ViewCellRenderer() {
            }

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                if (key instanceof String) {
                    return new NullComponent();
                }
                BigInteger transID = (BigInteger)key;
                ContentItem item = ItemRevisionAdminPane.this.m_item.getContentItem(state);
                ContentSection section = item.getContentSection();
                ItemResolver itemResolver = section.getItemResolver();
                StringBuffer url = new StringBuffer(itemResolver.generateItemURL(state, item, section, "preview"));
                String sep = url.toString().indexOf(63) == -1 ? "?" : "&";
                url.append(sep).append("transID").append("=");
                url.append(transID.toString());
                Link link = new Link((Component)new Label(ItemRevisionAdminPane.gz("cms.ui.item.revision.view")), url.toString());
                link.setTargetFrame(ItemRevisionAdminPane.lz("cms.ui.item.revision.view"));
                return link;
            }
        }

        class RadioCellRenderer
        implements TableCellRenderer {
            private final RadioGroup m_group;

            RadioCellRenderer(RadioGroup group) {
                this.m_group = group;
            }

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                if (key.toString().equals("first")) {
                    if (column == 0) {
                        return new NullComponent();
                    }
                    Option option = new Option("", "");
                    option.setGroup((OptionGroup)this.m_group);
                    return option;
                }
                if (key.toString().equals("last")) {
                    if (column == 0) {
                        Option option = new Option("", "");
                        option.setGroup((OptionGroup)this.m_group);
                        return option;
                    }
                    return new NullComponent();
                }
                Option option = new Option(key.toString(), "");
                option.setGroup((OptionGroup)this.m_group);
                return option;
            }
        }
    }

    private class RevisionForm
    extends Form {
        RevisionForm(RadioGroup fromSelect, RadioGroup toSelect, RevisionTable revisions) {
            super("revisions", (Container)new GridPanel(1));
            this.setMethod("get");
            this.add((Component)fromSelect);
            this.add((Component)toSelect);
            fromSelect.setOptionSelected("");
            toSelect.setOptionSelected("");
            ActionGroup group = new ActionGroup();
            this.add((Component)group);
            group.setSubject((Component)revisions);
            group.addAction((Component)new Submit("diff", ItemRevisionAdminPane.gz("cms.ui.item.revision.difference.show")));
        }
    }

    private class SelectionRequestLocal
    extends TransactionRequestLocal {
        private final RadioGroup m_group;

        SelectionRequestLocal(RadioGroup group) {
            this.m_group = group;
        }

        protected final Object initialValue(PageState state) {
            Object id = this.m_group.getValue(state);
            if (id == null || id.toString().equals("")) {
                return null;
            }
            return Transaction.retrieve((BigInteger)new BigInteger(id.toString()));
        }
    }
}

