/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.revision;

import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.versioning.Difference;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

class OperationIterator {
    private static final Logger s_log = Logger.getLogger(OperationIterator.class);
    private final Iterator m_operations;

    OperationIterator(Difference diff) {
        Iterator changes = diff.getChanges().iterator();
        ArrayList<Object[]> operations = new ArrayList<Object[]>();
        while (changes.hasNext()) {
            Difference.Change change = (Difference.Change)changes.next();
            ObjectType type = change.getOID().getObjectType();
            String name = type.hasProperty("displayName") ? String.valueOf(change.getTo(type.getProperty("displayName"))) : type.toString();
            Iterator props = type.getProperties();
            while (props.hasNext()) {
                Property prop = (Property)props.next();
                Object from = change.getFrom(prop);
                Object to = change.getTo(prop);
                if (this.blacklisted(prop) || !change.isModified(prop) || from == null && to == null || from != null && from.equals(to) || to != null && to.equals(from)) continue;
                Iterator added = change.getAdded(prop).iterator();
                StringBuffer buffer = new StringBuffer();
                while (added.hasNext()) {
                    buffer.append(this.prettify(added.next(), change));
                    buffer.append(", ");
                }
                String adds = buffer.toString();
                if (adds.endsWith(", ")) {
                    adds = adds.substring(0, adds.length() - 2);
                }
                Iterator removed = change.getRemoved(prop).iterator();
                buffer = new StringBuffer();
                while (removed.hasNext()) {
                    buffer.append(this.prettify(removed.next(), change));
                    buffer.append(", ");
                }
                String removes = buffer.toString();
                if (removes.endsWith(", ")) {
                    removes = removes.substring(0, removes.length() - 2);
                }
                Object[] operation = new Object[]{this.prettify(change.getOID(), change), this.capitalize(prop.getName()), new Boolean(prop.isCollection()), this.prettify(from, change), this.prettify(to, change), adds, removes};
                operations.add(operation);
            }
        }
        this.m_operations = operations.iterator();
    }

    private String prettify(Object obj, Difference.Change change) {
        if (obj == null) {
            return OperationIterator.lz("cms.ui.item.revision.nothing");
        }
        if (obj instanceof String) {
            return this.quote(obj);
        }
        if (obj instanceof OID) {
            return this.name((OID)obj, change);
        }
        return obj.toString();
    }

    private String quote(Object obj) {
        return "\"" + obj + "\"";
    }

    private String name(OID oid, Difference.Change change) {
        ObjectType type = oid.getObjectType();
        if (type.hasProperty("displayName")) {
            return String.valueOf(change.getTo(type.getProperty("displayName")));
        }
        return type.toString();
    }

    private boolean blacklisted(Property prop) {
        String name = prop.getName();
        return name.equals("contentChildren") || name.equals("section");
    }

    private String capitalize(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() == 0) {
            return "";
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    final boolean hasNext() {
        return this.m_operations.hasNext();
    }

    final Object[] next() {
        return (Object[])this.m_operations.next();
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)OperationIterator.gz(key).localize();
    }
}

