/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.revision;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.FormatStandards;
import com.arsdigita.versioning.TagCollection;
import com.arsdigita.versioning.Transaction;
import com.arsdigita.versioning.TransactionCollection;
import com.arsdigita.versioning.Versions;
import java.util.Date;
import org.apache.log4j.Logger;

class RevisionTableModelBuilder
extends AbstractTableModelBuilder {
    private static final Logger s_log = Logger.getLogger(RevisionTableModelBuilder.class);
    static final int FROM = 0;
    static final int TO = 1;
    static final int TIMESTAMP = 2;
    static final int USER = 3;
    static final int DESCRIPTION = 4;
    static final int PREVIEW = 5;
    static final int ROLLBACK = 6;
    static final int COLUMNS = 7;
    private final ContentItemRequestLocal m_item;

    RevisionTableModelBuilder(ContentItemRequestLocal item) {
        this.m_item = item;
    }

    public final TableModel makeModel(Table table, PageState state) {
        return new Model(this.m_item.getContentItem(state).getOID());
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)RevisionTableModelBuilder.gz(key).localize();
    }

    private static class Model
    implements TableModel {
        private final TransactionCollection m_transactions;
        private Transaction m_transaction;
        private long m_count = 0L;
        private long m_last = 2L;

        public Model(OID oid) {
            this.m_transactions = Versions.getTaggedTransactions((OID)oid);
            this.m_last = this.m_transactions.size() + 2L;
        }

        public final int getColumnCount() {
            return 7;
        }

        public final boolean nextRow() {
            ++this.m_count;
            if (this.m_count == 1L) {
                return true;
            }
            if (this.m_count == this.m_last) {
                return true;
            }
            if (this.m_transactions.next()) {
                this.m_transaction = this.m_transactions.getTransaction();
                return true;
            }
            this.m_transactions.close();
            return false;
        }

        public final Object getElementAt(int column) {
            if (this.m_count == 1L) {
                switch (column) {
                    case 2: {
                        return RevisionTableModelBuilder.lz("cms.ui.item.revision.current");
                    }
                }
                return "";
            }
            if (this.m_count == this.m_last) {
                switch (column) {
                    case 2: {
                        return RevisionTableModelBuilder.lz("cms.ui.item.revision.first");
                    }
                }
                return "";
            }
            switch (column) {
                case 2: {
                    return FormatStandards.formatDateTime((Date)this.m_transaction.getTimestamp());
                }
                case 3: {
                    User user = this.m_transaction.getUser();
                    if (user == null) {
                        return "";
                    }
                    return user.getPrimaryEmail().toString();
                }
                case 4: {
                    TagCollection tags = this.m_transaction.getTags();
                    StringBuffer buffer = new StringBuffer();
                    int sep = 10;
                    while (tags.next()) {
                        buffer.append(tags.getTag().getDescription() + '\n');
                    }
                    int end = buffer.length() - 1;
                    if (buffer.charAt(end) == '\n') {
                        return buffer.substring(0, end);
                    }
                    return buffer.toString();
                }
            }
            return "";
        }

        public final Object getKeyAt(int column) {
            if (this.m_count == 1L) {
                return "first";
            }
            if (this.m_count == this.m_last) {
                return "last";
            }
            return this.m_transaction.getID();
        }
    }
}

