/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.ui.role.RoleRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.Role;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import org.apache.log4j.Logger;

class AdminTableModelBuilder
extends AbstractTableModelBuilder {
    private static final Logger s_log = Logger.getLogger(AdminTableModelBuilder.class);
    private final RoleRequestLocal m_role;

    AdminTableModelBuilder(RoleRequestLocal role) {
        this.m_role = role;
    }

    public final TableModel makeModel(Table table, PageState state) {
        Role role = this.m_role.getRole(state);
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.cms.roleAdminListing");
        query.setParameter("roleID", (Object)role.getID());
        DataQueryDataCollectionAdapter admins = new DataQueryDataCollectionAdapter(query, "party");
        return new Model(new PartyCollection((DataCollection)admins));
    }

    protected static final String lz(String key) {
        return (String)GlobalizationUtil.globalize(key).localize();
    }

    private static class Model
    implements TableModel {
        private Party m_party;
        private final PartyCollection m_parties;

        Model(PartyCollection parties) {
            this.m_parties = parties;
        }

        public final int getColumnCount() {
            return 3;
        }

        public final boolean nextRow() {
            if (this.m_parties.next()) {
                this.m_party = this.m_parties.getParty();
                return true;
            }
            this.m_parties.close();
            return false;
        }

        public final Object getKeyAt(int column) {
            return this.m_party.getID();
        }

        public final Object getElementAt(int column) {
            switch (column) {
                case 0: {
                    return this.m_party.getDisplayName();
                }
                case 1: {
                    EmailAddress email = this.m_party.getPrimaryEmail();
                    if (email == null) {
                        return AdminTableModelBuilder.lz("cms.ui.none");
                    }
                    return email.toString();
                }
                case 2: {
                    return AdminTableModelBuilder.lz("cms.ui.role.admin.remove");
                }
            }
            throw new IllegalStateException();
        }
    }
}

