/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.PartySearchForm;
import com.arsdigita.cms.ui.VisibilityComponent;
import com.arsdigita.cms.ui.role.AdminTableModelBuilder;
import com.arsdigita.cms.ui.role.MemberTableModelBuilder;
import com.arsdigita.cms.ui.role.RoleAdminAddForm;
import com.arsdigita.cms.ui.role.RoleFactory;
import com.arsdigita.cms.ui.role.RolePartyAddForm;
import com.arsdigita.cms.ui.role.RoleRequestLocal;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.ModalPanel;
import com.arsdigita.toolbox.ui.PropertyList;
import com.arsdigita.toolbox.ui.Section;
import java.math.BigDecimal;
import java.util.List;
import org.apache.log4j.Logger;

class BaseRoleItemPane
extends BaseItemPane {
    private static final Logger s_log = Logger.getLogger(BaseRoleItemPane.class);
    private final RoleRequestLocal m_role;
    private final SingleSelectionModel m_model;
    private final MemberTable m_members;
    private final AdminTable m_admins;
    private final SimpleContainer m_detailPane;
    private static final String[] s_memberColumns = new String[]{BaseRoleItemPane.lz("cms.ui.name"), BaseRoleItemPane.lz("cms.ui.role.member.email"), BaseRoleItemPane.lz("cms.ui.role.member.remove")};
    private static final String[] s_adminColumns = new String[]{BaseRoleItemPane.lz("cms.ui.name"), BaseRoleItemPane.lz("cms.ui.role.admin.email"), BaseRoleItemPane.lz("cms.ui.role.admin.remove")};

    public BaseRoleItemPane(SingleSelectionModel model, RoleRequestLocal role, ActionLink editLink, ActionLink deleteLink) {
        this.m_model = model;
        this.m_role = role;
        this.m_members = new MemberTable();
        this.m_admins = new AdminTable();
        ActionLink memberAddLink = new ActionLink((Component)new Label(BaseRoleItemPane.gz("cms.ui.role.member.add")));
        ActionLink adminAddLink = new ActionLink((Component)new Label(BaseRoleItemPane.gz("cms.ui.role.admin.add")));
        this.m_detailPane = new SimpleContainer();
        this.add((Component)this.m_detailPane);
        this.setDefault((Component)this.m_detailPane);
        this.m_detailPane.add((Component)new SummarySection(editLink, deleteLink));
        this.m_detailPane.add((Component)new MemberSection(memberAddLink));
        this.m_detailPane.add((Component)new AdminSection(adminAddLink));
        PartySearchForm memberSearchForm = new PartySearchForm();
        this.add((Component)memberSearchForm);
        RolePartyAddForm memberAddForm = new RolePartyAddForm(this.m_model, memberSearchForm.getSearchWidget());
        this.add((Component)memberAddForm);
        PartySearchForm adminSearchForm = new PartySearchForm();
        this.add((Component)adminSearchForm);
        RoleAdminAddForm adminAddForm = new RoleAdminAddForm(this.m_model, adminSearchForm.getSearchWidget());
        this.add((Component)adminAddForm);
        this.connect(memberAddLink, (FormSection)memberSearchForm);
        this.connect((FormSection)memberSearchForm, (Component)memberAddForm);
        memberAddForm.getForm().addSubmissionListener((FormSubmissionListener)new ModalPanel.CancelListener((ModalPanel)this, (FormSection)memberAddForm.getForm()));
        this.resume((FormSection)memberAddForm.getForm(), (Component)this.m_detailPane);
        this.connect(adminAddLink, (FormSection)adminSearchForm);
        this.connect((FormSection)adminSearchForm, (Component)adminAddForm);
        adminAddForm.getForm().addSubmissionListener((FormSubmissionListener)new ModalPanel.CancelListener((ModalPanel)this, (FormSection)adminAddForm.getForm()));
        this.resume((FormSection)adminAddForm.getForm(), (Component)this.m_detailPane);
    }

    private boolean hasAdmin(PageState state) {
        return CMS.getContext().getSecurityManager().canAccess(state.getRequest(), "staff_admin");
    }

    private class AdminTable
    extends Table {
        AdminTable() {
            super((TableModelBuilder)new AdminTableModelBuilder(BaseRoleItemPane.this.m_role), (Object[])s_adminColumns);
            this.setEmptyView((Component)new Label(BaseRoleItemPane.gz("cms.ui.role.admin.none")));
            this.getColumn(2).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(true));
            this.addTableActionListener((TableActionListener)new Listener());
        }

        private class Listener
        extends TableActionAdapter {
            private Listener() {
            }

            public final void cellSelected(TableActionEvent e) {
                PageState state = e.getPageState();
                if (e.getColumn() == 2 && BaseRoleItemPane.this.hasAdmin(state)) {
                    Role role = BaseRoleItemPane.this.m_role.getRole(state);
                    Party party = (Party)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.Party", (Object)new BigDecimal(e.getRowKey().toString())));
                    PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)role.getGroup(), party);
                    PermissionService.revokePermission((PermissionDescriptor)perm);
                    AdminTable.this.getRowSelectionModel().clearSelection(state);
                }
            }
        }
    }

    private class MemberTable
    extends Table {
        MemberTable() {
            super((TableModelBuilder)new MemberTableModelBuilder(BaseRoleItemPane.this.m_role), (Object[])s_memberColumns);
            this.setEmptyView((Component)new Label(BaseRoleItemPane.gz("cms.ui.role.member.none")));
            this.getColumn(2).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(true));
            this.addTableActionListener((TableActionListener)new Listener());
        }

        private class Listener
        extends TableActionAdapter {
            private Listener() {
            }

            public final void cellSelected(TableActionEvent e) {
                PageState state = e.getPageState();
                if (e.getColumn() == 2 && BaseRoleItemPane.this.hasAdmin(state)) {
                    Role role = BaseRoleItemPane.this.m_role.getRole(state);
                    Party party = (Party)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.Party", (Object)new BigDecimal(e.getRowKey().toString())));
                    role.remove(party);
                    role.save();
                    MemberTable.this.getRowSelectionModel().clearSelection(state);
                }
            }
        }
    }

    private class AdminSection
    extends Section {
        AdminSection(ActionLink adminAddLink) {
            this.setHeading(BaseRoleItemPane.gz("cms.ui.role.admins"));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)BaseRoleItemPane.this.m_admins);
            group.addAction((Component)new AdminVisible((Component)adminAddLink), "add");
        }
    }

    private class MemberSection
    extends Section {
        MemberSection(ActionLink memberAddLink) {
            this.setHeading(BaseRoleItemPane.gz("cms.ui.role.members"));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)BaseRoleItemPane.this.m_members);
            group.addAction((Component)new AdminVisible((Component)memberAddLink), "add");
        }
    }

    private class SummarySection
    extends Section {
        SummarySection(ActionLink editLink, ActionLink deleteLink) {
            this.setHeading(BaseRoleItemPane.gz("cms.ui.role.details"));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new Properties());
            group.addAction((Component)new AdminVisible((Component)editLink), "edit");
            group.addAction((Component)new AdminVisible((Component)deleteLink), "delete");
        }

        private class Properties
        extends PropertyList {
            private Properties() {
            }

            protected final List properties(PageState state) {
                List props = super.properties(state);
                Role role = BaseRoleItemPane.this.m_role.getRole(state);
                props.add(new PropertyList.Property(BaseRoleItemPane.lz("cms.ui.name"), role.getName()));
                props.add(new PropertyList.Property(BaseRoleItemPane.lz("cms.ui.description"), role.getDescription()));
                StringBuffer buffer = new StringBuffer();
                ContentSection section = CMS.getContext().getContentSection();
                DataQuery privs = RoleFactory.getRolePrivileges(section.getID(), role.getGroup().getID());
                while (privs.next()) {
                    buffer.append((String)privs.get("prettyName") + ", ");
                }
                privs.close();
                int length = buffer.length();
                if (length > 0) {
                    props.add(new PropertyList.Property(BaseRoleItemPane.lz("cms.ui.role.privileges"), buffer.toString().substring(0, length - 2)));
                } else {
                    props.add(new PropertyList.Property(BaseRoleItemPane.lz("cms.ui.role.privileges"), BaseRoleItemPane.lz("cms.ui.role.privilege.none")));
                }
                return props;
            }
        }
    }

    private class AdminVisible
    extends VisibilityComponent {
        AdminVisible(Component child) {
            super(child, "staff_admin");
        }
    }
}

