/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.BaseAdminPane;
import com.arsdigita.cms.ui.BaseDeleteForm;
import com.arsdigita.cms.ui.VisibilityComponent;
import com.arsdigita.cms.ui.role.BaseRoleItemPane;
import com.arsdigita.cms.ui.role.RoleAddForm;
import com.arsdigita.cms.ui.role.RoleEditForm;
import com.arsdigita.cms.ui.role.RoleListModel;
import com.arsdigita.cms.ui.role.RoleRequestLocal;
import com.arsdigita.kernel.Role;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class RoleAdminPane
extends BaseAdminPane {
    private static final Logger s_log = Logger.getLogger(RoleAdminPane.class);
    private final SingleSelectionModel m_model = new ParameterSingleSelectionModel((ParameterModel)new StringParameter("sel"));
    private final RoleRequestLocal m_role;
    private final List m_staff;
    private final List m_viewers;

    public RoleAdminPane() {
        this.setSelectionModel(this.m_model);
        this.m_model.addChangeListener((ChangeListener)new SelectionListener());
        this.m_role = new SelectionRequestLocal();
        this.m_staff = new List((ListModelBuilder)new StaffListModelBuilder());
        this.m_staff.setSelectionModel(this.m_model);
        this.m_viewers = new List((ListModelBuilder)new ViewerListModelBuilder());
        this.m_viewers.setSelectionModel(this.m_model);
        SimpleContainer left = new SimpleContainer();
        this.setLeft((Component)left);
        StaffSection staff = new StaffSection();
        left.add((Component)staff);
        ViewerSection viewers = new ViewerSection();
        left.add((Component)viewers);
        this.setEdit(RoleAdminPane.gz("cms.ui.role.edit"), new RoleEditForm(this.m_role, false));
        this.setDelete(RoleAdminPane.gz("cms.ui.role.delete"), new DeleteForm());
        this.setIntroPane((Component)new Label(RoleAdminPane.gz("cms.ui.role.intro")));
        this.setItemPane((Component)new BaseRoleItemPane(this.m_model, this.m_role, this.getEditLink(), this.getDeleteLink()));
    }

    private class DeleteForm
    extends BaseDeleteForm {
        DeleteForm() {
            super(DeleteForm.gz("cms.ui.role.delete_prompt"));
            this.addSecurityListener("staff_admin");
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            RoleAdminPane.this.m_role.getRole(state).delete();
            RoleAdminPane.this.m_model.clearSelection(state);
        }
    }

    private static class ViewerListModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private ViewerListModelBuilder() {
        }

        public final ListModel makeModel(List list, PageState state) {
            ContentSection section = CMS.getContext().getContentSection();
            return new RoleListModel(section.getViewersGroup().getOrderedRoles());
        }
    }

    private static class StaffListModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        public final ListModel makeModel(List list, PageState state) {
            ContentSection section = CMS.getContext().getContentSection();
            return new RoleListModel(section.getStaffGroup().getOrderedRoles());
        }
    }

    private class SelectionRequestLocal
    extends RoleRequestLocal {
        private SelectionRequestLocal() {
        }

        protected final Object initialValue(PageState state) {
            String id = RoleAdminPane.this.m_model.getSelectedKey(state).toString();
            return new Role(new BigDecimal(id));
        }
    }

    private class SelectionListener
    implements ChangeListener {
        private SelectionListener() {
        }

        public final void stateChanged(ChangeEvent e) {
            s_log.debug((Object)"Selection state changed; I may change the body's visible pane");
            PageState state = e.getPageState();
            RoleAdminPane.this.getBody().reset(state);
            if (RoleAdminPane.this.m_model.isSelected(state)) {
                s_log.debug((Object)"The selection model is selected; displaying the item pane");
                RoleAdminPane.this.getBody().push(state, RoleAdminPane.this.getItemPane());
            }
        }
    }

    private class ViewerSection
    extends Section {
        ViewerSection() {
            this.setHeading(RoleAdminPane.gz("cms.ui.role.viewers"));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)RoleAdminPane.this.m_viewers);
            ActionLink link = new ActionLink((Component)new Label(RoleAdminPane.gz("cms.ui.role.viewer.add")));
            group.addAction((Component)new VisibilityComponent((Component)link, "staff_admin"), "add");
            RoleAddForm form = new RoleAddForm(RoleAdminPane.this.m_model, true);
            RoleAdminPane.this.getBody().add((Component)form);
            RoleAdminPane.this.getBody().connect(link, (FormSection)form);
        }
    }

    private class StaffSection
    extends Section {
        StaffSection() {
            this.setHeading(RoleAdminPane.gz("cms.ui.role.staff"));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)RoleAdminPane.this.m_staff);
            ActionLink link = new ActionLink((Component)new Label(RoleAdminPane.gz("cms.ui.role.staff.add")));
            group.addAction((Component)new VisibilityComponent((Component)link, "staff_admin"), "add");
            RoleAddForm form = new RoleAddForm(RoleAdminPane.this.m_model, false);
            RoleAdminPane.this.getBody().add((Component)form);
            RoleAdminPane.this.getBody().connect(link, (FormSection)form);
        }
    }
}

