/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.cms.ui.FormSecurityListener;
import com.arsdigita.cms.ui.PartyAddForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Role;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class RolePartyAddForm
extends PartyAddForm {
    private static Logger s_log = Logger.getLogger(RolePartyAddForm.class);
    private SingleSelectionModel m_roles;
    private static final String NAME_FILTER = "(upper(name) like ('%' || upper(:search) || '%')) or (upper(email) like ('%' || upper(:search) || '%'))";

    public RolePartyAddForm(SingleSelectionModel roles, TextField search) {
        super((Widget)search);
        this.m_roles = roles;
        this.getForm().addSubmissionListener((FormSubmissionListener)new FormSecurityListener("staff_admin"));
    }

    @Override
    protected DataQuery makeQuery(PageState s) {
        Assert.isTrue((boolean)this.m_roles.isSelected(s));
        Session session = SessionManager.getSession();
        DataQuery dq = session.retrieveQuery("com.arsdigita.cms.searchToAddMemberParties");
        BigDecimal roleId = new BigDecimal((String)this.m_roles.getSelectedKey(s));
        String searchQuery = (String)this.getSearchWidget().getValue(s);
        this.makeFilter(dq, roleId, searchQuery);
        dq.addOrder("isUser desc, upper(name), upper(email)");
        return dq;
    }

    private void makeFilter(DataQuery dq, BigDecimal roleId, String search) {
        dq.setParameter("excludedRoleId", (Object)roleId);
        if (search != null) {
            dq.clearFilter();
            Filter filter = dq.addFilter(NAME_FILTER);
            filter.set("search", (Object)search);
        }
    }

    @Override
    public void process(FormSectionEvent event) throws FormProcessException {
        FormData data = event.getFormData();
        PageState state = event.getPageState();
        Assert.isTrue((boolean)this.m_roles.isSelected(state));
        String[] parties = (String[])data.get((Object)"parties");
        s_log.debug((Object)("PARTIES = " + parties));
        if (parties == null) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.role.no_party_selected").localize());
        }
        BigDecimal roleId = new BigDecimal((String)this.m_roles.getSelectedKey(state));
        Role role = new Role(roleId);
        for (int i = 0; i < parties.length; ++i) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("parties[" + i + "] = " + parties[i]));
            }
            Party party = (Party)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.Party", (Object)new BigDecimal(parties[i])));
            role.add(party);
        }
        role.save();
    }
}

