/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.search;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.search.ContentTypeFilterSpecification;
import com.arsdigita.cms.search.ContentTypeFilterType;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.Search;
import com.arsdigita.search.ui.FilterWidget;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public class ContentTypeFilterWidget
extends FilterWidget {
    private ContentType m_parentType = null;
    private ContentSection m_section = null;
    private ContentType[] m_types = null;

    public ContentTypeFilterWidget(ContentTypeCollection types) {
        super((FilterType)new ContentTypeFilterType(), (ParameterModel)new ArrayParameter((ParameterModel)new StringParameter("contentType")));
        this.m_types = new ContentType[(int)types.size()];
        int i = 0;
        while (types.next()) {
            this.m_types[i++] = types.getContentType();
        }
    }

    public ContentTypeFilterWidget(ContentSection section) {
        this(section.getContentTypes());
    }

    public ContentTypeFilterWidget(ContentSection section, ContentType parentType) {
        this(section.getDescendantsOfContentType(parentType));
        this.m_section = section;
        this.m_parentType = parentType;
    }

    public ContentTypeFilterWidget(ContentType parentType) {
        this(ContentType.getDescendantsOf(parentType));
        this.m_parentType = parentType;
    }

    public ContentTypeFilterWidget() {
        this(ContentType.getRegisteredContentTypes());
    }

    protected ContentSection getContentSection() {
        return this.m_section;
    }

    private ContentType getParentType(PageState state) {
        ContentType ct = this.m_parentType;
        BigDecimal singleTypeID = (BigDecimal)state.getValue((ParameterModel)new BigDecimalParameter("single_type"));
        if (singleTypeID != null) {
            try {
                ct = new ContentType(singleTypeID);
            }
            catch (DataObjectNotFoundException ex) {
                ct = null;
            }
        }
        return ct;
    }

    protected ContentType[] getContentTypes(PageState state) {
        ContentType parentType = this.getParentType(state);
        ContentTypeCollection typesCollection = null;
        ContentType[] typesArray = (ContentType[])this.m_types.clone();
        if (this.getContentSection() != this.m_section || parentType != this.m_parentType) {
            if (this.getContentSection() != null) {
                ContentSection section = this.getContentSection();
                typesCollection = parentType == null ? section.getContentTypes() : section.getDescendantsOfContentType(parentType);
            } else {
                typesCollection = parentType == null ? ContentType.getRegisteredContentTypes() : ContentType.getDescendantsOf(parentType);
            }
            typesArray = new ContentType[(int)typesCollection.size()];
            int i = 0;
            while (typesCollection.next()) {
                typesArray[i++] = typesCollection.getContentType();
            }
        }
        return typesArray;
    }

    public FilterSpecification getFilter(PageState state) {
        String[] types = (String[])this.getValue(state);
        if (types == null) {
            if (this.getParentType(state) == null) {
                types = new String[]{};
            } else {
                ContentType[] widgetTypes = this.getContentTypes(state);
                types = new String[widgetTypes.length];
                for (int i = 0; i < widgetTypes.length; ++i) {
                    types[i] = widgetTypes[i].getAssociatedObjectType();
                }
            }
        }
        return new ContentTypeFilterSpecification(types);
    }

    public void generateBodyXML(PageState state, Element parent) {
        super.generateBodyXML(state, parent);
        String[] types = (String[])this.getValue(state);
        if (types == null) {
            types = new String[]{};
        }
        ContentType[] widgetTypes = this.getContentTypes(state);
        for (int i = 0; i < widgetTypes.length; ++i) {
            Element type = Search.newElement((String)"contentType");
            type.addAttribute("name", widgetTypes[i].getAssociatedObjectType());
            type.addAttribute("title", widgetTypes[i].getLabel());
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equals(widgetTypes[i].getAssociatedObjectType())) continue;
                type.addAttribute("isSelected", "1");
                break;
            }
            parent.addContent(type);
        }
    }
}

