/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.search;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.search.CreationDateFilterType;
import com.arsdigita.cms.search.CreationUserFilterType;
import com.arsdigita.cms.search.LastModifiedDateFilterType;
import com.arsdigita.cms.search.LastModifiedUserFilterType;
import com.arsdigita.cms.search.LaunchDateFilterType;
import com.arsdigita.cms.ui.ContentSectionPage;
import com.arsdigita.cms.ui.search.ContentSectionFilterComponent;
import com.arsdigita.cms.ui.search.ContentTypeFilterWidget;
import com.arsdigita.cms.ui.search.VersionFilterComponent;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.Search;
import com.arsdigita.search.ui.BaseQueryComponent;
import com.arsdigita.search.ui.filters.DateRangeFilterWidget;
import com.arsdigita.search.ui.filters.PartyFilterWidget;
import com.arsdigita.search.ui.filters.PermissionFilterComponent;
import com.arsdigita.search.ui.filters.SimpleCategoryFilterWidget;
import java.util.ArrayList;

public class ItemQueryComponent
extends BaseQueryComponent {
    private String m_context;

    public ItemQueryComponent(String context, boolean limitToContentSection) {
        this(context, limitToContentSection, null);
    }

    public ItemQueryComponent(String context, final boolean limitToContentSection, ContentType type) {
        this.m_context = context;
        if (Search.getConfig().isIntermediaEnabled()) {
            this.add((Component)new LaunchDateFilterWidget(new LaunchDateFilterType(), "launchDate"));
        }
        if (Search.getConfig().isIntermediaEnabled() || Search.getConfig().isLuceneEnabled()) {
            this.add((Component)new PermissionFilterComponent("cms_preview_item"));
            this.add((Component)new SimpleCategoryFilterWidget(){

                protected Category[] getRoots(PageState state) {
                    Category[] roots;
                    if (limitToContentSection && CMS.getContext().hasContentSection()) {
                        ContentSection section = CMS.getContext().getContentSection();
                        roots = new Category[]{section.getRootCategory()};
                    } else {
                        ContentSectionCollection sections = ContentSection.getAllSections();
                        ArrayList<Category> cats = new ArrayList<Category>();
                        while (sections.next()) {
                            ContentSection section = sections.getContentSection();
                            cats.add(section.getRootCategory());
                        }
                        roots = cats.toArray(new Category[cats.size()]);
                    }
                    return roots;
                }
            });
            if (type == null) {
                this.add((Component)new ContentTypeFilterWidget(){

                    @Override
                    protected ContentSection getContentSection() {
                        if (limitToContentSection && CMS.getContext().hasContentSection()) {
                            return CMS.getContext().getContentSection();
                        }
                        return super.getContentSection();
                    }
                });
            } else {
                this.add((Component)new ContentTypeFilterWidget(type){

                    @Override
                    protected ContentSection getContentSection() {
                        if (limitToContentSection && CMS.getContext().hasContentSection()) {
                            return CMS.getContext().getContentSection();
                        }
                        return super.getContentSection();
                    }
                });
            }
            this.add((Component)new VersionFilterComponent(context));
            if (limitToContentSection) {
                this.add((Component)new ContentSectionFilterComponent());
            }
            this.add((Component)new DateRangeFilterWidget((FilterType)new LastModifiedDateFilterType(), "lastModifiedDate"));
            this.add((Component)new DateRangeFilterWidget((FilterType)new CreationDateFilterType(), "creationDate"));
            this.add((Component)new PartyFilterWidget((FilterType)new CreationUserFilterType(), "creationUser"));
            this.add((Component)new PartyFilterWidget((FilterType)new LastModifiedUserFilterType(), "lastModifiedUser"));
        }
        Submit submit = new Submit(this.m_context + "_search", ContentSectionPage.globalize("cms.ui.search"));
        this.add((Component)submit);
    }

    private class LaunchDateFilterWidget
    extends DateRangeFilterWidget {
        public LaunchDateFilterWidget(FilterType type, String name) {
            super(type, name);
        }

        public boolean isVisible(PageState state) {
            return !ContentSection.getConfig().getHideLaunchDate() && super.isVisible(state);
        }
    }
}

