/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.staff;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.toolbox.ui.DataQueryListModelBuilder;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public class PartyInfo
extends SimpleContainer {
    private final SingleSelectionModel m_parties;
    private List m_partyRoles;
    private ActionLink m_back;
    private boolean m_useViewersGroup;

    public PartyInfo(SingleSelectionModel parties) {
        this(parties, false);
    }

    public PartyInfo(SingleSelectionModel parties, boolean useViewersGroup) {
        this.m_parties = parties;
        this.m_useViewersGroup = useViewersGroup;
        this.m_partyRoles = new List((ListModelBuilder)new RolesListModelBuilder());
        this.m_partyRoles.setIdAttr("party_roles_list");
        this.m_partyRoles.setCellRenderer((ListCellRenderer)new CellRenderer());
        this.add((Component)this.m_partyRoles);
        this.m_back = new ActionLink((String)GlobalizationUtil.globalize("cms.ui.staff.back").localize());
        this.m_back.setClassAttr("actionLink");
        this.m_back.setIdAttr("back_link");
        this.m_back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                PartyInfo.this.m_parties.clearSelection(state);
            }
        });
        this.add((Component)this.m_back);
    }

    protected List getList() {
        return this.m_partyRoles;
    }

    protected ActionLink getBackLink() {
        return this.m_back;
    }

    protected BigDecimal getPartyId(PageState state) {
        Assert.isTrue((boolean)this.m_parties.isSelected(state));
        String partyId = (String)this.m_parties.getSelectedKey(state);
        return new BigDecimal(partyId);
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            Party party = null;
            try {
                party = (Party)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.Party", (Object)this.getPartyId(state)));
            }
            catch (DataObjectNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            Element element = new Element("cms:roleMemberInfo", "http://www.arsdigita.com/cms/1.0");
            element.addAttribute("party_id", party.getID().toString());
            element.addAttribute("partyType", party instanceof Group ? "group" : "person");
            element.addAttribute("name", party.getName());
            String email = party.getPrimaryEmail() == null ? "no email address" : party.getPrimaryEmail().getEmailAddress();
            element.addAttribute("email", email);
            this.m_partyRoles.generateXML(state, element);
            this.m_back.generateXML(state, element);
            parent.addContent(element);
        }
    }

    private class RolesListModelBuilder
    extends DataQueryListModelBuilder {
        private static final String KEY_NAME = "groupId";
        private static final String VALUE_NAME = "name";
        private static final String QUERY_NAME = "com.arsdigita.cms.getUserStaffRoles";
        private static final String VIEWERS_QUERY_NAME = "com.arsdigita.cms.getUserViewerRoles";
        private static final String GROUP_QUERY_NAME = "com.arsdigita.cms.getGroupStaffRoles";
        private static final String GROUP_VIEWERS_QUERY_NAME = "com.arsdigita.cms.getGroupViewerRoles";
        private static final String SECTION_ID = "sectionId";
        private static final String USER_ID = "userId";
        private static final String GROUP_ID = "subgroupId";
        private static final String FILTER = "sectionId = :sectionId and userId = :userId";
        private static final String GROUP_FILTER = "sectionId = :sectionId and subgroupId = :subgroupId";

        protected RolesListModelBuilder() {
            super(KEY_NAME, VALUE_NAME);
        }

        protected DataQuery getDataQuery(PageState ps) {
            Filter filter;
            DataQuery query;
            ContentSection section = CMS.getContext().getContentSection();
            BigDecimal partyId = new BigDecimal((String)PartyInfo.this.m_parties.getSelectedKey(ps));
            Party party = null;
            try {
                party = (Party)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.Party", (Object)partyId));
            }
            catch (DataObjectNotFoundException e) {
                e.printStackTrace();
            }
            if (party instanceof Group) {
                query = PartyInfo.this.m_useViewersGroup ? SessionManager.getSession().retrieveQuery(GROUP_VIEWERS_QUERY_NAME) : SessionManager.getSession().retrieveQuery(GROUP_QUERY_NAME);
                filter = query.addFilter(GROUP_FILTER);
                filter.set(GROUP_ID, (Object)partyId);
            } else {
                query = PartyInfo.this.m_useViewersGroup ? SessionManager.getSession().retrieveQuery(VIEWERS_QUERY_NAME) : SessionManager.getSession().retrieveQuery(QUERY_NAME);
                filter = query.addFilter(FILTER);
                filter.set(USER_ID, (Object)partyId);
            }
            filter.set(SECTION_ID, (Object)section.getID());
            query.addOrder(VALUE_NAME);
            return query;
        }
    }

    private class CellRenderer
    implements ListCellRenderer {
        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            SimpleContainer container = new SimpleContainer();
            Label roleName = new Label(value.toString());
            container.add((Component)roleName);
            return container;
        }
    }
}

