/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.templates;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.CategoryTemplateMapping;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionServlet;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.SectionTemplateMapping;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateCollection;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.FormSecurityListener;
import com.arsdigita.cms.ui.category.CategoryComponentAccess;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.ui.templates.CategoryTemplatesListing;
import com.arsdigita.cms.ui.templates.TemplatesListing;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.TooManyListenersException;

public class CategoryTemplates
extends CMSContainer {
    private CategoryRequestLocal m_category;
    private ACSObjectSelectionModel m_types;
    private SingleSelectionModel m_contexts;
    private CMSContainer m_display;
    private CMSContainer m_assign;
    public static final String ASSIGN_TEMPLATE = "assignTemplate";

    public CategoryTemplates(CategoryRequestLocal category) {
        this.m_category = category;
        this.m_types = new ACSObjectSelectionModel(new BigDecimalParameter("t"));
        this.m_contexts = new ParameterSingleSelectionModel((ParameterModel)new StringParameter("c"));
        AssignForm form = new AssignForm("assign", this.m_types, this.m_contexts);
        form.addSubmissionListener(new FormSecurityListener("category_admin"));
        form.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                CategoryTemplates.this.m_display.setVisible(state, false);
                CategoryTemplates.this.m_assign.setVisible(state, true);
            }
        });
        CategoryTemplatesListingImpl l = new CategoryTemplatesListingImpl(category);
        SegmentedPanel st = new SegmentedPanel();
        st.addSegment((Component)new Label("Assigned Templates"), (Component)l);
        this.m_display = new CMSContainer();
        this.m_display.add((Component)form);
        this.m_display.add((Component)st);
        this.add((Component)this.m_display);
        SegmentedPanel sa = new SegmentedPanel();
        Label assignLabel = new Label("dummy");
        assignLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label targetLabel = (Label)e.getTarget();
                Category category = CategoryTemplates.this.m_category.getCategory(s);
                Assert.exists((Object)category, (String)"category");
                targetLabel.setLabel("Assign a template to " + category.getName());
            }
        });
        sa.addSegment((Component)assignLabel, (Component)new AvailableTemplatesListing(this.m_category, this.m_types, this.m_contexts));
        ActionLink returnLink = new ActionLink("Return to template listing");
        returnLink.setClassAttr("actionLink");
        returnLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                CategoryTemplates.this.m_display.setVisible(s, true);
                CategoryTemplates.this.m_assign.setVisible(s, false);
            }
        });
        this.m_assign = new CMSContainer();
        this.m_assign.add((Component)sa);
        this.m_assign.add((Component)returnLink);
        this.add((Component)this.m_assign);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_assign, false);
        p.addComponentStateParam((Component)this, this.m_types.getStateParameter());
        p.addComponentStateParam((Component)this, this.m_contexts.getStateParameter());
    }

    private class AssignForm
    extends Form {
        SingleSelect m_type;
        Hidden m_context;

        public AssignForm(String name, ACSObjectSelectionModel type, SingleSelectionModel context) {
            super(name, (Container)new GridPanel(3));
            this.add((Component)new Label("Content type:"));
            this.m_type = new SingleSelect(type.getStateParameter());
            try {
                this.m_type.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent e) {
                        PageState state = e.getPageState();
                        ContentSection section = ContentSectionServlet.getContentSection(state.getRequest());
                        SingleSelect target = (SingleSelect)e.getTarget();
                        ContentTypeCollection types = section.getContentTypes();
                        types.addOrder("label");
                        while (types.next()) {
                            ContentType type = types.getContentType();
                            target.addOption(new Option(type.getID().toString(), type.getLabel()));
                        }
                    }
                });
            }
            catch (TooManyListenersException ex) {
                throw new UncheckedWrapperException("This can never happen", (Throwable)ex);
            }
            this.add((Component)this.m_type);
            this.m_context = new Hidden(context.getStateParameter());
            this.m_context.setDefaultValue((Object)"public");
            this.add((Component)this.m_context);
            this.add((Component)new Submit("Assign template"));
        }
    }

    protected class AvailableTemplatesListing
    extends TemplatesListing {
        TableColumn m_assignCol;
        ACSObjectSelectionModel m_type;
        CategoryRequestLocal m_category;
        SingleSelectionModel m_context;

        public AvailableTemplatesListing(CategoryRequestLocal category, ACSObjectSelectionModel type, SingleSelectionModel context) {
            this.m_type = type;
            this.m_category = category;
            this.m_context = context;
            this.m_assignCol = this.addColumn("Assign", "template", false, new AssignCellRenderer());
            this.addTableActionListener((TableActionListener)new TableActionAdapter(){

                public void cellSelected(TableActionEvent e) {
                    PageState s = e.getPageState();
                    TemplatesListing l = (TemplatesListing)((Object)e.getSource());
                    int i = e.getColumn();
                    TableColumn c = l.getColumnModel().get(i);
                    if (c == AvailableTemplatesListing.this.m_assignCol) {
                        SectionTemplateMapping m = (SectionTemplateMapping)AvailableTemplatesListing.this.getMappingModel().getSelectedObject(s);
                        AvailableTemplatesListing.this.assignTemplate(s, m.getTemplate());
                    }
                }
            });
        }

        @Override
        protected TemplateCollection getTemplateCollection(PageState s) {
            ContentSection sec = ContentSectionServlet.getContentSection(s.getRequest());
            Assert.exists((Object)((Object)sec), (String)"content section");
            ContentType type = this.getContentType(s);
            TemplateCollection c = TemplateManagerFactory.getInstance().getTemplates(sec, type);
            return c;
        }

        protected ContentType getContentType(PageState s) {
            ContentType type = (ContentType)this.m_type.getSelectedObject(s);
            Assert.exists((Object)((Object)type), (String)"content type");
            return type;
        }

        public void assignTemplate(PageState s, Template t) {
            String useContext;
            ContentType type;
            Category category = this.m_category.getCategory(s);
            CategoryTemplateMapping map = CategoryTemplateMapping.getMapping(category, type = (ContentType)this.m_type.getSelectedObject(s), t, useContext = (String)this.m_context.getSelectedKey(s));
            if (map == null) {
                map = new CategoryTemplateMapping();
                map.setCategory(category);
                map.setContentType(type);
                map.setUseContext(useContext);
                map.setTemplate(t);
            }
            map.setContentSection(ContentSectionServlet.getContentSection(s.getRequest()));
            map.save();
            CategoryTemplates.this.m_display.setVisible(s, true);
            CategoryTemplates.this.m_assign.setVisible(s, false);
        }

        protected class AssignCellRenderer
        implements TableCellRenderer {
            private ControlLink m_link = new ControlLink("Assign this template");

            public AssignCellRenderer() {
                this.m_link.setClassAttr("assignTemplateLink");
            }

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                return this.m_link;
            }
        }
    }

    protected class CategoryTemplatesListingImpl
    extends CategoryTemplatesListing {
        private CategoryComponentAccess m_access;

        public CategoryTemplatesListingImpl(CategoryRequestLocal category) {
            super(category);
            this.m_access = new CategoryComponentAccess(null, category);
        }

        public void assignLinkClicked(PageState s, Category category, String useContext) {
        }

        public void register(Page p) {
            super.register(p);
            p.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageState state = e.getPageState();
                    if (state.isVisibleOnPage((Component)CategoryTemplates.this) && !CategoryTemplatesListingImpl.this.m_access.canAccess(state, CMS.getContext().getSecurityManager())) {
                        CategoryTemplatesListingImpl.this.getRemoveColumn().setVisible(state, false);
                    }
                }
            });
        }
    }
}

