/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.templates;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateCollection;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.TemplateMapping;
import com.arsdigita.cms.ui.ContentSectionRequestLocal;
import com.arsdigita.cms.ui.templates.TemplatesListing;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import org.apache.log4j.Logger;

public class SectionTemplatesListing
extends TemplatesListing {
    private static final Logger s_log = Logger.getLogger(SectionTemplatesListing.class);
    private final TableColumn m_defaultCol;
    private final ContentSectionRequestLocal m_section;
    private final ContentTypeRequestLocal m_type;

    public SectionTemplatesListing(ContentSectionRequestLocal section, ContentTypeRequestLocal type) {
        this.m_section = section;
        this.m_type = type;
        this.m_defaultCol = this.addColumn("Default", "isDefault", false, new DefaultCellRenderer());
        this.addTableActionListener((TableActionListener)new TableActionAdapter(){

            public void cellSelected(TableActionEvent e) {
                PageState s = e.getPageState();
                TemplatesListing l = (TemplatesListing)((Object)e.getSource());
                int i = e.getColumn();
                TableColumn c = l.getColumnModel().get(i);
                if (c == SectionTemplatesListing.this.m_defaultCol) {
                    SectionTemplatesListing.this.setDefaultTemplate(s, (TemplateMapping)SectionTemplatesListing.this.getMappingModel().getSelectedObject(s));
                }
            }
        });
        this.addRemoveColumn();
    }

    public TableColumn getDefaultColumn() {
        return this.m_defaultCol;
    }

    @Override
    protected TemplateCollection getTemplateCollection(PageState state) {
        ContentSection section = this.m_section.getContentSection(state);
        ContentType type = this.m_type.getContentType(state);
        return TemplateManagerFactory.getInstance().getTemplates(section, type);
    }

    @Override
    protected void removeTemplate(PageState s, TemplateMapping m) {
        Template t = m.getTemplate();
        TemplateManagerFactory.getInstance().removeTemplate(m.getContentSection(), (ContentType)m.getParent(), t, m.getUseContext());
        t.unpublish();
        t.delete();
    }

    protected void setDefaultTemplate(PageState s, TemplateMapping m) {
        TemplateManagerFactory.getInstance().setDefaultTemplate(m.getContentSection(), (ContentType)m.getParent(), m.getTemplate(), m.getUseContext());
    }

    protected static class DefaultCellRenderer
    implements TableCellRenderer {
        private ControlLink m_link = new ControlLink((Component)new Label(GlobalizationUtil.globalize("cms.ui.templates.set_as_default")));
        private Label m_label;

        public DefaultCellRenderer() {
            this.m_link.setClassAttr("setDefaultLink");
            this.m_label = new Label(GlobalizationUtil.globalize("cms.ui.templates.default"));
            this.m_label.setFontWeight("b");
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (((Boolean)value).booleanValue()) {
                return this.m_label;
            }
            return this.m_link;
        }
    }
}

