/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.templates;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.ui.FileUploadSection;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.TextAssetBody;
import com.arsdigita.cms.ui.authoring.TextAssetBodyLabelCellRenderer;
import com.arsdigita.cms.ui.authoring.TextAssetBodyPropertySheet;
import com.arsdigita.cms.ui.authoring.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.xml.Document;
import java.util.Map;
import org.apache.log4j.Logger;

public class TemplateBody
extends TextAssetBody {
    private static final Logger s_log = Logger.getLogger(TemplateBody.class);
    private AuthoringKitWizard m_parent;

    public TemplateBody(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel);
        this.m_parent = parent;
        parent.getList().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                TemplateBody.this.reset(state);
            }
        });
        Component f = this.getComponent("file");
        if (f != null) {
            this.setComponentAccess("file", new WorkflowLockedComponentAccess(f, itemModel));
        }
        Component t = this.getComponent("text");
        this.setComponentAccess("text", new WorkflowLockedComponentAccess(t, itemModel));
    }

    @Override
    protected DomainObjectPropertySheet getBodyPropertySheet(ItemSelectionModel assetModel) {
        TextAssetBodyPropertySheet sheet = new TextAssetBodyPropertySheet((DomainObjectSelectionModel)assetModel);
        sheet.getColumn(1).setCellRenderer((TableCellRenderer)new TemplateLabelCellRenderer());
        return sheet;
    }

    @Override
    protected TextAsset createTextAsset(PageState s) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void updateTextAsset(PageState s, TextAsset a) {
    }

    @Override
    protected void setMimeTypeOptions(SingleSelect mimeSelect) {
        Map mimeTypes = Template.SUPPORTED_MIME_TYPES;
        for (String key : mimeTypes.keySet()) {
            mimeSelect.addOption(new Option(key, (Component)new Label((GlobalizedMessage)mimeTypes.get(key))));
        }
    }

    @Override
    protected void addTextWidgets(TextAssetBody.PageTextForm c) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding text widgets to " + (Object)((Object)c)));
        }
        ColumnPanel panel = (ColumnPanel)c.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        c.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.text_type")));
        SingleSelect mime = new SingleSelect("mime_type");
        c.add((Component)mime, 1);
        c.setMimeWidget(mime);
        this.setMimeTypeOptions(mime);
        mime.setClassAttr("displayOneOptionAsLabel");
        c.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.edit_body_text")), 65);
        TextArea text = new TextArea("text_entry");
        c.add((Component)text, 65);
        c.setTextWidget(text);
        text.setRows(10);
        text.setCols(50);
        text.setWrap(2);
        SaveCancelSection saveCancel = new SaveCancelSection();
        c.add((Component)saveCancel);
        c.setSaveCancel(saveCancel);
        c.addInitListener(c);
        c.addProcessListener(c);
    }

    @Override
    protected void addFileWidgets(TextAssetBody.PageFileForm c) {
        super.addFileWidgets(c);
        FileUploadSection uploadSection = c.getFileUploadSection();
        SingleSelect mimeWidget = uploadSection.getMimeTypeWidget();
        mimeWidget.clearOptions();
        this.setMimeTypeOptions(mimeWidget);
        mimeWidget.setDefaultValue((Object)"-guess-");
        mimeWidget.addOption(new Option("-guess-", (Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.file_upload.auto_detect"))));
    }

    @Override
    protected TextAssetBody.PageFileForm getPageFileForm() {
        return new TemplateFileForm();
    }

    @Override
    protected String getDefaultMimeType() {
        return "text/x-jsp";
    }

    protected class TemplateLabelCellRenderer
    extends TextAssetBodyLabelCellRenderer {
        protected TemplateLabelCellRenderer() {
        }

        @Override
        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            GlobalizedMessage mimeTypeMessage;
            MimeType type;
            Object label = null;
            if ("mimeType.label".equals(key) && value instanceof TextAsset && (type = ((TextAsset)value).getMimeType()) != null && (mimeTypeMessage = (GlobalizedMessage)Template.SUPPORTED_MIME_TYPES.get(type.getMimeType())) != null) {
                return new Label(mimeTypeMessage, false);
            }
            return super.getComponent(table, state, value, isSelected, key, row, column);
        }
    }

    protected class TemplateFileForm
    extends TextAssetBody.PageFileForm {
        protected TemplateFileForm() {
        }

        @Override
        public void validate(FormSectionEvent e) throws FormProcessException {
            super.validate(e);
            FileUploadSection section = this.getFileUploadSection();
            MimeType mime = section.getMimeType(e);
            String mimeType = mime.getMimeType();
            if (!Template.SUPPORTED_MIME_TYPES.keySet().contains(mimeType)) {
                throw new FormProcessException("The mime type " + mimeType + "is not one of the " + "supported Template Mime Types");
            }
            if ("text/xml".equals(mimeType)) {
                String content = this.getFileUploadContent(e.getPageState());
                try {
                    new Document(content);
                }
                catch (Exception ex) {
                    throw new FormProcessException("The uploaded file is not properly formatted XML: " + ex.getMessage());
                }
            }
        }
    }
}

