/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.templates;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateContext;
import com.arsdigita.cms.TemplateContextCollection;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.db.Sequences;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.TooManyListenersException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TemplateCreate
extends BasicItemForm {
    private static Logger s_log = Logger.getLogger(TemplateCreate.class);
    private final ACSObjectSelectionModel m_typeModel;
    private static final String USE_CONTEXT = "use_ctx";
    private static final String ITEM_ID = "item_id";

    public TemplateCreate(ACSObjectSelectionModel typeModel) {
        super("templateCreate", null);
        this.m_typeModel = typeModel;
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.templates.use_context"), false));
        SingleSelect ctxWidget = new SingleSelect((ParameterModel)new StringParameter(USE_CONTEXT));
        ctxWidget.setDefaultValue((Object)"public");
        try {
            ctxWidget.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState state = e.getPageState();
                    SingleSelect target = (SingleSelect)e.getTarget();
                    TemplateContextCollection contexts = TemplateContext.retrieveAll();
                    contexts.addOrder("label");
                    while (contexts.next()) {
                        TemplateContext type = contexts.getTemplateContext();
                        target.addOption(new Option(type.getContext(), type.getLabel()));
                    }
                }
            });
        }
        catch (TooManyListenersException ex) {
            throw new UncheckedWrapperException("This can never happen", (Throwable)ex);
        }
        ctxWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)ctxWidget);
        Hidden idWidget = new Hidden((ParameterModel)new BigDecimalParameter(ITEM_ID));
        this.add((Component)idWidget);
    }

    @Override
    public void init(FormSectionEvent e) throws FormProcessException {
        FormData d = e.getFormData();
        try {
            BigDecimal id = Sequences.getNextValue();
            d.put((Object)ITEM_ID, (Object)id);
        }
        catch (SQLException ex) {
            s_log.error((Object)"Error retrieving the sequence value", (Throwable)ex);
            throw new FormProcessException(ex.getMessage());
        }
    }

    @Override
    public void validate(FormSectionEvent e) throws FormProcessException {
        ContentSection section = CMS.getContext().getContentSection();
        Folder folder = section.getTemplatesFolder();
        Assert.exists((Object)folder, Folder.class);
        this.validateNameUniqueness(folder, e);
    }

    @Override
    public void process(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        FormData d = e.getFormData();
        BigDecimal id = (BigDecimal)d.get((Object)ITEM_ID);
        ContentSection sec = CMS.getContext().getContentSection();
        ContentType type = (ContentType)this.m_typeModel.getSelectedObject(s);
        Assert.exists((Object)((Object)type), ContentType.class);
        Template t = new Template(SessionManager.getSession().create(new OID("com.arsdigita.cms.Template", (Object)id)));
        t.setName((String)d.get((Object)"name"));
        t.setLabel((String)d.get((Object)"title"));
        t.setText("Template body goes here");
        t.setParent((ACSObject)sec.getTemplatesFolder());
        t.setContentSection(sec);
        t.save();
        TemplateManagerFactory.getInstance().addTemplate(sec, type, t, (String)d.get((Object)USE_CONTEXT));
        String pageURL = ContentItemPage.getItemURL(sec.getPath() + "/", t.getID(), ContentItemPage.AUTHORING_TAB);
        throw new RedirectSignal(URL.there((HttpServletRequest)s.getRequest(), (String)pageURL), true);
    }
}

