/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.ui.type.ElementAddForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentHidden;
import com.arsdigita.formbuilder.PersistentSingleSelect;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class AddContentItemElement
extends ElementAddForm {
    private static final Logger s_log = Logger.getLogger(AddContentItemElement.class);
    private SingleSelect m_itemTypeSelect;

    public AddContentItemElement(ACSObjectSelectionModel types) {
        super("ContentTypeAddContentItemElement", "Add a ContentItem Element", types);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.association_content_type")));
        this.m_itemTypeSelect = new SingleSelect((ParameterModel)new BigDecimalParameter("AddContentItemTypeSelect"));
        try {
            this.m_itemTypeSelect.addPrintListener((PrintListener)new ItemTypeSelectPrintListener());
        }
        catch (TooManyListenersException ex) {
            s_log.error((Object)"too many listeners", (Throwable)ex);
            throw new UncheckedWrapperException((Throwable)ex);
        }
        this.add((Component)this.m_itemTypeSelect);
        this.add((Component)this.m_buttons, 66);
    }

    private ContentType getItemType(PageState state) throws FormProcessException {
        BigDecimal itemTypeID = (BigDecimal)this.m_itemTypeSelect.getValue(state);
        ContentType itemType = null;
        Assert.exists((Object)itemTypeID, (String)"itemTypeID");
        try {
            itemType = new ContentType(itemTypeID);
        }
        catch (DataObjectNotFoundException ex) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.type.invalid").localize());
        }
        return itemType;
    }

    @Override
    protected final void addAttribute(DynamicObjectType dot, String label, PageState state) throws FormProcessException {
        ContentType itemType = this.getItemType(state);
        dot.addOptionalAssociation(label, MetadataRoot.getMetadataRoot().getObjectType(itemType.getAssociatedObjectType()));
    }

    @Override
    protected final void addFormComponent(PersistentForm pForm, String label, PageState state) throws FormProcessException {
        ContentType itemType = this.getItemType(state);
        PersistentHidden pContentTypeName = PersistentHidden.create((String)(label + "Type"));
        pContentTypeName.setDefaultValue((Object)itemType.getAssociatedObjectType());
        pContentTypeName.save();
        pForm.addComponent((PersistentComponent)pContentTypeName);
        PersistentSingleSelect pSelect = PersistentSingleSelect.create((String)label);
        pSelect.setParameterModel("com.arsdigita.bebop.parameters.BigDecimalParameter");
        pSelect.save();
        pForm.addComponent((PersistentComponent)pSelect);
    }

    private class ItemTypeSelectPrintListener
    implements PrintListener {
        private ItemTypeSelectPrintListener() {
        }

        public void prepare(PrintEvent event) {
            SingleSelect t = (SingleSelect)event.getTarget();
            ContentSection section = CMS.getContext().getContentSection();
            ContentTypeCollection contentTypes = section.getCreatableContentTypes(true);
            contentTypes.addOrder("label");
            while (contentTypes.next()) {
                ContentType type = contentTypes.getContentType();
                t.addOption(new Option(type.getID().toString(), type.getLabel()));
            }
        }
    }
}

