/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ui.type.ElementAddForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentDate;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.metadata.MetadataRoot;
import java.util.Date;

public class AddDateElement
extends ElementAddForm {
    private com.arsdigita.bebop.form.Date m_date;
    private CheckboxGroup m_valReq;
    private TextField m_fromYear;
    private TextField m_toYear;

    public AddDateElement(ACSObjectSelectionModel types) {
        super("ContentTypeAddDateElement", "Add a Date Element", types);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.default_date")));
        this.m_date = new com.arsdigita.bebop.form.Date("elementdate");
        long cur = System.currentTimeMillis();
        Date curtime = new Date(cur);
        this.m_date.setDefaultValue((Object)curtime);
        this.m_date.setClassAttr("AddDateElementChooseDate");
        this.add((Component)this.m_date);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.year_range")));
        this.m_fromYear = new TextField((ParameterModel)new IntegerParameter("fromYear"));
        this.m_fromYear.setSize(6);
        this.m_fromYear.setMaxLength(4);
        this.m_toYear = new TextField((ParameterModel)new IntegerParameter("toYear"));
        this.m_toYear.setSize(6);
        this.m_toYear.setMaxLength(4);
        FormSection rangeSec = new FormSection((Container)new BoxPanel(1, false));
        rangeSec.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.from")));
        rangeSec.add((Component)this.m_fromYear);
        rangeSec.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.to")));
        rangeSec.add((Component)this.m_toYear);
        this.add((Component)rangeSec);
        this.add((Component)this.m_buttons, 66);
    }

    @Override
    protected final void addAttribute(DynamicObjectType dot, String label, PageState state) throws FormProcessException {
        Date date = (Date)this.m_date.getValue(state);
        Object valReq = null;
        if (valReq == null) {
            dot.addOptionalAttribute(label, MetadataRoot.DATE);
        } else {
            dot.addRequiredAttribute(label, MetadataRoot.DATE, (Object)date);
        }
    }

    @Override
    protected final void addFormComponent(PersistentForm pForm, String label, PageState state) throws FormProcessException {
        PersistentDate pDate = PersistentDate.create((String)label);
        pDate.setParameterModel("com.arsdigita.bebop.parameters.DateParameter");
        pForm.addComponent((PersistentComponent)pDate);
    }

    @Override
    protected final void doInit(FormSectionEvent event) {
        Date date = new Date(System.currentTimeMillis());
        this.m_date.setValue(event.getPageState(), (Object)date);
    }

    @Override
    protected final void doValidate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        Integer fromYear = (Integer)this.m_fromYear.getValue(state);
        Integer toYear = (Integer)this.m_toYear.getValue(state);
        if (fromYear == null || toYear == null) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.type.year_range_not_balanced").localize());
        }
        if (fromYear < 0 || toYear < 0) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.type.year_is_negative").localize());
        }
        if (fromYear > toYear) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.type.year_range_wrong_order").localize());
        }
        if (toYear - fromYear > 200) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.type.year_range_too_great").localize());
        }
        if (!(fromYear >= 1900 && fromYear <= 2100 || toYear >= 1900 && toYear <= 2100)) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.type.year_too_anachronistic").localize());
        }
    }

    private static String lz(String key) {
        return (String)GlobalizationUtil.globalize(key).localize();
    }
}

