/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ui.type.ElementAddForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentTextArea;
import com.arsdigita.formbuilder.PersistentTextField;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.metadata.MetadataRoot;

public class AddTextElement
extends ElementAddForm {
    private static final String INPUT_BOX = "inputBox";
    private static final String TEXT_AREA = "textArea";
    private TextField m_length;
    private RadioGroup m_dataEntry;
    private CheckboxGroup m_valReq;

    public AddTextElement(ACSObjectSelectionModel types) {
        super("ContentTypeAddTextElement", "Add a Text Element", types);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.maximum_length")));
        this.m_length = new TextField((ParameterModel)new IntegerParameter("length"));
        this.m_length.setSize(15);
        this.m_length.setMaxLength(10);
        this.add((Component)this.m_length);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.data_entry_method")));
        this.m_dataEntry = new RadioGroup("TextElementDataEntryMethodSelect");
        this.m_dataEntry.setClassAttr("vertical");
        this.m_dataEntry.addOption(new Option(INPUT_BOX, "Input box"));
        this.m_dataEntry.addOption(new Option(TEXT_AREA, "Text Area"));
        this.add((Component)this.m_dataEntry);
        this.add((Component)this.m_buttons, 66);
    }

    @Override
    protected final void addAttribute(DynamicObjectType dot, String label, PageState state) throws FormProcessException {
        Integer length = (Integer)this.m_length.getValue(state);
        Object valReq = null;
        if (length == null) {
            length = new Integer(4000);
        }
        if (valReq == null) {
            dot.addOptionalAttribute(label, MetadataRoot.STRING, length.intValue());
        } else {
            dot.addRequiredAttribute(label, MetadataRoot.STRING, length.intValue(), (Object)"  ");
        }
    }

    @Override
    protected final void addFormComponent(PersistentForm pForm, String label, PageState state) throws FormProcessException {
        String dataEntry = (String)this.m_dataEntry.getValue(state);
        Integer length = (Integer)this.m_length.getValue(state);
        if (dataEntry.equals(INPUT_BOX)) {
            PersistentTextField pTextField = PersistentTextField.create((String)label);
            if (length != null) {
                pTextField.setMaxLength(length.intValue());
            }
            pTextField.save();
            pForm.addComponent((PersistentComponent)pTextField);
        } else if (dataEntry.equals(TEXT_AREA)) {
            PersistentTextArea pTextArea = PersistentTextArea.create((String)label);
            pTextArea.save();
            pForm.addComponent((PersistentComponent)pTextArea);
        }
    }

    @Override
    protected final void doInit(FormSectionEvent e) {
        PageState state = e.getPageState();
        this.m_dataEntry.setValue(state, (Object)INPUT_BOX);
    }
}

