/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.type.TypeSecurityListener;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class AddType
extends CMSForm
implements PrintListener,
FormProcessListener,
FormInitListener {
    private static final Logger s_log = Logger.getLogger((String)AddType.class.getName());
    protected Hidden m_id = new Hidden((ParameterModel)new BigDecimalParameter("id"));
    protected TextField m_label;
    protected TextField m_objectType;
    protected TextField m_className;
    protected TextArea m_description;
    protected SingleSelect m_lifecycleSelect;
    protected Submit m_submit;
    protected Submit m_cancel;

    public AddType() {
        super("ContentType");
        this.add((Component)this.m_id);
        this.m_id.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.label")));
        this.m_label = new TextField((ParameterModel)new StringParameter("label"));
        this.m_label.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_label.setSize(40);
        this.m_label.setMaxLength(1000);
        this.add((Component)this.m_label);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.description")));
        this.m_description = new TextArea((ParameterModel)new StringParameter("description"));
        this.m_description.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        this.m_description.setCols(40);
        this.m_description.setRows(5);
        this.m_description.setWrap(2);
        this.add((Component)this.m_description);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.object_type")));
        this.m_objectType = new TextField((ParameterModel)new StringParameter("objectType"));
        this.m_objectType.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_objectType.setSize(40);
        this.m_objectType.setMaxLength(1000);
        this.add((Component)this.m_objectType);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.class_name")));
        this.m_className = new TextField((ParameterModel)new StringParameter("className"));
        this.m_className.setSize(40);
        this.m_className.setMaxLength(1000);
        this.add((Component)this.m_className);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.lifecycle")));
        this.m_lifecycleSelect = new SingleSelect((ParameterModel)new BigDecimalParameter("lifecycle"));
        try {
            this.m_lifecycleSelect.addPrintListener((PrintListener)this);
        }
        catch (TooManyListenersException e) {
            s_log.warn((Object)"Too many listeners", (Throwable)e);
            throw new UncheckedWrapperException((Throwable)e);
        }
        this.add((Component)this.m_lifecycleSelect);
        SimpleContainer s = new SimpleContainer();
        this.m_submit = new Submit("submit");
        this.m_submit.setButtonLabel("Save");
        s.add((Component)this.m_submit);
        this.m_cancel = new Submit("cancel");
        this.m_cancel.setButtonLabel("Cancel");
        s.add((Component)this.m_cancel);
        this.add((Component)s, 66);
        this.addProcessListener(this);
        this.addInitListener(this);
        this.addSubmissionListener(new TypeSecurityListener());
    }

    @Override
    public boolean isCancelled(PageState state) {
        return this.m_cancel.isSelected(state);
    }

    public void prepare(PrintEvent event) {
        SingleSelect t = (SingleSelect)event.getTarget();
        ContentSection section = CMS.getContext().getContentSection();
        t.addOption(new Option("", "-- select --"));
        LifecycleDefinitionCollection cycles = section.getLifecycleDefinitions();
        while (cycles.next()) {
            LifecycleDefinition cycle = cycles.getLifecycleDefinition();
            t.addOption(new Option(cycle.getID().toString(), cycle.getLabel()));
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        ContentType contentType;
        PageState state = e.getPageState();
        ContentSection section = CMS.getContext().getContentSection();
        FormData data = e.getFormData();
        BigDecimal key = (BigDecimal)data.get((Object)this.m_id.getName());
        String label = (String)data.get((Object)this.m_label.getName());
        String description = (String)data.get((Object)this.m_description.getName());
        String objectType = (String)data.get((Object)this.m_objectType.getName());
        String className = (String)data.get((Object)this.m_className.getName());
        BigDecimal lifecycleID = (BigDecimal)data.get((Object)this.m_lifecycleSelect.getName());
        boolean isNew = false;
        try {
            contentType = new ContentType(key);
        }
        catch (DataObjectNotFoundException ex) {
            contentType = new ContentType(SessionManager.getSession().create(new OID("com.arsdigita.cms.ContentType", (Object)key)));
            isNew = true;
        }
        contentType.setLabel(label);
        contentType.setDescription(description);
        contentType.setAssociatedObjectType(objectType);
        contentType.setClassName(className);
        contentType.save();
        if (isNew) {
            this.updateContentTypeAssociation(section, contentType);
        }
        try {
            if (lifecycleID != null) {
                LifecycleDefinition lifecycle = new LifecycleDefinition(lifecycleID);
                ContentTypeLifecycleDefinition.updateLifecycleDefinition(section, contentType, lifecycle);
            } else {
                ContentTypeLifecycleDefinition.removeLifecycleDefinition(section, contentType);
            }
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        Utilities.refreshItemUI(state);
    }

    public void init(FormSectionEvent e) {
        FormData data = e.getFormData();
        try {
            if (data.get((Object)this.m_id.getName()) == null) {
                data.put((Object)this.m_id.getName(), (Object)Sequences.getNextValue());
            }
        }
        catch (SQLException s) {
            s_log.warn((Object)"Error retrieving sequence value", (Throwable)s);
            data.addError("Could not generate Sequence ID " + s.getMessage());
        }
    }

    protected void updateContentTypeAssociation(ContentSection section, ContentType type) {
        section.addContentType(type);
        section.save();
    }

    public Object getObjectKey(PageState s) {
        BigDecimal id = (BigDecimal)this.getFormData(s).get((Object)this.m_id.getName());
        return id;
    }
}

