/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.SectionTemplateMapping;
import com.arsdigita.cms.ui.BaseAdminPane;
import com.arsdigita.cms.ui.BaseDeleteForm;
import com.arsdigita.cms.ui.type.ContentTypeItemPane;
import com.arsdigita.cms.ui.type.ContentTypeListModelBuilder;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.cms.ui.type.CreateType;
import com.arsdigita.cms.ui.type.EditType;
import com.arsdigita.cms.ui.type.SelectType;
import com.arsdigita.cms.ui.type.TypeSecurityContainer;
import com.arsdigita.cms.ui.type.TypeSecurityListener;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.toolbox.ui.Cancellable;
import com.arsdigita.toolbox.ui.Section;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public final class ContentTypeAdminPane
extends BaseAdminPane {
    private static final Logger s_log = Logger.getLogger(ContentTypeAdminPane.class);
    private final ACSObjectSelectionModel m_model = new ACSObjectSelectionModel(this.getSelectionModel());
    private final ContentTypeRequestLocal m_type = new SelectionRequestLocal();

    public ContentTypeAdminPane() {
        super((Component)new Label(ContentTypeAdminPane.gz("cms.ui.types")), (ListModelBuilder)new ContentTypeListModelBuilder());
        ActionLink addTypeLink = new ActionLink((Component)new Label(ContentTypeAdminPane.gz("cms.ui.type.add")));
        AddTypeContainer addTypeContainer = new AddTypeContainer();
        this.getBody().add((Component)addTypeContainer);
        this.getBody().connect(addTypeLink, (Component)addTypeContainer);
        addTypeLink.addActionListener((ActionListener)addTypeContainer);
        this.setEdit(new ActionLink((Component)new Label(ContentTypeAdminPane.gz("cms.ui.type.edit"))), new EditType((SingleSelectionModel)this.m_model));
        this.setDelete(new ActionLink((Component)new Label(ContentTypeAdminPane.gz("cms.ui.type.delete"))), new DeleteForm());
        this.setIntroPane((Component)new Label(ContentTypeAdminPane.gz("cms.ui.type.intro")));
        this.setItemPane((Component)new ContentTypeItemPane(this.m_model, this.m_type, this.getEditLink(), this.getDeleteLink()));
        this.addAction((Component)new TypeSecurityContainer((Component)addTypeLink), "add");
    }

    public void register(Page p) {
        super.register(p);
        p.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                ContentType contentType = (ContentType)ContentTypeAdminPane.this.m_model.getSelectedObject(state);
                ContentSection section = CMS.getContext().getContentSection();
                if (contentType == null) {
                    String template = state.getRequest().getParameter("set_template");
                    if (template != null) {
                        DataCollection da = SessionManager.getSession().retrieve("com.arsdigita.cms.SectionTemplateMapping");
                        DomainCollection c = new DomainCollection(da);
                        c.addEqualsFilter("section.id", (Object)section.getID());
                        c.addEqualsFilter("template.id", (Object)new BigDecimal(template));
                        c.addOrder("contentType.label");
                        if (c.next()) {
                            SectionTemplateMapping mapping = (SectionTemplateMapping)c.getDomainObject();
                            contentType = mapping.getContentType();
                        }
                        c.close();
                    }
                    if (contentType == null) {
                        ContentTypeCollection contentTypes = section.getContentTypes();
                        contentTypes.addOrder("label asc");
                        try {
                            if (contentTypes.next()) {
                                contentType = contentTypes.getContentType();
                            }
                        }
                        finally {
                            contentTypes.close();
                        }
                    }
                    if (contentType != null) {
                        ContentTypeAdminPane.this.m_model.setSelectedObject(state, (DomainObject)contentType);
                        ContentTypeAdminPane.this.getBody().push(state, ContentTypeAdminPane.this.getItemPane());
                    }
                }
            }
        });
    }

    private void resetPane(PageState state) {
        this.getBody().reset(state);
        if (this.getSelectionModel().isSelected(state)) {
            s_log.debug((Object)"The selection model is selected; displaying the item pane");
            this.getBody().push(state, this.getItemPane());
        }
    }

    private class DeleteForm
    extends BaseDeleteForm {
        DeleteForm() {
            super((Component)new Label(DeleteForm.gz("cms.ui.type.delete_prompt")));
            this.addSubmissionListener(new TypeSecurityListener());
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            ContentSection section = CMS.getContext().getContentSection();
            section.removeContentType(ContentTypeAdminPane.this.m_type.getContentType(state));
            section.save();
            ContentTypeAdminPane.this.getSelectionModel().clearSelection(state);
        }
    }

    private class SelectionRequestLocal
    extends ContentTypeRequestLocal {
        private SelectionRequestLocal() {
        }

        @Override
        protected final Object initialValue(PageState state) {
            ContentType contentType = (ContentType)ContentTypeAdminPane.this.m_model.getSelectedObject(state);
            return contentType;
        }
    }

    private final class CancelListener
    implements FormSubmissionListener {
        Cancellable m_form;

        CancelListener(Cancellable form) {
            this.m_form = form;
        }

        public void submitted(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            if (this.m_form.isCancelled(state)) {
                ContentTypeAdminPane.this.getBody().pop(state);
                throw new FormProcessException("cancelled");
            }
        }
    }

    private class AddTypeContainer
    extends GridPanel
    implements ActionListener,
    FormProcessListener {
        private Label m_noTypesAvailable;
        private SelectType m_selectType;
        private CreateType m_createType;

        AddTypeContainer() {
            super(1);
            this.m_noTypesAvailable = new Label(ContentTypeAdminPane.gz("cms.ui.type.select.none"));
            Section selectSection = new Section();
            selectSection.setHeading((Component)new Label(ContentTypeAdminPane.gz("cms.ui.type.select")));
            this.add((Component)selectSection);
            GridPanel container = new GridPanel(1);
            container.add((Component)this.m_noTypesAvailable);
            this.m_selectType = new SelectType();
            this.m_selectType.addSubmissionListener(new CancelListener(this.m_selectType));
            this.m_selectType.addProcessListener(this);
            container.add((Component)this.m_selectType);
            selectSection.setBody((Component)container);
            Section addSection = new Section(){

                public final boolean isVisible(PageState state) {
                    return super.isVisible(state) && !ContentSection.getConfig().getHideUDCTUI();
                }
            };
            addSection.setHeading((Component)new Label(ContentTypeAdminPane.gz("cms.ui.type.define")));
            this.m_createType = new CreateType((SingleSelectionModel)ContentTypeAdminPane.this.m_model);
            this.m_createType.addSubmissionListener(new CancelListener(this.m_createType));
            this.m_createType.addProcessListener(this);
            addSection.setBody((Component)this.m_createType);
            this.add((Component)addSection);
        }

        public void actionPerformed(ActionEvent e) {
            PageState s = e.getPageState();
            ContentSection section = CMS.getContext().getContentSection();
            ContentTypeCollection contentTypes = section.getNotAssociatedContentTypes();
            boolean hasAvailableTypes = !contentTypes.isEmpty();
            this.m_selectType.setVisible(s, hasAvailableTypes);
            this.m_noTypesAvailable.setVisible(s, !hasAvailableTypes);
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            ContentTypeAdminPane.this.resetPane(state);
        }
    }
}

