/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.RelationAttributeInterface;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.ContentSectionRequestLocal;
import com.arsdigita.cms.ui.templates.SectionTemplatesListing;
import com.arsdigita.cms.ui.templates.TemplateCreate;
import com.arsdigita.cms.ui.type.AddContentItemElement;
import com.arsdigita.cms.ui.type.AddDateElement;
import com.arsdigita.cms.ui.type.AddElement;
import com.arsdigita.cms.ui.type.AddFileElement;
import com.arsdigita.cms.ui.type.AddImageElement;
import com.arsdigita.cms.ui.type.AddNumberElement;
import com.arsdigita.cms.ui.type.AddTextAssetElement;
import com.arsdigita.cms.ui.type.AddTextElement;
import com.arsdigita.cms.ui.type.ContentTypePropertyList;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.cms.ui.type.RelationAttributeList;
import com.arsdigita.cms.ui.type.TypeElements;
import com.arsdigita.cms.ui.type.TypePermissionsTable;
import com.arsdigita.cms.ui.type.TypeSecurityContainer;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.Cancellable;
import com.arsdigita.toolbox.ui.Section;
import org.apache.log4j.Logger;

final class ContentTypeItemPane
extends BaseItemPane {
    private static Logger s_log = Logger.getLogger(ContentTypeItemPane.class);
    private final ACSObjectSelectionModel m_model;
    private final ContentTypeRequestLocal m_type;
    private final SimpleContainer m_detailPane;
    private final TypeElements m_elements;
    private final AddElement m_elementAddForm;
    private final SectionTemplatesListing m_templates;
    private final TypePermissionsTable m_permissions;

    ContentTypeItemPane(ACSObjectSelectionModel model, ContentTypeRequestLocal type, ActionLink editLink, ActionLink deleteLink) {
        this.m_model = model;
        this.m_type = type;
        this.m_detailPane = new SimpleContainer();
        this.add((Component)this.m_detailPane);
        this.setDefault((Component)this.m_detailPane);
        this.m_elements = new TypeElements((SingleSelectionModel)this.m_model);
        this.m_elementAddForm = new AddElement();
        this.m_templates = new SectionTemplatesListing(new ContentSectionRequestLocal(), this.m_type);
        this.m_permissions = new TypePermissionsTable(new ContentSectionRequestLocal(), this.m_type);
        ActionLink templateAddLink = new ActionLink((Component)new Label(ContentTypeItemPane.gz("cms.ui.type.template.add")));
        TemplateCreate templateFormSection = new TemplateCreate(this.m_model);
        CancellableForm templateForm = new CancellableForm("AddTemplate", templateFormSection.getSaveCancelSection().getCancelButton());
        templateForm.add((Component)templateFormSection);
        this.add((Component)templateForm);
        AddTextElement textForm = new AddTextElement(this.m_model);
        this.add((Component)textForm);
        AddNumberElement numberForm = new AddNumberElement(this.m_model);
        this.add((Component)numberForm);
        AddDateElement dateForm = new AddDateElement(this.m_model);
        this.add((Component)dateForm);
        AddTextAssetElement assetForm = new AddTextAssetElement(this.m_model);
        this.add((Component)assetForm);
        AddImageElement imageForm = new AddImageElement(this.m_model);
        this.add((Component)imageForm);
        AddFileElement fileForm = new AddFileElement(this.m_model);
        this.add((Component)fileForm);
        AddContentItemElement itemForm = new AddContentItemElement(this.m_model);
        this.add((Component)itemForm);
        this.m_detailPane.add((Component)new SummarySection(editLink, deleteLink));
        this.m_detailPane.add((Component)new RelationAttributeSection());
        this.m_detailPane.add((Component)new TypeSecurityContainer((Component)new ElementSection()));
        this.m_detailPane.add((Component)new TemplateSection(templateAddLink));
        this.m_detailPane.add((Component)new PermissionsSection());
        this.connect(templateAddLink, (FormSection)templateForm);
        SingleSelect elementSelect = this.m_elementAddForm.getElementTypeSelect();
        this.connect(this.m_elementAddForm, (Widget)elementSelect, "text", (FormSection)textForm);
        this.connect((FormSection)textForm);
        this.connect(this.m_elementAddForm, (Widget)elementSelect, "number", (FormSection)numberForm);
        this.connect((FormSection)numberForm);
        this.connect(this.m_elementAddForm, (Widget)elementSelect, "date", (FormSection)dateForm);
        this.connect((FormSection)dateForm);
        this.connect(this.m_elementAddForm, (Widget)elementSelect, "textAsset", (FormSection)assetForm);
        this.connect((FormSection)assetForm);
        this.connect(this.m_elementAddForm, (Widget)elementSelect, "image", (FormSection)imageForm);
        this.connect((FormSection)imageForm);
        this.connect(this.m_elementAddForm, (Widget)elementSelect, "file", (FormSection)fileForm);
        this.connect((FormSection)fileForm);
        this.connect(this.m_elementAddForm, (Widget)elementSelect, "contentItem", (FormSection)itemForm);
        this.connect((FormSection)itemForm);
    }

    public final void register(Page page) {
        super.register(page);
        page.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                if (state.isVisibleOnPage((Component)ContentTypeItemPane.this) && ContentTypeItemPane.this.m_model.isSelected(state) && !ContentTypeItemPane.userCanEdit(state)) {
                    ContentTypeItemPane.this.m_templates.getRemoveColumn().setVisible(state, false);
                    ContentTypeItemPane.this.m_templates.getDefaultColumn().setVisible(state, false);
                    ContentTypeItemPane.this.m_elements.getTable().getColumn(3).setVisible(state, false);
                }
            }
        });
    }

    private void removeType(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        section.removeContentType(this.m_type.getContentType(state));
        section.save();
    }

    protected static boolean userCanEdit(PageState state) {
        SecurityManager sm = Utilities.getSecurityManager(state);
        return sm.canAccess(state.getRequest(), "content_type_admin");
    }

    protected final boolean isDynamicType(PageState state) {
        ContentType type = this.m_type.getContentType(state);
        String objectTypeString = "com.arsdigita.persistence.DynamicObjectType";
        DataCollection collection = SessionManager.getSession().retrieve("com.arsdigita.persistence.DynamicObjectType");
        collection.addEqualsFilter("dynamicType", (Object)type.getAssociatedObjectType());
        boolean b = collection.next();
        collection.close();
        return b;
    }

    private class RelationAttributeSection
    extends Section {
        RelationAttributeSection() {
            this.setHeading((Component)new Label(ContentTypeItemPane.gz("cms.ui.type.attributes")));
            this.setBody((Component)new RelationAttributeList(ContentTypeItemPane.this.m_type));
        }

        public final boolean isVisible(PageState state) {
            boolean retVal = false;
            ContentType ct = ContentTypeItemPane.this.m_type.getContentType(state);
            ContentItem ci = null;
            try {
                Class<ContentItem> clazz = Class.forName(ct.getClassName()).asSubclass(ContentItem.class);
                ci = clazz.newInstance();
                if (ci instanceof RelationAttributeInterface) {
                    RelationAttributeInterface rai = (RelationAttributeInterface)((Object)ci);
                    retVal = rai.hasRelationAttributes();
                }
                ci.delete();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return retVal;
        }
    }

    private class PermissionsSection
    extends Section {
        public PermissionsSection() {
            this.setHeading((Component)new Label(ContentTypeItemPane.gz("cms.ui.type.permissions")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)ContentTypeItemPane.this.m_permissions);
        }

        public final boolean isVisible(PageState state) {
            return ContentTypeItemPane.this.m_model.isSelected(state) && !ContentTypeItemPane.this.isDynamicType(state);
        }
    }

    private class TemplateSection
    extends Section {
        TemplateSection(ActionLink templateAddLink) {
            this.setHeading((Component)new Label(ContentTypeItemPane.gz("cms.ui.type.templates")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)ContentTypeItemPane.this.m_templates);
            group.addAction((Component)new TypeSecurityContainer((Component)templateAddLink));
        }

        public final boolean isVisible(PageState state) {
            return ContentTypeItemPane.this.m_model.isSelected(state) && !ContentTypeItemPane.this.isDynamicType(state);
        }
    }

    private class ElementSection
    extends Section {
        ElementSection() {
            this.setHeading((Component)new Label(ContentTypeItemPane.gz("cms.ui.type.elements")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)ContentTypeItemPane.this.m_elements);
            group.addAction((Component)ContentTypeItemPane.this.m_elementAddForm);
        }

        public final boolean isVisible(PageState state) {
            return ContentTypeItemPane.this.m_model.isSelected(state) && ContentTypeItemPane.this.isDynamicType(state) && !ContentSection.getConfig().getHideUDCTUI();
        }
    }

    private class SummarySection
    extends Section {
        SummarySection(ActionLink editLink, ActionLink deleteLink) {
            this.setHeading((Component)new Label(ContentTypeItemPane.gz("cms.ui.type.details")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new ContentTypePropertyList(ContentTypeItemPane.this.m_type));
            group.addAction((Component)new TypeSecurityContainer((Component)editLink));
            group.addAction((Component)new TypeSecurityContainer((Component)deleteLink));
        }
    }

    private class CancellableForm
    extends Form
    implements Cancellable {
        private final Submit m_cancel;

        CancellableForm(String name, Submit cancel) {
            super(name);
            this.m_cancel = cancel;
        }

        public final boolean isCancelled(PageState state) {
            return this.m_cancel.isSelected(state);
        }
    }
}

