/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormValidationException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.AuthoringStepCollection;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.type.TypeSecurityListener;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class CreateType
extends CMSForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener,
FormValidationListener {
    private static final String DEFAULT_UDITEM_TYPE = "com.arsdigita.cms.ContentPage";
    private static final String CATEGORIZATION_COMPONENT = "com.arsdigita.cms.ui.authoring.ItemCategoryStep";
    private static final Logger s_log = Logger.getLogger((String)CreateType.class.getName());
    private static final String CREATION_COMPONENT = "com.arsdigita.cms.ui.authoring.PageCreateDynamic";
    private Hidden m_id;
    private TextField m_name;
    private TextField m_label;
    private TextArea m_description;
    private SingleSelect m_parentTypeSelect;
    private SingleSelect m_lifecycleSelect;
    private SingleSelect m_workflowSelect;
    private Submit m_submit;
    private Submit m_cancel;
    private SingleSelectionModel m_types = null;
    DynamicObjectType dot;

    public CreateType() {
        this((SingleSelectionModel)null);
    }

    public CreateType(SingleSelectionModel m) {
        super("NewContentItemDefinition");
        if (m != null) {
            this.m_types = m;
        }
        this.m_id = new Hidden((ParameterModel)new BigDecimalParameter("id"));
        this.m_id.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)this.m_id);
        Label heading = new Label(GlobalizationUtil.globalize("cms.ui.type.add"));
        heading.setFontWeight("b");
        this.add((Component)heading, 64);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.name")));
        this.m_name = new TextField((ParameterModel)new StringParameter("name"));
        this.m_name.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.m_name.setSize(40);
        this.m_name.setMaxLength(1000);
        this.add((Component)this.m_name);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.label")));
        this.m_label = new TextField((ParameterModel)new StringParameter("label"));
        this.m_label.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 1000));
        this.m_label.setSize(40);
        this.m_label.setMaxLength(1000);
        this.add((Component)this.m_label);
        this.add((Component)new FormErrorDisplay((Form)this), 64);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.description")));
        this.m_description = new TextArea((ParameterModel)new StringParameter("description"));
        this.m_description.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        this.m_description.setCols(40);
        this.m_description.setRows(5);
        this.m_description.setWrap(2);
        this.add((Component)this.m_description);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.parent")));
        this.m_parentTypeSelect = new SingleSelect((ParameterModel)new BigDecimalParameter("parentType"));
        try {
            this.m_parentTypeSelect.addPrintListener((PrintListener)new ParentTypeSelectPrintListener());
        }
        catch (TooManyListenersException e) {
            s_log.error((Object)"Too many listeners", (Throwable)e);
            throw new UncheckedWrapperException((Throwable)e);
        }
        this.add((Component)this.m_parentTypeSelect);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.lifecycle")));
        this.m_lifecycleSelect = new SingleSelect((ParameterModel)new BigDecimalParameter("lifecycle"));
        try {
            this.m_lifecycleSelect.addPrintListener((PrintListener)new LifecycleSelectPrintListener());
        }
        catch (TooManyListenersException e) {
            s_log.error((Object)"Too many listeners", (Throwable)e);
            throw new UncheckedWrapperException((Throwable)e);
        }
        this.add((Component)this.m_lifecycleSelect);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.workflow")));
        this.m_workflowSelect = new SingleSelect((ParameterModel)new BigDecimalParameter("workflow"));
        try {
            this.m_workflowSelect.addPrintListener((PrintListener)new WorkflowSelectPrintListener());
        }
        catch (TooManyListenersException e) {
            s_log.error((Object)"Too many listeners", (Throwable)e);
            throw new UncheckedWrapperException((Throwable)e);
        }
        this.add((Component)this.m_workflowSelect);
        SimpleContainer s = new SimpleContainer();
        this.m_submit = new Submit("submit");
        this.m_submit.setButtonLabel("Create Content Type");
        s.add((Component)this.m_submit);
        this.m_cancel = new Submit("cancel");
        this.m_cancel.setButtonLabel("Cancel");
        s.add((Component)this.m_cancel);
        this.add((Component)s, 66);
        this.addProcessListener(this);
        this.addInitListener(this);
        this.addSubmissionListener(new TypeSecurityListener());
        this.addSubmissionListener(this);
        this.addValidationListener(this);
    }

    @Override
    public boolean isCancelled(PageState s) {
        return this.m_cancel.isSelected(s);
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        String typeLabel = (String)this.m_label.getValue(s);
        String typeName = (String)this.m_name.getValue(s);
        ContentSection section = CMS.getContext().getContentSection();
        ContentTypeCollection contentTypes = section.getContentTypes();
        boolean dupe = false;
        while (contentTypes.next() && !dupe) {
            if (contentTypes.getContentType().getLabel().compareTo(typeLabel) != 0) continue;
            dupe = true;
        }
        if (dupe) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.type.name_not_unique", new Object[]{typeLabel}).localize());
        }
        for (int i = 0; i < typeName.length(); ++i) {
            char c = typeName.charAt(i);
            if (Character.isWhitespace(c)) {
                throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.type.name_has_whitespace").localize());
            }
            if (Character.isLetterOrDigit(c)) continue;
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.type.name_not_alphanumeric").localize());
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        ContentType contentType;
        PageState state = e.getPageState();
        ContentSection section = CMS.getContext().getContentSection();
        BigDecimal key = (BigDecimal)this.m_id.getValue(state);
        String name = (String)this.m_name.getValue(state);
        String label = (String)this.m_label.getValue(state);
        String description = (String)this.m_description.getValue(state);
        BigDecimal parentTypeID = (BigDecimal)this.m_parentTypeSelect.getValue(state);
        BigDecimal lifecycleID = (BigDecimal)this.m_lifecycleSelect.getValue(state);
        BigDecimal workflowID = (BigDecimal)this.m_workflowSelect.getValue(state);
        ObjectType parentObjectType = null;
        ContentType parentContentType = null;
        String parentContentClassname = null;
        try {
            if (parentTypeID != null && parentTypeID.intValue() != -1) {
                parentContentType = new ContentType(parentTypeID);
            }
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        if (parentContentType != null) {
            parentContentClassname = parentContentType.getClassName();
            parentObjectType = SessionManager.getMetadataRoot().getObjectType(parentContentType.getAssociatedObjectType());
        } else {
            try {
                parentContentType = ContentType.findByAssociatedObjectType(DEFAULT_UDITEM_TYPE);
                parentContentClassname = parentContentType.getClassName();
            }
            catch (DataObjectNotFoundException ex) {
                parentContentClassname = DEFAULT_UDITEM_TYPE;
            }
            parentObjectType = SessionManager.getMetadataRoot().getObjectType(DEFAULT_UDITEM_TYPE);
        }
        String qname = parentObjectType.getModel().getName() + "." + name;
        MetadataRoot root = MetadataRoot.getMetadataRoot();
        if (root.getObjectType(qname) != null || root.hasTable(name)) {
            throw new FormValidationException((Widget)this.m_name, (String)GlobalizationUtil.globalize("cms.ui.type.duplicate_type", new Object[]{name}).localize());
        }
        this.dot = new DynamicObjectType(name, parentObjectType);
        this.dot.save();
        boolean isNew = false;
        try {
            contentType = new ContentType(key);
        }
        catch (DataObjectNotFoundException ex) {
            contentType = new ContentType(SessionManager.getSession().create(new OID("com.arsdigita.cms.ContentType", (Object)key)));
            isNew = true;
        }
        contentType.setLabel(label);
        contentType.setDescription(description);
        contentType.setClassName(parentContentClassname);
        contentType.setAssociatedObjectType(this.dot.getObjectType().getQualifiedName());
        String formName = name.concat("ItemForm");
        PersistentForm pForm = PersistentForm.create((String)formName);
        pForm.save();
        contentType.setItemFormID(pForm.getID());
        contentType.save();
        if (isNew) {
            this.updateContentTypeAssociation(section, contentType, parentContentType);
        }
        this.setDefaultLifecycle(lifecycleID, section, contentType);
        this.setDefaultWorkflow(workflowID, section, contentType);
        Utilities.refreshItemUI(state);
        if (this.m_types != null) {
            this.m_types.setSelectedKey(state, (Object)key.toString());
        }
    }

    public void init(FormSectionEvent e) {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        try {
            if (this.m_id.getValue(state) == null) {
                BigDecimal id = Sequences.getNextValue();
                this.m_id.setValue(state, (Object)id);
            }
        }
        catch (SQLException s) {
            s_log.error((Object)("Error generating sequence ID" + s));
            data.addError("Could not generate Sequence ID " + s.getMessage());
        }
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        if (this.m_cancel.isSelected(e.getPageState())) {
            throw new FormProcessException("cancelled");
        }
    }

    protected void updateContentTypeAssociation(ContentSection section, ContentType type) {
        this.updateContentTypeAssociation(section, type, null);
    }

    protected void updateContentTypeAssociation(ContentSection section, ContentType type, ContentType parentType) {
        section.addContentType(type);
        section.save();
        AuthoringKit kit = type.createAuthoringKit(CREATION_COMPONENT);
        kit.save();
        int stepOrdering = 1;
        boolean hasCategoryStep = false;
        if (parentType != null) {
            AuthoringKit superTypeKit = parentType.getAuthoringKit();
            AuthoringStepCollection superTypeSteps = superTypeKit.getSteps();
            while (superTypeSteps.next()) {
                AuthoringStep step = superTypeSteps.getAuthoringStep();
                if (CATEGORIZATION_COMPONENT.equals(step.getComponent())) {
                    hasCategoryStep = true;
                }
                kit.createStep(step.getLabel(), step.getDescription(), step.getComponent(), new BigDecimal(stepOrdering));
                ++stepOrdering;
            }
        }
        if (stepOrdering == 1) {
            kit.createStep(type.getLabel() + " Basic Properties", type.getAssociatedObjectType(), "com.arsdigita.cms.ui.authoring.PageEditDynamic", new BigDecimal(stepOrdering));
        } else {
            kit.createStep(type.getLabel() + " Basic Properties", type.getAssociatedObjectType(), "com.arsdigita.cms.ui.authoring.SecondaryPageEditDynamic", new BigDecimal(stepOrdering));
        }
        ++stepOrdering;
        if (!hasCategoryStep) {
            kit.createStep("Categories", "", CATEGORIZATION_COMPONENT, new BigDecimal(stepOrdering));
        }
        kit.save();
    }

    public Object getObjectKey(PageState s) {
        BigDecimal id = (BigDecimal)this.m_id.getValue(s);
        return id;
    }

    private void setDefaultLifecycle(BigDecimal lifecycleID, ContentSection section, ContentType contentType) {
        try {
            if (lifecycleID != null) {
                if (lifecycleID.intValue() != -1) {
                    LifecycleDefinition lifecycle = new LifecycleDefinition(lifecycleID);
                    ContentTypeLifecycleDefinition.updateLifecycleDefinition(section, contentType, lifecycle);
                } else {
                    ContentTypeLifecycleDefinition.removeLifecycleDefinition(section, contentType);
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
    }

    private void setDefaultWorkflow(BigDecimal workflowID, ContentSection section, ContentType contentType) {
        try {
            if (workflowID != null) {
                if (workflowID.intValue() != -1) {
                    WorkflowTemplate template = new WorkflowTemplate(new OID("com.arsdigita.workflow.simple.WorkflowTemplate", (Object)workflowID));
                    ContentTypeWorkflowTemplate.updateWorkflowTemplate(section, contentType, template);
                } else {
                    ContentTypeWorkflowTemplate.removeWorkflowTemplate(section, contentType);
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
    }

    private class WorkflowSelectPrintListener
    implements PrintListener {
        private WorkflowSelectPrintListener() {
        }

        public void prepare(PrintEvent event) {
            SingleSelect t = (SingleSelect)event.getTarget();
            ContentSection section = CMS.getContext().getContentSection();
            t.addOption(new Option("-1", "-- select --"));
            TaskCollection templates = section.getWorkflowTemplates();
            while (templates.next()) {
                WorkflowTemplate template = (WorkflowTemplate)templates.getDomainObject();
                t.addOption(new Option(template.getID().toString(), template.getLabel()));
            }
        }
    }

    private class LifecycleSelectPrintListener
    implements PrintListener {
        private LifecycleSelectPrintListener() {
        }

        public void prepare(PrintEvent event) {
            SingleSelect t = (SingleSelect)event.getTarget();
            ContentSection section = CMS.getContext().getContentSection();
            t.addOption(new Option("-1", "-- select --"));
            LifecycleDefinitionCollection cycles = section.getLifecycleDefinitions();
            while (cycles.next()) {
                LifecycleDefinition cycle = cycles.getLifecycleDefinition();
                t.addOption(new Option(cycle.getID().toString(), cycle.getLabel()));
            }
        }
    }

    private class ParentTypeSelectPrintListener
    implements PrintListener {
        private ParentTypeSelectPrintListener() {
        }

        public void prepare(PrintEvent event) {
            SingleSelect t = (SingleSelect)event.getTarget();
            ContentSection section = CMS.getContext().getContentSection();
            t.addOption(new Option("-1", "-- select --"));
            ContentTypeCollection contentTypes = section.getCreatableContentTypes(true);
            contentTypes.addOrder("label");
            while (contentTypes.next()) {
                ContentType type = contentTypes.getContentType();
                Label label = new Label(type.getLabel());
                if (type.isHidden().booleanValue()) {
                    label.setFontWeight("i");
                }
                t.addOption(new Option(type.getID().toString(), (Component)label));
            }
        }
    }
}

