/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.type.TypeSecurityListener;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class EditType
extends CMSForm
implements FormInitListener,
FormProcessListener {
    private static final Logger s_log = Logger.getLogger(EditType.class);
    private final SingleSelectionModel m_types;
    private Hidden m_id;
    private TextField m_label;
    private TextArea m_description;
    private SingleSelect m_lcSelect;
    private SingleSelect m_wfSelect;
    private Submit m_submit;
    private Submit m_cancel;

    public EditType(SingleSelectionModel m) {
        super("EditContentType");
        this.m_types = m;
        this.m_id = new Hidden((ParameterModel)new BigDecimalParameter("id"));
        this.m_id.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)this.m_id);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.label")));
        this.m_label = new TextField((ParameterModel)new StringParameter("label"));
        this.m_label.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_label.setSize(40);
        this.m_label.setMaxLength(1000);
        this.add((Component)this.m_label);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.description")));
        this.m_description = new TextArea((ParameterModel)new StringParameter("description"));
        this.m_description.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        this.m_description.setCols(40);
        this.m_description.setRows(5);
        this.m_description.setWrap(2);
        this.add((Component)this.m_description);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.lifecycle")));
        this.m_lcSelect = new SingleSelect((ParameterModel)new BigDecimalParameter("lifecycle"));
        try {
            this.m_lcSelect.addPrintListener((PrintListener)new SelectLifecyclePrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("TooManyListeners: " + e.getMessage(), (Throwable)e);
        }
        this.add((Component)this.m_lcSelect);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.workflow")));
        this.m_wfSelect = new SingleSelect((ParameterModel)new BigDecimalParameter("workflow"));
        try {
            this.m_wfSelect.addPrintListener((PrintListener)new SelectWorkflowPrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("TooManyListeners: " + e.getMessage(), (Throwable)e);
        }
        this.add((Component)this.m_wfSelect);
        SimpleContainer s = new SimpleContainer();
        this.m_submit = new Submit("submit");
        this.m_submit.setButtonLabel("Save");
        s.add((Component)this.m_submit);
        this.m_cancel = new Submit("cancel");
        this.m_cancel.setButtonLabel("Cancel");
        s.add((Component)this.m_cancel);
        this.add((Component)s, 66);
        this.addInitListener(this);
        this.addSubmissionListener(new TypeSecurityListener());
        this.addProcessListener(this);
    }

    @Override
    public boolean isCancelled(PageState state) {
        return this.m_cancel.isSelected(state);
    }

    public Submit getCancelButton() {
        return this.m_cancel;
    }

    public void init(FormSectionEvent event) {
        WorkflowTemplate template;
        FormData data = event.getFormData();
        PageState state = event.getPageState();
        ContentSection section = CMS.getContext().getContentSection();
        ContentType type = this.getContentType(state);
        BigDecimal id = type.getID();
        String label = type.getLabel();
        String description = type.getDescription();
        data.put((Object)this.m_id.getName(), (Object)id);
        data.put((Object)this.m_label.getName(), (Object)label);
        data.put((Object)this.m_description.getName(), (Object)description);
        LifecycleDefinition cycle = ContentTypeLifecycleDefinition.getLifecycleDefinition(section, type);
        if (cycle != null) {
            data.put((Object)this.m_lcSelect.getName(), (Object)cycle.getID());
        }
        if ((template = ContentTypeWorkflowTemplate.getWorkflowTemplate(section, type)) != null) {
            data.put((Object)this.m_wfSelect.getName(), (Object)template.getID());
        }
    }

    private ContentType getContentType(PageState state) {
        String key = this.m_types.getSelectedKey(state).toString();
        try {
            BigDecimal typeID = new BigDecimal(key);
            return new ContentType(typeID);
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("Content Type ID#" + key + " not found", (Throwable)ex);
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        FormData data = event.getFormData();
        ContentSection section = CMS.getContext().getContentSection();
        BigDecimal key = (BigDecimal)data.get((Object)this.m_id.getName());
        String label = (String)data.get((Object)this.m_label.getName());
        String description = (String)data.get((Object)this.m_description.getName());
        BigDecimal lifecycleId = (BigDecimal)data.get((Object)this.m_lcSelect.getName());
        BigDecimal workflowId = (BigDecimal)data.get((Object)this.m_wfSelect.getName());
        ContentType type = null;
        try {
            type = new ContentType(key);
        }
        catch (DataObjectNotFoundException e) {
            s_log.error((Object)("Can't find ContentType with key " + key), (Throwable)e);
            throw new FormProcessException("Failed to edit the content type: " + key + " " + e.getMessage(), (Throwable)e);
        }
        type.setLabel(label);
        type.setDescription(description);
        type.save();
        this.setDefaultLifecycle(lifecycleId, section, type);
        this.setDefaultWorkflow(workflowId, section, type);
    }

    private void setDefaultLifecycle(BigDecimal lcId, ContentSection section, ContentType type) {
        try {
            if (lcId != null) {
                LifecycleDefinition lifecycle = new LifecycleDefinition(lcId);
                ContentTypeLifecycleDefinition.updateLifecycleDefinition(section, type, lifecycle);
            } else {
                ContentTypeLifecycleDefinition.removeLifecycleDefinition(section, type);
            }
        }
        catch (DataObjectNotFoundException e) {
            // empty catch block
        }
    }

    private void setDefaultWorkflow(BigDecimal wfId, ContentSection section, ContentType type) {
        try {
            if (wfId != null) {
                WorkflowTemplate template = new WorkflowTemplate(new OID("com.arsdigita.workflow.simple.WorkflowTemplate", (Object)wfId));
                ContentTypeWorkflowTemplate.updateWorkflowTemplate(section, type, template);
            } else {
                ContentTypeWorkflowTemplate.removeWorkflowTemplate(section, type);
            }
        }
        catch (DataObjectNotFoundException e) {
            // empty catch block
        }
    }

    private class SelectWorkflowPrintListener
    implements PrintListener {
        private SelectWorkflowPrintListener() {
        }

        public void prepare(PrintEvent event) {
            SingleSelect t = (SingleSelect)event.getTarget();
            ContentSection section = CMS.getContext().getContentSection();
            t.addOption(new Option("", "-- select --"));
            TaskCollection templates = section.getWorkflowTemplates();
            while (templates.next()) {
                WorkflowTemplate template = (WorkflowTemplate)templates.getDomainObject();
                t.addOption(new Option(template.getID().toString(), template.getLabel()));
            }
        }
    }

    private class SelectLifecyclePrintListener
    implements PrintListener {
        private SelectLifecyclePrintListener() {
        }

        public void prepare(PrintEvent event) {
            SingleSelect t = (SingleSelect)event.getTarget();
            ContentSection section = CMS.getContext().getContentSection();
            t.addOption(new Option("", "-- select --"));
            LifecycleDefinitionCollection cycles = section.getLifecycleDefinitions();
            while (cycles.next()) {
                LifecycleDefinition cycle = cycles.getLifecycleDefinition();
                t.addOption(new Option(cycle.getID().toString(), cycle.getLabel()));
            }
        }
    }
}

