/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringIsLettersOrDigitsValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.type.TypeSecurityListener;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.db.Sequences;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.util.Assert;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class ElementAddForm
extends CMSForm {
    private static final Logger s_log = Logger.getLogger(ElementAddForm.class);
    protected final ACSObjectSelectionModel m_types;
    protected Hidden m_id;
    protected TextField m_label;
    protected TextField m_description;
    protected SimpleContainer m_buttons;
    protected Submit m_submit;
    protected Submit m_cancel;

    public ElementAddForm(String formName, String titleLabel, ACSObjectSelectionModel m) {
        super(formName);
        this.m_types = m;
        this.m_id = new Hidden((ParameterModel)new BigDecimalParameter("id"));
        this.add((Component)this.m_id);
        this.m_id.addValidationListener((ParameterListener)new NotNullValidationListener());
        Label heading = new Label(titleLabel);
        heading.setFontWeight("b");
        this.add((Component)heading, 64);
        this.add((Component)new FormErrorDisplay((Form)this), 64);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.name")));
        this.m_label = new TextField((ParameterModel)new TrimmedStringParameter("label"));
        this.m_label.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_label.addValidationListener((ParameterListener)new StringIsLettersOrDigitsValidationListener());
        this.m_label.setSize(40);
        this.m_label.setMaxLength(1000);
        this.add((Component)this.m_label);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.title")));
        this.m_description = new TextField((ParameterModel)new StringParameter("description"));
        this.m_description.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        this.m_description.setSize(40);
        this.add((Component)this.m_description);
        this.m_buttons = new SimpleContainer();
        this.m_submit = new Submit("submit");
        this.m_submit.setButtonLabel("Add Element");
        this.m_buttons.add((Component)this.m_submit);
        this.m_cancel = new Submit("cancel");
        this.m_cancel.setButtonLabel("Cancel");
        this.m_buttons.add((Component)this.m_cancel);
        this.addProcessListener(new ProcessListener());
        this.addInitListener(new InitListener());
        this.addSubmissionListener(new TypeSecurityListener());
        this.addSubmissionListener(new SubmissionListener());
        this.addValidationListener(new ValidationListener());
    }

    protected ACSObjectSelectionModel getSelectionModel() {
        return this.m_types;
    }

    protected Hidden getHiddenID() {
        return this.m_id;
    }

    protected TextField getLabelField() {
        return this.m_label;
    }

    protected TextField getDescriptionField() {
        return this.m_description;
    }

    protected SimpleContainer getButtons() {
        return this.m_buttons;
    }

    protected Submit getSubmit() {
        return this.m_submit;
    }

    protected Submit getCancel() {
        return this.m_cancel;
    }

    protected abstract void addAttribute(DynamicObjectType var1, String var2, PageState var3) throws FormProcessException;

    protected abstract void addFormComponent(PersistentForm var1, String var2, PageState var3) throws FormProcessException;

    @Override
    public boolean isCancelled(PageState s) {
        return this.m_cancel.isSelected(s);
    }

    protected void doInit(FormSectionEvent event) {
    }

    protected void doValidate(FormSectionEvent event) throws FormProcessException {
    }

    protected ContentType getContentType(PageState state) {
        ContentType t = (ContentType)this.m_types.getSelectedObject(state);
        Assert.exists((Object)((Object)t), (String)"content type");
        return t;
    }

    protected DynamicObjectType getDOT(ContentType type) {
        DynamicObjectType dot = new DynamicObjectType(type.getAssociatedObjectType());
        return dot;
    }

    private DynamicObjectType getDOT(PageState state) {
        return this.getDOT(this.getContentType(state));
    }

    protected void refreshAuthoring(PageState state) {
        Utilities.refreshItemUI(state);
    }

    protected void addLabelDescript(PersistentForm pForm, String label, String description) {
        PersistentLabel lLabel = PersistentLabel.create((String)(label + ":"));
        lLabel.save();
        pForm.addComponent((PersistentComponent)lLabel);
        PersistentLabel dLabel = null;
        dLabel = description != null ? PersistentLabel.create((String)description) : PersistentLabel.create((String)"");
        dLabel.save();
        pForm.addComponent((PersistentComponent)dLabel);
        pForm.save();
    }

    private final class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public void process(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            String label = (String)ElementAddForm.this.m_label.getValue(state);
            String description = (String)ElementAddForm.this.m_description.getValue(state);
            ContentType type = ElementAddForm.this.getContentType(state);
            DynamicObjectType dot = ElementAddForm.this.getDOT(type);
            ElementAddForm.this.addAttribute(dot, label, state);
            dot.save();
            PersistentForm pForm = type.getItemForm();
            ElementAddForm.this.addLabelDescript(pForm, label, description);
            ElementAddForm.this.addFormComponent(pForm, label, state);
            pForm.save();
            ElementAddForm.this.refreshAuthoring(state);
        }
    }

    private final class SubmissionListener
    implements FormSubmissionListener {
        private SubmissionListener() {
        }

        public void submitted(FormSectionEvent e) throws FormProcessException {
            if (ElementAddForm.this.m_cancel.isSelected(e.getPageState())) {
                throw new FormProcessException("cancelled");
            }
        }
    }

    private final class InitListener
    implements FormInitListener {
        private InitListener() {
        }

        public void init(FormSectionEvent event) {
            PageState state = event.getPageState();
            FormData data = event.getFormData();
            try {
                if (ElementAddForm.this.m_id.getValue(state) == null) {
                    ElementAddForm.this.m_id.setValue(state, (Object)Sequences.getNextValue());
                }
            }
            catch (SQLException ex) {
                s_log.error((Object)"Could not generate Sequence ID", (Throwable)ex);
                data.addError("Could not generate Sequence ID " + ex.getMessage());
            }
            ElementAddForm.this.doInit(event);
        }
    }

    private final class ValidationListener
    implements FormValidationListener {
        private ValidationListener() {
        }

        public void validate(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            String label = (String)ElementAddForm.this.m_label.getValue(state);
            DynamicObjectType dot = ElementAddForm.this.getDOT(state);
            if (dot.hasProperty(label)) {
                throw new FormProcessException("A property named \"" + label.toLowerCase() + "\" already exists.");
            }
            ElementAddForm.this.doValidate(event);
        }
    }
}

