/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.RelationAttributeInterface;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import java.util.StringTokenizer;

public class RelationAttributeList
extends List {
    private ContentTypeRequestLocal m_type;

    public RelationAttributeList(ContentTypeRequestLocal type) {
        super((ListModelBuilder)new RelationAttributeListModelBuilder(type));
        this.m_type = type;
        this.setCellRenderer(new CellRenderer());
    }

    public final boolean isVisible(PageState state) {
        boolean retVal = false;
        ContentType ct = this.m_type.getContentType(state);
        ContentItem ci = null;
        try {
            Class<ContentItem> clazz = Class.forName(ct.getClassName()).asSubclass(ContentItem.class);
            ci = clazz.newInstance();
            if (ci instanceof RelationAttributeInterface) {
                RelationAttributeInterface rai = (RelationAttributeInterface)((Object)ci);
                retVal = rai.hasRelationAttributes();
            }
            ci.delete();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    private class CellRenderer
    implements ListCellRenderer {
        private CellRenderer() {
        }

        public final Component getComponent(final List list, PageState state, Object value, final String key, int index, boolean isSelected) {
            ControlLink link = new ControlLink(key){

                public void setControlEvent(PageState state) {
                    state.setControlEvent((Component)list, "editRelationAttributes", key);
                }
            };
            return link;
        }
    }

    private static class RelationAttributeListModelBuilder
    extends AbstractListModelBuilder {
        private ContentTypeRequestLocal m_type;
        private StringTokenizer relationAttributeList;

        public RelationAttributeListModelBuilder(ContentTypeRequestLocal type) {
            this.m_type = type;
            this.relationAttributeList = null;
        }

        public final ListModel makeModel(List list, PageState state) {
            ContentType ct = this.m_type.getContentType(state);
            ContentItem ci = null;
            try {
                Class<ContentItem> clazz = Class.forName(ct.getClassName()).asSubclass(ContentItem.class);
                ci = clazz.newInstance();
                if (ci instanceof RelationAttributeInterface) {
                    RelationAttributeInterface rai = (RelationAttributeInterface)((Object)ci);
                    this.relationAttributeList = rai.getRelationAttributes();
                }
                ci.delete();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return new Model(this.relationAttributeList);
        }

        private class Model
        implements ListModel {
            private final StringTokenizer m_items;
            private String m_item;

            Model(StringTokenizer items) {
                this.m_items = items;
                this.m_item = null;
            }

            public final boolean next() {
                if (this.m_items.hasMoreTokens()) {
                    this.m_item = this.m_items.nextToken();
                    return true;
                }
                this.m_item = null;
                return false;
            }

            public final Object getElement() {
                return this.m_item;
            }

            public final String getKey() {
                return this.m_item;
            }
        }
    }
}

