/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.ContentSectionRequestLocal;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.RoleCollection;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class TypePermissionsTable
extends Table
implements TableActionListener {
    private final String TABLE_COL_ROLE = "table_col_role";
    private final String TABLE_COL_CAN_USE = "table_col_can_use";
    private final String TABLE_COL_ACTION = "table_col_action";
    private final ContentTypeRequestLocal type;

    public TypePermissionsTable(ContentSectionRequestLocal section, ContentTypeRequestLocal type) {
        this.type = type;
        this.setEmptyView((Component)new Label(GlobalizationUtil.globalize("cms.ui.type.permissions.none")));
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.add(new TableColumn(0, GlobalizationUtil.globalize("cms.ui.type.permissions.role").localize(), (Object)"table_col_role"));
        columnModel.add(new TableColumn(1, GlobalizationUtil.globalize("cms.ui.type.permissions_can_use").localize(), (Object)"table_col_can_use"));
        columnModel.add(new TableColumn(2, GlobalizationUtil.globalize("cms.ui.type.permission.action").localize(), (Object)"table_col_action"));
        this.setModelBuilder(new TypePermissionsTableModelBuilder());
        columnModel.get(0).setCellRenderer((TableCellRenderer)new RoleCellRenderer());
        columnModel.get(1).setCellRenderer((TableCellRenderer)new CanUseCellRenderer());
        columnModel.get(2).setCellRenderer((TableCellRenderer)new ActionCellRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent event) {
        PageState state = event.getPageState();
        TableColumn column = this.getColumnModel().get(event.getColumn().intValue());
        if ("table_col_action".equals(column.getHeaderKey().toString())) {
            Role role = new Role(new BigDecimal(event.getRowKey().toString()));
            ContentType contentType = this.getType().getContentType(state);
            ObjectPermissionCollection permissions = PermissionService.getDirectGrantedPermissions((OID)contentType.getOID());
            if (permissions.size() == 0L) {
                role.grantPermission((ACSObject)contentType, PrivilegeDescriptor.get((String)"cms_new_item"));
            } else if (!role.checkPermission((ACSObject)contentType, PrivilegeDescriptor.get((String)"cms_new_item"))) {
                role.grantPermission((ACSObject)contentType, PrivilegeDescriptor.get((String)"cms_new_item"));
            } else {
                role.revokePermission((ACSObject)contentType, PrivilegeDescriptor.get((String)"cms_new_item"));
            }
        }
    }

    public void headSelected(TableActionEvent event) {
    }

    private ContentTypeRequestLocal getType() {
        return this.type;
    }

    private class ActionCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private ActionCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager securityManager = Utilities.getSecurityManager(state);
            Party party = Kernel.getContext().getParty();
            if (party == null) {
                party = Kernel.getPublicUser();
            }
            if (securityManager.canAccess(party, "content_type_admin")) {
                ControlLink link = new ControlLink((String)GlobalizationUtil.globalize(value.toString()).localize());
                return link;
            }
            return new Label(value.toString());
        }
    }

    private class CanUseCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private CanUseCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            return new Label(GlobalizationUtil.globalize(value.toString()));
        }
    }

    private class RoleCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private RoleCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            return new Label(value.toString());
        }
    }

    private class TypePermissionsTableModel
    implements TableModel {
        private Table table;
        private RoleCollection roles;
        private ContentType contentType;
        private ObjectPermissionCollection permissions;

        public TypePermissionsTableModel(Table table, PageState state) {
            this.table = table;
            this.contentType = ((TypePermissionsTable)table).getType().getContentType(state);
            this.roles = CMS.getContext().getContentSection().getStaffGroup().getRoles();
            this.permissions = PermissionService.getDirectGrantedPermissions((OID)this.contentType.getOID());
        }

        public int getColumnCount() {
            if (this.roles == null) {
                return 0;
            }
            return (int)this.roles.size();
        }

        public boolean nextRow() {
            if (this.roles == null) {
                return false;
            }
            return this.roles.next();
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.roles.getRole().getName();
                }
                case 1: {
                    if (this.permissions.size() == 0L) {
                        return "cms.ui.type.permissions.can_use.yes";
                    }
                    if (this.roles.getRole().checkPermission((ACSObject)this.contentType, PrivilegeDescriptor.get((String)"cms_new_item"))) {
                        return "cms.ui.type.permissions.can_use.yes";
                    }
                    return "cms.ui.type.permissions.can_use.no";
                }
                case 2: {
                    if (this.permissions.size() == 0L) {
                        return "cms.ui.type.permissions.actions.restrict_to_this_role";
                    }
                    if (this.roles.getRole().checkPermission((ACSObject)this.contentType, PrivilegeDescriptor.get((String)"cms_new_item"))) {
                        return "cms.ui.type.permissions.actions.revoke";
                    }
                    return "cms.ui.type.permissions.can_use.grant";
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.roles.getRole().getID();
        }
    }

    private class TypePermissionsTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            return new TypePermissionsTableModel(table, state);
        }
    }
}

