/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.util;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.util.LockableImpl;

public class DefaultTableCellRenderer
extends LockableImpl
implements TableCellRenderer {
    private boolean m_active;
    private ThreadLocal m_label;
    private ThreadLocal m_controlLink;

    public DefaultTableCellRenderer() {
        this(false);
    }

    public DefaultTableCellRenderer(boolean active) {
        this.m_active = active;
        this.m_label = new ThreadLocal(){

            protected Object initialValue() {
                return new Label("");
            }
        };
        this.m_controlLink = new ThreadLocal(){

            protected Object initialValue() {
                return new ControlLink((Component)((Label)DefaultTableCellRenderer.this.m_label.get()));
            }
        };
    }

    public final boolean isActive() {
        return this.m_active;
    }

    public void setActive(boolean v) {
        Assert.isUnlocked((Lockable)this);
        this.m_active = v;
    }

    public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
        if (!this.isLocked() && table != null && table.isLocked()) {
            this.lock();
        }
        Label l = (Label)this.m_label.get();
        if (value == null) {
            l.setLabel((String)GlobalizationUtil.globalize("cms.ui.util.").localize());
            l.setOutputEscaping(false);
        } else {
            l.setLabel((GlobalizedMessage)value);
            l.setOutputEscaping(true);
        }
        l.setFontWeight(isSelected && this.m_active ? "b" : null);
        if (this.m_active && !isSelected) {
            return (ControlLink)this.m_controlLink.get();
        }
        return l;
    }
}

